/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;

public class Stream {
    private final int column;
    private final StreamKind streamKind;
    private final int length;
    private final boolean useVInts;
    private final int sequence;
    private final Optional<Long> offset;

    public Stream(int column, StreamKind streamKind, int length, boolean useVInts) {
        this(column, 0, streamKind, length, useVInts, Optional.empty());
    }

    public Stream(int column, int sequence, StreamKind streamKind, int length, boolean useVInts) {
        this(column, sequence, streamKind, length, useVInts, Optional.empty());
    }

    public Stream(int column, int sequence, StreamKind streamKind, int length, boolean useVInts, Optional<Long> offset) {
        this.column = column;
        this.streamKind = Objects.requireNonNull(streamKind, "streamKind is null");
        this.length = length;
        this.useVInts = useVInts;
        this.sequence = sequence;
        this.offset = Objects.requireNonNull(offset, "offset is null");
    }

    public int getColumn() {
        return this.column;
    }

    public StreamKind getStreamKind() {
        return this.streamKind;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isUseVInts() {
        return this.useVInts;
    }

    public int getSequence() {
        return this.sequence;
    }

    public Optional<Long> getOffset() {
        return this.offset;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("column", this.column).add("streamKind", (Object)this.streamKind).add("length", this.length).add("useVInts", this.useVInts).add("sequence", this.sequence).add("offset", this.offset).toString();
    }

    public Stream withOffset(long offset) {
        return new Stream(this.column, this.sequence, this.streamKind, this.length, this.useVInts, Optional.of(offset));
    }

    public static enum StreamKind {
        PRESENT,
        DATA,
        LENGTH,
        DICTIONARY_DATA,
        DICTIONARY_COUNT,
        SECONDARY,
        ROW_INDEX,
        BLOOM_FILTER,
        BLOOM_FILTER_UTF8,
        IN_DICTIONARY,
        ROW_GROUP_DICTIONARY,
        ROW_GROUP_DICTIONARY_LENGTH,
        IN_MAP;

    }
}

