/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.StreamId;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.facebook.presto.orc.stream.ValueInputStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class InputStreamSources {
    private final Map<StreamId, InputStreamSource<?>> streamSources;

    public InputStreamSources(Map<StreamId, InputStreamSource<?>> streamSources) {
        this.streamSources = ImmutableMap.copyOf(Objects.requireNonNull(streamSources, "streamSources is null"));
    }

    public <S extends ValueInputStream<?>> InputStreamSource<S> getInputStreamSource(StreamDescriptor streamDescriptor, Stream.StreamKind streamKind, Class<S> streamType) {
        Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        Objects.requireNonNull(streamType, "streamType is null");
        InputStreamSource<Object> streamSource = this.streamSources.get(new StreamId(streamDescriptor.getStreamId(), streamDescriptor.getSequence(), streamKind));
        if (streamSource == null) {
            streamSource = MissingInputStreamSource.missingStreamSource(streamType);
        }
        Preconditions.checkArgument((boolean)streamType.isAssignableFrom(streamSource.getStreamType()), (String)"%s must be of type %s, not %s", (Object)streamDescriptor, (Object)streamType.getName(), (Object)streamSource.getStreamType().getName());
        return streamSource;
    }
}

