/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.stream;

import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcOutputBuffer;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamV1Checkpoint;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.stream.LongDecode;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class LongOutputStreamV1
implements LongOutputStream {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongOutputStreamV1.class).instanceSize();
    private static final int MIN_REPEAT_SIZE = 3;
    private static final long UNMATCHABLE_DELTA_VALUE = Long.MAX_VALUE;
    private static final int MAX_DELTA = 127;
    private static final int MIN_DELTA = -128;
    private final Stream.StreamKind streamKind;
    private final OrcOutputBuffer buffer;
    private final List<LongStreamCheckpoint> checkpoints = new ArrayList<LongStreamCheckpoint>();
    private final long[] sequenceBuffer = new long[128];
    private final boolean signed;
    private int size;
    private int runCount;
    private long lastValue;
    private long lastDelta = Long.MAX_VALUE;
    private boolean closed;

    public LongOutputStreamV1(ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, boolean signed, Stream.StreamKind streamKind) {
        this.streamKind = Objects.requireNonNull(streamKind, "streamKind is null");
        this.buffer = new OrcOutputBuffer(columnWriterOptions, dwrfEncryptor);
        this.signed = signed;
    }

    @Override
    public void writeLong(long value) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.size == this.sequenceBuffer.length) {
            this.flushSequence();
        }
        this.sequenceBuffer[this.size] = value;
        ++this.size;
        long delta = value - this.lastValue;
        if (delta == this.lastDelta) {
            ++this.runCount;
            if (this.runCount == 3 && this.size > 3) {
                this.flushLiteralSequence(this.size - 3);
                this.size = 3;
            }
        } else {
            if (this.runCount >= 3) {
                this.flushRleSequence(this.runCount);
                this.sequenceBuffer[0] = value;
                this.size = 1;
            }
            if (this.size == 1 || !LongOutputStreamV1.isValidDelta(delta)) {
                this.runCount = 1;
                this.lastDelta = Long.MAX_VALUE;
            } else {
                this.runCount = 2;
                this.lastDelta = delta;
            }
        }
        this.lastValue = value;
    }

    private static boolean isValidDelta(long delta) {
        return delta >= -128L && delta <= 127L;
    }

    private void flushSequence() {
        if (this.size == 0) {
            return;
        }
        if (this.runCount >= 3) {
            this.flushRleSequence(this.runCount);
        } else {
            this.flushLiteralSequence(this.size);
        }
        this.size = 0;
        this.runCount = 0;
        this.lastValue = 0L;
        this.lastDelta = Long.MAX_VALUE;
    }

    private void flushLiteralSequence(int literalCount) {
        Verify.verify((literalCount > 0 ? 1 : 0) != 0);
        this.buffer.writeByte(-literalCount);
        for (int i = 0; i < literalCount; ++i) {
            LongDecode.writeVLong(this.buffer, this.sequenceBuffer[i], this.signed);
        }
    }

    private void flushRleSequence(int runCount) {
        Verify.verify((runCount > 0 ? 1 : 0) != 0);
        this.buffer.writeByte(runCount - 3);
        this.buffer.writeByte((byte)this.lastDelta);
        long totalDeltaSize = this.lastDelta * (long)(this.runCount - 1);
        long sequenceStartValue = this.lastValue - totalDeltaSize;
        LongDecode.writeVLong(this.buffer, sequenceStartValue, this.signed);
    }

    @Override
    public void recordCheckpoint() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.checkpoints.add(new LongStreamV1Checkpoint(this.size, this.buffer.getCheckpoint()));
    }

    @Override
    public void close() {
        this.closed = true;
        this.flushSequence();
        this.buffer.close();
    }

    @Override
    public List<LongStreamCheckpoint> getCheckpoints() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.copyOf(this.checkpoints);
    }

    @Override
    public StreamDataOutput getStreamDataOutput(int column, int dwrfSequence) {
        return new StreamDataOutput(this.buffer::writeDataTo, new Stream(column, dwrfSequence, this.streamKind, Math.toIntExact(this.buffer.getOutputDataSize()), true));
    }

    @Override
    public long getBufferedBytes() {
        return this.buffer.estimateOutputDataSize() + (long)(8 * this.size);
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.buffer.getRetainedSize() + SizeOf.sizeOf((long[])this.sequenceBuffer);
    }

    @Override
    public void reset() {
        this.size = 0;
        this.runCount = 0;
        this.lastValue = 0L;
        this.lastDelta = Long.MAX_VALUE;
        this.closed = false;
        this.buffer.reset();
        this.checkpoints.clear();
    }
}

