/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DictionaryCompressionOptimizer;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.array.Arrays;
import com.facebook.presto.orc.checkpoint.BooleanStreamCheckpoint;
import com.facebook.presto.orc.checkpoint.LongStreamCheckpoint;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.CompressedMetadataWriter;
import com.facebook.presto.orc.metadata.CompressionKind;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.RowGroupIndex;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamV1;
import com.facebook.presto.orc.stream.LongOutputStreamV2;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public abstract class DictionaryColumnWriter
implements ColumnWriter,
DictionaryCompressionOptimizer.DictionaryColumn {
    protected final int column;
    protected final int dwrfSequence;
    protected final Type type;
    protected final ColumnWriterOptions columnWriterOptions;
    protected final Optional<DwrfDataEncryptor> dwrfEncryptor;
    protected final OrcEncoding orcEncoding;
    protected final MetadataWriter metadataWriter;
    private final LongOutputStream dataStream;
    private final PresentOutputStream presentStream;
    private final CompressedMetadataWriter compressedMetadataWriter;
    private final List<DictionaryRowGroup> rowGroups = new ArrayList<DictionaryRowGroup>();
    private long columnStatisticsRetainedSizeInBytes;
    private int[] rowGroupIndexes;
    private int rowGroupValueCount;
    private long rawBytes;
    private long totalValueCount;
    private long totalNonNullValueCount;
    private boolean closed;
    private boolean inRowGroup;
    private boolean directEncoded;

    public DictionaryColumnWriter(int column, int dwrfSequence, Type type, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, MetadataWriter metadataWriter) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"column is negative");
        Preconditions.checkArgument((dwrfSequence >= 0 ? 1 : 0) != 0, (Object)"sequence is negative");
        this.column = column;
        this.dwrfSequence = dwrfSequence;
        this.type = Objects.requireNonNull(type, "type is null");
        this.columnWriterOptions = Objects.requireNonNull(columnWriterOptions, "columnWriterOptions is null");
        this.dwrfEncryptor = Objects.requireNonNull(dwrfEncryptor, "dwrfEncryptor is null");
        this.orcEncoding = Objects.requireNonNull(orcEncoding, "orcEncoding is null");
        LongOutputStream result = orcEncoding == OrcEncoding.DWRF ? new LongOutputStreamV1(columnWriterOptions, dwrfEncryptor, false, Stream.StreamKind.DATA) : new LongOutputStreamV2(columnWriterOptions, false, Stream.StreamKind.DATA);
        this.dataStream = result;
        this.presentStream = new PresentOutputStream(columnWriterOptions, dwrfEncryptor);
        this.metadataWriter = Objects.requireNonNull(metadataWriter, "metadataWriter is null");
        this.compressedMetadataWriter = new CompressedMetadataWriter(metadataWriter, columnWriterOptions, dwrfEncryptor);
        this.rowGroupIndexes = new int[10000];
    }

    protected abstract ColumnWriter createDirectColumnWriter();

    protected abstract ColumnWriter getDirectColumnWriter();

    protected abstract boolean tryConvertRowGroupToDirect(int var1, int[] var2, int var3);

    protected abstract ColumnEncoding getDictionaryColumnEncoding();

    protected abstract BlockStatistics addBlockToDictionary(Block var1, int var2, int[] var3);

    protected abstract long getRetainedDictionaryBytes();

    protected abstract Optional<int[]> writeDictionary();

    protected abstract void writePresentAndDataStreams(int var1, int[] var2, Optional<int[]> var3, PresentOutputStream var4, LongOutputStream var5);

    protected abstract void resetDictionary();

    protected abstract void closeDictionary();

    protected abstract List<StreamDataOutput> getDictionaryStreams(int var1);

    protected abstract ColumnStatistics createColumnStatistics();

    @Override
    public long getRawBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.rawBytes;
    }

    @Override
    public boolean isDirectEncoded() {
        return this.directEncoded;
    }

    @Override
    public int getIndexBytes() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return Math.toIntExact((long)DictionaryCompressionOptimizer.estimateIndexBytesPerValue(this.getDictionaryEntries()) * this.getNonNullValueCount());
    }

    @Override
    public long getValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalValueCount;
    }

    @Override
    public long getNonNullValueCount() {
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        return this.totalNonNullValueCount;
    }

    @Override
    public OptionalInt tryConvertToDirect(int maxDirectBytes) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        ColumnWriter directWriter = this.createDirectColumnWriter();
        Preconditions.checkState((directWriter.getBufferedBytes() == 0L ? 1 : 0) != 0);
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            directWriter.beginRowGroup();
            boolean success = this.tryConvertRowGroupToDirect(rowGroup.getValueCount(), rowGroup.getDictionaryIndexes(), maxDirectBytes);
            directWriter.finishRowGroup();
            if (success) continue;
            directWriter.close();
            directWriter.reset();
            return OptionalInt.empty();
        }
        if (this.inRowGroup) {
            directWriter.beginRowGroup();
            if (!this.tryConvertRowGroupToDirect(this.rowGroupValueCount, this.rowGroupIndexes, maxDirectBytes)) {
                directWriter.close();
                directWriter.reset();
                return OptionalInt.empty();
            }
        } else {
            Preconditions.checkState((this.rowGroupValueCount == 0 ? 1 : 0) != 0);
        }
        this.rowGroups.clear();
        this.rawBytes = 0L;
        this.totalValueCount = 0L;
        this.totalNonNullValueCount = 0L;
        this.rowGroupValueCount = 0;
        this.closeDictionary();
        this.resetDictionary();
        this.directEncoded = true;
        return OptionalInt.of(Math.toIntExact(directWriter.getBufferedBytes()));
    }

    @Override
    public Map<Integer, ColumnEncoding> getColumnEncodings() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getColumnEncodings();
        }
        return ImmutableMap.of((Object)this.column, (Object)this.getDictionaryColumnEncoding());
    }

    @Override
    public void beginRowGroup() {
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.inRowGroup = true;
        if (this.directEncoded) {
            this.getDirectColumnWriter().beginRowGroup();
        }
    }

    @Override
    public void writeBlock(Block block) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        if (this.directEncoded) {
            this.getDirectColumnWriter().writeBlock(block);
            return;
        }
        this.rowGroupIndexes = Arrays.ensureCapacity(this.rowGroupIndexes, this.rowGroupValueCount + block.getPositionCount(), Arrays.ExpansionFactor.MEDIUM, Arrays.ExpansionOption.PRESERVE);
        BlockStatistics blockStatistics = this.addBlockToDictionary(block, this.rowGroupValueCount, this.rowGroupIndexes);
        this.totalNonNullValueCount += (long)blockStatistics.getNonNullValueCount();
        this.rawBytes += blockStatistics.getRawBytes();
        this.rowGroupValueCount += block.getPositionCount();
        this.totalValueCount += (long)block.getPositionCount();
    }

    @Override
    public Map<Integer, ColumnStatistics> finishRowGroup() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.inRowGroup);
        this.inRowGroup = false;
        if (this.directEncoded) {
            return this.getDirectColumnWriter().finishRowGroup();
        }
        ColumnStatistics statistics = this.createColumnStatistics();
        DictionaryRowGroup rowGroup = new DictionaryRowGroup(this.rowGroupIndexes, this.rowGroupValueCount, statistics);
        this.rowGroups.add(rowGroup);
        this.columnStatisticsRetainedSizeInBytes += rowGroup.getColumnStatistics().getRetainedSizeInBytes();
        this.rowGroupValueCount = 0;
        return ImmutableMap.of((Object)this.column, (Object)statistics);
    }

    @Override
    public void close() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkState((!this.inRowGroup ? 1 : 0) != 0);
        this.closed = true;
        if (this.directEncoded) {
            this.getDirectColumnWriter().close();
        } else {
            this.bufferOutputData();
        }
    }

    @Override
    public Map<Integer, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getColumnStripeStatistics();
        }
        return ImmutableMap.of((Object)this.column, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroups.stream().map(DictionaryRowGroup::getColumnStatistics).collect(Collectors.toList())));
    }

    private void bufferOutputData() {
        Preconditions.checkState((boolean)this.closed);
        Preconditions.checkState((!this.directEncoded ? 1 : 0) != 0);
        Optional<int[]> originalDictionaryToSortedIndex = this.writeDictionary();
        if (!this.rowGroups.isEmpty()) {
            this.presentStream.recordCheckpoint();
            this.dataStream.recordCheckpoint();
        }
        for (DictionaryRowGroup rowGroup : this.rowGroups) {
            this.writePresentAndDataStreams(rowGroup.getValueCount(), rowGroup.getDictionaryIndexes(), originalDictionaryToSortedIndex, this.presentStream, this.dataStream);
            this.presentStream.recordCheckpoint();
            this.dataStream.recordCheckpoint();
        }
        this.closeDictionary();
        this.dataStream.close();
        this.presentStream.close();
    }

    @Override
    public List<StreamDataOutput> getIndexStreams() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getIndexStreams();
        }
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List dataCheckpoints = this.dataStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        for (int i = 0; i < this.rowGroups.size(); ++i) {
            int groupId = i;
            ColumnStatistics columnStatistics = this.rowGroups.get(groupId).getColumnStatistics();
            LongStreamCheckpoint dataCheckpoint = (LongStreamCheckpoint)dataCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = DictionaryColumnWriter.createSliceColumnPositionList(this.columnWriterOptions.getCompressionKind() != CompressionKind.NONE, dataCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = this.compressedMetadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.column, this.dwrfSequence, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    private static List<Integer> createSliceColumnPositionList(boolean compressed, LongStreamCheckpoint dataCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getDataStreams();
        }
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.column, this.dwrfSequence).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.column, this.dwrfSequence));
        outputDataStreams.addAll(this.getDictionaryStreams(this.column));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.directEncoded) {
            return this.getDirectColumnWriter().getBufferedBytes();
        }
        return this.getIndexBytes() + this.getDictionaryBytes();
    }

    @Override
    public long getRetainedBytes() {
        return SizeOf.sizeOf((int[])this.rowGroupIndexes) + this.dataStream.getRetainedBytes() + this.presentStream.getRetainedBytes() + this.getRetainedDictionaryBytes() + this.columnStatisticsRetainedSizeInBytes;
    }

    @Override
    public void reset() {
        Preconditions.checkState((boolean)this.closed);
        this.closed = false;
        this.dataStream.reset();
        this.presentStream.reset();
        this.rowGroups.clear();
        this.columnStatisticsRetainedSizeInBytes = 0L;
        this.rowGroupValueCount = 0;
        this.resetDictionary();
        this.rawBytes = 0L;
        this.totalValueCount = 0L;
        this.totalNonNullValueCount = 0L;
        if (this.directEncoded) {
            this.directEncoded = false;
            this.getDirectColumnWriter().reset();
        }
    }

    static class BlockStatistics {
        private final int nonNullValueCount;
        private final long rawBytes;

        public BlockStatistics(int nonNullValueCount, long rawBytes) {
            this.nonNullValueCount = nonNullValueCount;
            this.rawBytes = rawBytes;
        }

        public int getNonNullValueCount() {
            return this.nonNullValueCount;
        }

        public long getRawBytes() {
            return this.rawBytes;
        }
    }

    private static class DictionaryRowGroup {
        private final int[] dictionaryIndexes;
        private final ColumnStatistics columnStatistics;

        public DictionaryRowGroup(int[] dictionaryIndexes, int valueCount, ColumnStatistics columnStatistics) {
            Objects.requireNonNull(dictionaryIndexes, "dictionaryIndexes is null");
            Preconditions.checkArgument((valueCount >= 0 ? 1 : 0) != 0, (Object)"valueCount is negative");
            Objects.requireNonNull(columnStatistics, "columnStatistics is null");
            this.dictionaryIndexes = java.util.Arrays.copyOf(dictionaryIndexes, valueCount);
            this.columnStatistics = columnStatistics;
        }

        public int[] getDictionaryIndexes() {
            return this.dictionaryIndexes;
        }

        public int getValueCount() {
            return this.dictionaryIndexes.length;
        }

        public ColumnStatistics getColumnStatistics() {
            return this.columnStatistics;
        }
    }
}

