/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.VariableWidthBlockBuilder;
import com.facebook.presto.orc.array.IntBigArray;
import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.HashCommon;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionaryBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionaryBuilder.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private final IntBigArray blockPositionByHash = new IntBigArray();
    private VariableWidthBlockBuilder elementBlock;
    private int maxFill;
    private int hashMask;

    public SliceDictionaryBuilder(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"expectedSize must not be negative");
        int expectedEntries = Math.min(expectedSize, 32768);
        this.elementBlock = new VariableWidthBlockBuilder(null, expectedEntries, expectedEntries * 32);
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = SliceDictionaryBuilder.calculateMaxFill(hashSize);
        this.hashMask = hashSize - 1;
        this.blockPositionByHash.ensureCapacity(hashSize);
        this.blockPositionByHash.fill(-1);
    }

    public long getSizeInBytes() {
        return this.elementBlock.getSizeInBytes();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.elementBlock.getRetainedSizeInBytes() + this.blockPositionByHash.sizeOf();
    }

    public int compareIndex(int left, int right) {
        return this.elementBlock.compareTo(left, 0, this.elementBlock.getSliceLength(left), (Block)this.elementBlock, right, 0, this.elementBlock.getSliceLength(right));
    }

    public int getSliceLength(int position) {
        return this.elementBlock.getSliceLength(position);
    }

    public Slice getSlice(int position, int length) {
        return this.elementBlock.getSlice(position, 0, length);
    }

    public Slice getRawSlice(int position) {
        return this.elementBlock.getRawSlice(position);
    }

    public int getRawSliceOffset(int position) {
        return this.elementBlock.getPositionOffset(position);
    }

    public void clear() {
        this.blockPositionByHash.fill(-1);
        this.elementBlock = (VariableWidthBlockBuilder)this.elementBlock.newBlockBuilderLike(null);
    }

    public int putIfAbsent(Block block, int position) {
        Objects.requireNonNull(block, "block must not be null");
        long hashPosition = this.getHashPositionOfElement(block, position);
        int blockPosition = this.blockPositionByHash.get(hashPosition) != -1 ? this.blockPositionByHash.get(hashPosition) : this.addNewElement(hashPosition, block, position);
        return blockPosition;
    }

    public int getEntryCount() {
        return this.elementBlock.getPositionCount();
    }

    private long getHashPositionOfElement(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"position is null");
        int length = block.getSliceLength(position);
        long hashPosition = this.getMaskedHash(block.hash(position, 0, length));
        int blockPosition;
        while ((blockPosition = this.blockPositionByHash.get(hashPosition)) != -1) {
            if (this.elementBlock.getSliceLength(blockPosition) == length && block.equals(position, 0, (Block)this.elementBlock, blockPosition, 0, length)) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return hashPosition;
    }

    private long getRehashPositionOfElement(Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"position is null");
        int length = block.getSliceLength(position);
        long hashPosition = this.getMaskedHash(block.hash(position, 0, length));
        while (this.blockPositionByHash.get(hashPosition) != -1) {
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return hashPosition;
    }

    private int addNewElement(long hashPosition, Block block, int position) {
        Preconditions.checkArgument((!block.isNull(position) ? 1 : 0) != 0, (Object)"position is null");
        block.writeBytesTo(position, 0, block.getSliceLength(position), (BlockBuilder)this.elementBlock);
        this.elementBlock.closeEntry();
        int newElementPositionInBlock = this.elementBlock.getPositionCount() - 1;
        this.blockPositionByHash.set(hashPosition, newElementPositionInBlock);
        if (this.elementBlock.getPositionCount() >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
        return newElementPositionInBlock;
    }

    private void rehash(int size) {
        int newHashSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        this.hashMask = newHashSize - 1;
        this.maxFill = SliceDictionaryBuilder.calculateMaxFill(newHashSize);
        this.blockPositionByHash.ensureCapacity(newHashSize);
        this.blockPositionByHash.fill(-1);
        for (int blockPosition = 0; blockPosition < this.elementBlock.getPositionCount(); ++blockPosition) {
            this.blockPositionByHash.set(this.getRehashPositionOfElement((Block)this.elementBlock, blockPosition), blockPosition);
        }
    }

    private static int calculateMaxFill(int hashSize) {
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        return maxFill;
    }

    private long getMaskedHash(long rawHash) {
        return rawHash & (long)this.hashMask;
    }
}

