/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.unstable;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.Binder;
import org.skife.jdbi.v2.sqlobject.BinderFactory;
import org.skife.jdbi.v2.sqlobject.BindingAnnotation;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.unstable.ReflectionArrayIterator;

@Retention(value=RetentionPolicy.RUNTIME)
@SqlStatementCustomizingAnnotation(value=CustomizerFactory.class)
@BindingAnnotation(value=BindingFactory.class)
public @interface BindIn {
    public String value();

    public EmptyHandling onEmpty() default EmptyHandling.THROW;

    public static enum EmptyHandling {
        VOID,
        NULL,
        THROW;

        static final String valueNotHandledMessage = "EmptyHandling type on BindIn not handled. Please report this to the jdbi developers.";
    }

    public static final class Util {
        private Util() {
        }

        static Iterator toIterator(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("cannot make iterator of null");
            }
            if (obj instanceof Iterable) {
                return ((Iterable)obj).iterator();
            }
            if (obj.getClass().isArray()) {
                if (obj instanceof Object[]) {
                    return Arrays.asList((Object[])obj).iterator();
                }
                return new ReflectionArrayIterator(obj);
            }
            throw new IllegalArgumentException(Util.getTypeWarning(obj.getClass()));
        }

        static int size(Object obj) {
            if (obj == null) {
                throw new IllegalArgumentException("cannot get size of null");
            }
            if (obj instanceof Collection) {
                return ((Collection)obj).size();
            }
            if (obj instanceof Iterable) {
                Iterable iterable = (Iterable)obj;
                int size = 0;
                for (Object x : iterable) {
                    ++size;
                }
                return size;
            }
            if (obj.getClass().isArray()) {
                return Array.getLength(obj);
            }
            throw new IllegalArgumentException(Util.getTypeWarning(obj.getClass()));
        }

        private static String getTypeWarning(Class type) {
            return "argument must be one of the following: Iterable, or an array/varargs (primitive or complex type); was " + type.getName() + " instead";
        }
    }

    public static class BindingFactory
    implements BinderFactory<BindIn> {
        @Override
        public Binder build(final BindIn bindIn) {
            final String key = bindIn.value();
            return new Binder<Annotation, Object>(){

                @Override
                public void bind(SQLStatement q, Annotation bind, Object arg) {
                    if (arg == null || Util.size(arg) == 0) {
                        switch (bindIn.onEmpty()) {
                            case VOID: {
                                break;
                            }
                            case NULL: {
                                q.bind("__" + key + "_0", (String)null);
                                break;
                            }
                            case THROW: {
                                IllegalArgumentException inner = new IllegalArgumentException("argument is null; null was explicitly forbidden on this instance of BindIn");
                                throw new IllegalStateException("Illegal argument value was caught too late. Please report this to the jdbi developers.", inner);
                            }
                            default: {
                                throw new IllegalStateException("EmptyHandling type on BindIn not handled. Please report this to the jdbi developers.");
                            }
                        }
                    } else {
                        Iterator it = Util.toIterator(arg);
                        int i = 0;
                        while (it.hasNext()) {
                            q.bind("__" + key + "_" + i, it.next());
                            ++i;
                        }
                    }
                }
            };
        }
    }

    public static final class CustomizerFactory
    implements SqlStatementCustomizerFactory {
        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            throw new UnsupportedOperationException("Not supported on method");
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            throw new UnsupportedOperationException("Not supported on type");
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            int size;
            BindIn bindIn;
            block14: {
                block13: {
                    bindIn = (BindIn)annotation;
                    if (arg != null) break block13;
                    switch (bindIn.onEmpty()) {
                        case VOID: {
                            size = 0;
                            break block14;
                        }
                        case NULL: {
                            size = 1;
                            break block14;
                        }
                        case THROW: {
                            throw new IllegalArgumentException("argument is null; null was explicitly forbidden on this instance of BindIn");
                        }
                        default: {
                            throw new IllegalStateException("EmptyHandling type on BindIn not handled. Please report this to the jdbi developers.");
                        }
                    }
                }
                size = Util.size(arg);
            }
            final String key = bindIn.value();
            StringBuilder names = new StringBuilder();
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    names.append(",");
                }
                names.append(":__").append(key).append("_").append(i);
            }
            if (size == 0) {
                switch (bindIn.onEmpty()) {
                    case VOID: {
                        break;
                    }
                    case NULL: {
                        names.append((String)null);
                        break;
                    }
                    case THROW: {
                        throw new IllegalArgumentException("argument is empty; emptiness was explicitly forbidden on this instance of BindIn");
                    }
                    default: {
                        throw new IllegalStateException("EmptyHandling type on BindIn not handled. Please report this to the jdbi developers.");
                    }
                }
            }
            final String ns = names.toString();
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement q) {
                    q.define(key, ns);
                }
            };
        }
    }
}

