/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConditionalModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.dbpool.H2EmbeddedDataSourceModule;
import com.facebook.airlift.dbpool.MySqlDataSource;
import com.facebook.airlift.dbpool.MySqlDataSourceConfig;
import com.facebook.airlift.discovery.client.ServiceDescriptor;
import com.facebook.airlift.discovery.client.ServiceSelector;
import com.facebook.airlift.discovery.client.testing.StaticServiceSelector;
import com.facebook.presto.raptor.RaptorMetadataFactory;
import com.facebook.presto.raptor.RaptorTableProperties;
import com.facebook.presto.raptor.metadata.DatabaseConfig;
import com.facebook.presto.raptor.metadata.ForMetadata;
import com.facebook.presto.raptor.metadata.H2ShardDao;
import com.facebook.presto.raptor.metadata.JdbcDatabaseConfig;
import com.facebook.presto.raptor.metadata.MySqlShardDao;
import com.facebook.presto.raptor.metadata.ShardDao;
import com.facebook.presto.raptor.util.DaoSupplier;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.sql.DataSource;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.tweak.ConnectionFactory;

public class DatabaseMetadataModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        this.install(ConditionalModule.installModuleIf(DatabaseConfig.class, config -> "mysql".equals(config.getDatabaseType()), innerBinder -> {
            binder.install((Module)new MySqlDataSourceModule());
            DatabaseMetadataModule.bindDaoSupplier(innerBinder, ShardDao.class, MySqlShardDao.class);
        }));
        this.install(ConditionalModule.installModuleIf(DatabaseConfig.class, config -> "h2".equals(config.getDatabaseType()), innerBinder -> {
            binder.install((Module)new H2EmbeddedDataSourceModule("metadata", ForMetadata.class, new Class[0]));
            DatabaseMetadataModule.bindDaoSupplier(binder, ShardDao.class, H2ShardDao.class);
        }));
        binder.bind(RaptorMetadataFactory.class).in(Scopes.SINGLETON);
        binder.bind(RaptorTableProperties.class).in(Scopes.SINGLETON);
    }

    @ForMetadata
    @Singleton
    @Provides
    public ConnectionFactory createConnectionFactory(@ForMetadata DataSource dataSource) {
        return dataSource::getConnection;
    }

    public static <B, T extends B> void bindDaoSupplier(Binder binder, Class<B> baseType, Class<T> type) {
        binder.bind(DatabaseMetadataModule.daoSupplierTypeToken(baseType)).toProvider(new DaoSupplierProvider<T>(type)).in(Scopes.SINGLETON);
    }

    private static <T> TypeLiteral<DaoSupplier<? extends T>> daoSupplierTypeToken(Class<T> type) {
        Type javaType = new TypeToken<DaoSupplier<T>>(){}.where(new TypeParameter<T>(){}, TypeToken.of(type)).getType();
        return TypeLiteral.get((Type)javaType);
    }

    private static class MySqlDataSourceModule
    implements Module {
        private MySqlDataSourceModule() {
        }

        public void configure(Binder binder) {
            ConfigBinder.configBinder((Binder)binder).bindConfig(JdbcDatabaseConfig.class);
            ConfigBinder.configBinder((Binder)binder).bindConfig(MySqlDataSourceConfig.class, ForMetadata.class, "metadata");
            ConfigBinder.configBinder((Binder)binder).bindConfigDefaults(MySqlDataSourceConfig.class, ForMetadata.class, config -> {
                config.setMaxConnections(100);
                config.setDefaultFetchSize(1000);
            });
        }

        @ForMetadata
        @Singleton
        @Provides
        DataSource createDataSource(JdbcDatabaseConfig config, @ForMetadata MySqlDataSourceConfig mysqlConfig) {
            ServiceDescriptor descriptor = ServiceDescriptor.serviceDescriptor((String)"mysql").addProperty("jdbc", config.getUrl()).build();
            return new MySqlDataSource((ServiceSelector)new StaticServiceSelector(new ServiceDescriptor[]{descriptor}), mysqlConfig);
        }
    }

    private static class DaoSupplierProvider<T>
    implements Provider<DaoSupplier<T>> {
        private final Class<T> type;
        private Injector injector;

        public DaoSupplierProvider(Class<T> type) {
            this.type = Objects.requireNonNull(type, "type is null");
        }

        @Inject
        public void setInjector(Injector injector) {
            this.injector = injector;
        }

        public DaoSupplier<T> get() {
            Preconditions.checkState((this.injector != null ? 1 : 0) != 0, (Object)"injector was not set");
            IDBI dbi = (IDBI)this.injector.getInstance(Key.get(IDBI.class, ForMetadata.class));
            return new DaoSupplier(dbi, this.type);
        }
    }
}

