/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.airlift.log.Logger;
import com.facebook.presto.raptor.metadata.SchemaDao;
import io.airlift.units.Duration;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.exceptions.UnableToObtainConnectionException;

public final class SchemaDaoUtil {
    private static final Logger log = Logger.get(SchemaDaoUtil.class);

    private SchemaDaoUtil() {
    }

    /*
     * Loose catch block
     */
    public static void createTablesWithRetry(IDBI dbi) {
        Duration delay = new Duration(2.0, TimeUnit.SECONDS);
        while (true) {
            try (Handle handle = dbi.open();){
                SchemaDaoUtil.createTables((SchemaDao)handle.attach(SchemaDao.class));
                SchemaDaoUtil.alterTables(handle.getConnection(), (SchemaDao)handle.attach(SchemaDao.class));
                return;
            }
            catch (SQLTransientException | UnableToObtainConnectionException e) {
                log.warn("Failed to connect to database. Will retry again in %s. Exception: %s", new Object[]{delay, e.getMessage()});
                SchemaDaoUtil.sleep(delay);
                continue;
            }
            break;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static void createTables(SchemaDao dao) {
        dao.createTableDistributions();
        dao.createTableTables();
        dao.createTableColumns();
        dao.createTableViews();
        dao.createTableNodes();
        dao.createTableShards();
        dao.createTableShardNodes();
        dao.createTableExternalBatches();
        dao.createTableTransactions();
        dao.createTableCreatedShards();
        dao.createTableDeletedShards();
        dao.createTableBuckets();
        dao.createTableShardOrganizerJobs();
    }

    private static void alterTables(Connection connection, SchemaDao dao) throws SQLException {
        SchemaDaoUtil.alterTable(dao::alterTableTablesWithDeltaDelete, "tables", "table_supports_delta_delete", connection);
        SchemaDaoUtil.alterTable(dao::alterTableTablesWithDeltaCount, "tables", "delta_count", connection);
        SchemaDaoUtil.alterTable(dao::alterTableShardsWithIsDelta, "shards", "is_delta", connection);
        SchemaDaoUtil.alterTable(dao::alterTableShardsWithDeltaUuid, "shards", "delta_uuid", connection);
    }

    public static void alterTable(Runnable alterTableFunction, String tableName, String columnName, Connection connection) throws SQLException {
        if (!SchemaDaoUtil.findColumnName(tableName, columnName, connection)) {
            log.info("Alter table %s, add column %s", new Object[]{tableName, columnName});
            alterTableFunction.run();
        }
    }

    public static boolean findColumnName(String tableName, String columnName, Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet results = statement.executeQuery("SELECT * FROM " + tableName + " LIMIT 0");
        ResultSetMetaData metadata = results.getMetaData();
        int columnCount = metadata.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            if (!columnName.equalsIgnoreCase(metadata.getColumnName(i + 1))) continue;
            return true;
        }
        return false;
    }

    public static void sleep(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }
}

