/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.metadata.DatabaseShardManager;
import com.facebook.presto.raptor.util.UuidUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;

public class ShardsAndIndexDeleter
implements AutoCloseable {
    private final PreparedStatement deleteShardStatement;
    private final PreparedStatement deleteShardEmptyDeltaStatement;
    private final PreparedStatement deleteIndexStatement;
    private final PreparedStatement deleteIndexEmptyDeltaStatement;

    public ShardsAndIndexDeleter(Connection connection, long tableId) throws SQLException {
        String deleteIndexSql = "DELETE FROM " + DatabaseShardManager.shardIndexTable(tableId) + " \n  WHERE shard_id = ? AND delta_shard_uuid = ?";
        String deleteIndexSqlEmptyDelta = "DELETE FROM " + DatabaseShardManager.shardIndexTable(tableId) + " \n  WHERE shard_id = ? AND delta_shard_uuid IS NULL";
        String deleteShardSql = "DELETE FROM shards \n  WHERE shard_id = ? AND delta_uuid = ?";
        String deleteShardSqlEmptyDelta = "DELETE FROM shards \n  WHERE shard_id = ? AND delta_uuid IS NULL";
        this.deleteIndexStatement = connection.prepareStatement(deleteIndexSql);
        this.deleteIndexEmptyDeltaStatement = connection.prepareStatement(deleteIndexSqlEmptyDelta);
        this.deleteShardStatement = connection.prepareStatement(deleteShardSql);
        this.deleteShardEmptyDeltaStatement = connection.prepareStatement(deleteShardSqlEmptyDelta);
    }

    public void delete(Long id, Optional<UUID> deltaUuid) throws SQLException {
        if (deltaUuid.isPresent()) {
            this.deleteShardStatement.setLong(1, id);
            this.deleteShardStatement.setBytes(2, UuidUtil.uuidToBytes(deltaUuid.get()));
            this.deleteShardStatement.addBatch();
            this.deleteIndexStatement.setLong(1, id);
            this.deleteIndexStatement.setBytes(2, UuidUtil.uuidToBytes(deltaUuid.get()));
            this.deleteIndexStatement.addBatch();
        } else {
            this.deleteShardEmptyDeltaStatement.setLong(1, id);
            this.deleteShardEmptyDeltaStatement.addBatch();
            this.deleteIndexEmptyDeltaStatement.setLong(1, id);
            this.deleteIndexEmptyDeltaStatement.addBatch();
        }
    }

    public int execute() throws SQLException {
        int shardsUpdatedCount = 0;
        int indexUpdatedCount = 0;
        shardsUpdatedCount += ShardsAndIndexDeleter.updatedCount(this.deleteShardStatement.executeBatch());
        indexUpdatedCount += ShardsAndIndexDeleter.updatedCount(this.deleteIndexStatement.executeBatch());
        if ((shardsUpdatedCount += ShardsAndIndexDeleter.updatedCount(this.deleteShardEmptyDeltaStatement.executeBatch())) != (indexUpdatedCount += ShardsAndIndexDeleter.updatedCount(this.deleteIndexEmptyDeltaStatement.executeBatch()))) {
            throw DatabaseShardManager.transactionConflict();
        }
        return shardsUpdatedCount;
    }

    @Override
    public void close() throws SQLException {
        this.deleteShardStatement.close();
        this.deleteShardEmptyDeltaStatement.close();
        this.deleteIndexStatement.close();
        this.deleteIndexEmptyDeltaStatement.close();
    }

    static int updatedCount(int[] executeBatch) {
        return Arrays.stream(executeBatch).sum();
    }
}

