/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.airlift.json.smile;

import com.facebook.airlift.json.Codec;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

public class CodecUtils {
    private CodecUtils() {
    }

    public static <T> byte[] serializeCompressed(Codec<T> codec, T instance) {
        ByteArrayOutputStream rawOutput = new ByteArrayOutputStream();
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        try (DeflaterOutputStream deflateOutput = new DeflaterOutputStream((OutputStream)rawOutput, deflater);){
            codec.writeBytes(deflateOutput, instance);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return rawOutput.toByteArray();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T deserializeCompressed(Codec<T> codec, byte[] bytes) {
        try (InflaterInputStream inflateInput = new InflaterInputStream(new ByteArrayInputStream(bytes));){
            T t = codec.readBytes(inflateInput);
            return t;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

