/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hadoop.$internal.org.mortbay.util.ajax;

import com.facebook.presto.hadoop.$internal.org.mortbay.util.Loader;
import com.facebook.presto.hadoop.$internal.org.mortbay.util.ajax.JSON;
import com.facebook.presto.hadoop.$internal.org.mortbay.util.ajax.JSONPojoConvertor;
import java.util.Map;

public class JSONPojoConvertorFactory
implements JSON.Convertor {
    private final JSON _json;
    private final boolean _fromJSON;

    public JSONPojoConvertorFactory(JSON json) {
        this._json = json;
        this._fromJSON = true;
        if (json == null) {
            throw new IllegalArgumentException();
        }
    }

    public JSONPojoConvertorFactory(JSON json, boolean fromJSON) {
        this._json = json;
        this._fromJSON = fromJSON;
        if (json == null) {
            throw new IllegalArgumentException();
        }
    }

    public void toJSON(Object obj, JSON.Output out) {
        String clsName = obj.getClass().getName();
        JSON.Convertor convertor = this._json.getConvertorFor(clsName);
        if (convertor == null) {
            try {
                Class cls = Loader.loadClass(JSON.class, clsName);
                convertor = new JSONPojoConvertor(cls, this._fromJSON);
                this._json.addConvertorFor(clsName, convertor);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (convertor != null && obj.getClass() != Object.class) {
            convertor.toJSON(obj, out);
        } else {
            out.add(obj.toString());
        }
    }

    public Object fromJSON(Map object) {
        Map map = object;
        String clsName = (String)map.get("class");
        if (clsName != null) {
            JSON.Convertor convertor = this._json.getConvertorFor(clsName);
            if (convertor == null) {
                try {
                    Class cls = Loader.loadClass(JSON.class, clsName);
                    convertor = new JSONPojoConvertor(cls);
                    this._json.addConvertorFor(clsName, convertor);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (convertor != null && !clsName.equals(Object.class.getName())) {
                return convertor.fromJSON(object);
            }
        }
        return map;
    }
}

