/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.regex.Matcher;
import org.skife.jdbi.org.antlr.runtime.ANTLRInputStream;
import org.skife.jdbi.org.antlr.runtime.Token;
import org.skife.jdbi.v2.SqlScriptParser;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.tweak.StatementLocator;

public class ClasspathStatementLocator
implements StatementLocator {
    private final Map<CacheKey, String> found = Collections.synchronizedMap(new WeakHashMap());
    private static final String SEP = "/";
    private static final SqlScriptParser SQL_SCRIPT_PARSER = new SqlScriptParser(new SqlScriptParser.TokenHandler(){

        @Override
        public void handle(Token t, StringBuilder sb) {
            sb.append(t.getText());
        }
    });

    public static boolean looksLikeSql(String sql) {
        String local = ClasspathStatementLocator.left(ClasspathStatementLocator.stripStart(sql), 8).toLowerCase();
        return local.startsWith("insert ") || local.startsWith("update ") || local.startsWith("select ") || local.startsWith("call ") || local.startsWith("delete ") || local.startsWith("create ") || local.startsWith("alter ") || local.startsWith("merge ") || local.startsWith("replace ") || local.startsWith("drop ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SuppressFBWarnings(value={"DM_STRING_CTOR"})
    public String locate(String name, StatementContext ctx) {
        CacheKey cache_key = new CacheKey(name, ctx.getSqlObjectType(), ctx.getSqlObjectMethod());
        boolean isSqlObjectMethod = ctx.getSqlObjectType() != null && ctx.getSqlObjectMethod() != null;
        String cached = this.found.get(cache_key);
        if (cached != null) {
            return cached;
        }
        if (ClasspathStatementLocator.looksLikeSql(name)) {
            if (isSqlObjectMethod) {
                this.found.put(cache_key, name);
            }
            return name;
        }
        ClassLoader loader = ClasspathStatementLocator.selectClassLoader();
        InputStream in_stream = null;
        try {
            String sql;
            String filename;
            in_stream = loader.getResourceAsStream(name);
            if (in_stream == null) {
                in_stream = loader.getResourceAsStream(name + ".sql");
            }
            if (in_stream == null && ctx.getSqlObjectType() != null && (in_stream = loader.getResourceAsStream(filename = '/' + ClasspathStatementLocator.mungify(ctx.getSqlObjectType().getName() + '.' + name) + ".sql")) == null) {
                in_stream = ctx.getSqlObjectType().getResourceAsStream(filename);
            }
            if (in_stream == null) {
                this.found.put(cache_key, isSqlObjectMethod ? name : new String(name));
                filename = name;
                return filename;
            }
            try {
                sql = SQL_SCRIPT_PARSER.parse(new ANTLRInputStream(in_stream));
            }
            catch (IOException e) {
                throw new UnableToCreateStatementException(e.getMessage(), e, ctx);
            }
            this.found.put(cache_key, sql);
            String string = sql;
            return string;
        }
        finally {
            try {
                if (in_stream != null) {
                    in_stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static ClassLoader selectClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader() != null ? Thread.currentThread().getContextClassLoader() : ClasspathStatementLocator.class.getClassLoader();
        return loader;
    }

    private static boolean isComment(String line) {
        return line.startsWith("#") || line.startsWith("--") || line.startsWith("//");
    }

    private static String mungify(String path) {
        return path.replaceAll("\\.", Matcher.quoteReplacement(SEP));
    }

    private static String stripStart(String str) {
        int start;
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return "";
        }
        for (start = 0; start != strLen && Character.isWhitespace(str.charAt(start)); ++start) {
        }
        return str.substring(start);
    }

    private static String left(String str, int len) {
        if (str == null || len < 0) {
            return "";
        }
        if (str.length() <= len) {
            return str;
        }
        return str.substring(0, len);
    }

    private static class CacheKey {
        final String name;
        final Class<?> sqlObjectType;
        final Method sqlObjectMethod;

        CacheKey(String name, Class<?> sqlObjectType, Method sqlObjectMethod) {
            this.name = name;
            this.sqlObjectType = sqlObjectType;
            this.sqlObjectMethod = sqlObjectMethod;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return this.eq(this.name, that.name) && this.eq(this.sqlObjectType, that.sqlObjectType) && this.eq(this.sqlObjectMethod, that.sqlObjectMethod);
        }

        private boolean eq(Object left, Object right) {
            return left == null ? right == null : left.equals(right);
        }

        public int hashCode() {
            int result = this.name == null ? 0 : this.name.hashCode();
            result = 31 * result + (this.sqlObjectType != null ? this.sqlObjectType.hashCode() : 0);
            result = 31 * result + (this.sqlObjectMethod != null ? this.sqlObjectMethod.hashCode() : 0);
            return result;
        }
    }
}

