/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.zorder;

import com.facebook.presto.hive.zorder.ZAddressRange;
import com.facebook.presto.hive.zorder.ZValueRange;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ZOrder {
    public static final int MAX_INPUT_DIMENSIONS = 10;
    private final List<Integer> encodingBits;
    private final boolean positiveIntegersOnly;
    private final int totalBitLength;
    private final int maxBitLength;
    private final int[] dimensions;

    public ZOrder(List<Integer> encodingBits, boolean positiveIntegersOnly) {
        Objects.requireNonNull(encodingBits, "Encoding bits list should not be null.");
        Preconditions.checkArgument((!encodingBits.isEmpty() ? 1 : 0) != 0, (Object)"Encoding bits list should not be empty.");
        this.encodingBits = encodingBits;
        this.positiveIntegersOnly = positiveIntegersOnly;
        int totalBitLength = encodingBits.stream().mapToInt(Integer::intValue).sum();
        int maxBitLength = encodingBits.stream().mapToInt(Integer::intValue).max().getAsInt();
        this.totalBitLength = positiveIntegersOnly ? totalBitLength : totalBitLength + encodingBits.size();
        this.maxBitLength = positiveIntegersOnly ? maxBitLength : maxBitLength + 1;
        this.dimensions = this.initializeDimensions();
    }

    public ZOrder(List<Integer> encodingBits) {
        this(encodingBits, false);
    }

    private int[] initializeDimensions() {
        int[] dimensions = new int[this.maxBitLength];
        ArrayList<Integer> bitLengths = new ArrayList<Integer>(this.encodingBits);
        if (this.positiveIntegersOnly) {
            for (int dimensionIndex = this.maxBitLength - 1; dimensionIndex >= 0; --dimensionIndex) {
                for (int bitLengthIndex = 0; bitLengthIndex < bitLengths.size(); ++bitLengthIndex) {
                    if ((Integer)bitLengths.get(bitLengthIndex) <= 0) continue;
                    int n = dimensionIndex;
                    dimensions[n] = dimensions[n] + 1;
                    bitLengths.set(bitLengthIndex, (Integer)bitLengths.get(bitLengthIndex) - 1);
                }
            }
        } else {
            for (int dimensionIndex = this.maxBitLength - 1; dimensionIndex >= 0; --dimensionIndex) {
                for (int bitLengthIndex = 0; bitLengthIndex < bitLengths.size(); ++bitLengthIndex) {
                    if ((Integer)bitLengths.get(bitLengthIndex) < 0) continue;
                    int n = dimensionIndex;
                    dimensions[n] = dimensions[n] + 1;
                    bitLengths.set(bitLengthIndex, (Integer)bitLengths.get(bitLengthIndex) - 1);
                }
            }
        }
        return dimensions;
    }

    public byte[] encodeToByteArray(List<Integer> input) {
        int bitIndex;
        this.checkEncodeInputValidity(input);
        byte[] address = new byte[this.totalBitLength + 7 >> 3];
        if (!this.positiveIntegersOnly) {
            bitIndex = this.totalBitLength - 1;
            for (int value : input) {
                int signBit = value < 0 ? 0 : 1;
                int n = bitIndex >> 3;
                address[n] = (byte)(address[n] | signBit << (bitIndex & 7));
                --bitIndex;
            }
        }
        bitIndex = this.positiveIntegersOnly ? this.totalBitLength - 1 : this.totalBitLength - this.encodingBits.size() - 1;
        for (int bitsProcessed = 0; bitsProcessed < this.maxBitLength; ++bitsProcessed) {
            for (int index = 0; index < input.size(); ++index) {
                if (bitsProcessed >= this.encodingBits.get(index)) continue;
                int bitPosition = this.encodingBits.get(index) - bitsProcessed - 1;
                byte maskedBit = (byte)(input.get(index) >> bitPosition & 1);
                int n = bitIndex >> 3;
                address[n] = (byte)(address[n] | maskedBit << (bitIndex & 7));
                --bitIndex;
            }
        }
        return address;
    }

    public long encodeToLong(List<Integer> input) {
        this.checkEncodeInputValidity(input, 64);
        return this.zOrderByteAddressToLong(this.encodeToByteArray(input));
    }

    public int encodeToInteger(List<Integer> input) {
        this.checkEncodeInputValidity(input, 32);
        return (int)this.zOrderByteAddressToLong(this.encodeToByteArray(input));
    }

    public List<Integer> decode(byte[] address) {
        int index;
        int[] output = new int[this.encodingBits.size()];
        int bitIndex = this.positiveIntegersOnly ? this.totalBitLength - 1 : this.totalBitLength - this.encodingBits.size() - 1;
        int bitsProcessed = 0;
        while (bitIndex >= 0) {
            for (index = 0; index < output.length; ++index) {
                if (bitsProcessed >= this.encodingBits.get(index)) continue;
                byte maskedBit = (byte)(address[bitIndex >> 3] >> (bitIndex & 7) & 1);
                int bitPosition = this.encodingBits.get(index) - bitsProcessed - 1;
                int n = index;
                output[n] = output[n] | maskedBit << bitPosition;
                --bitIndex;
            }
            ++bitsProcessed;
        }
        if (!this.positiveIntegersOnly) {
            bitIndex = this.totalBitLength - 1;
            for (index = 0; index < output.length; ++index) {
                byte signBit = (byte)(address[bitIndex >> 3] >> (bitIndex & 7) & 1);
                if (signBit == 0) {
                    int n = index;
                    output[n] = output[n] - (1 << this.encodingBits.get(index));
                }
                --bitIndex;
            }
        }
        return (List)Arrays.stream(output).boxed().collect(ImmutableList.toImmutableList());
    }

    public List<Integer> decode(long address) {
        return this.decode(this.zOrderLongToByteAddress(address));
    }

    public List<Integer> decode(int address) {
        return this.decode((long)address);
    }

    public long zOrderByteAddressToLong(byte[] byteAddress) {
        long address = 0L;
        for (int byteIndex = 0; byteIndex < byteAddress.length; ++byteIndex) {
            address |= Byte.toUnsignedLong(byteAddress[byteIndex]) << (byteIndex << 3);
        }
        return address;
    }

    public byte[] zOrderLongToByteAddress(long address) {
        byte[] byteAddress = new byte[this.totalBitLength + 7 + this.encodingBits.size() >> 3];
        for (int bitIndex = 0; bitIndex < this.totalBitLength + this.encodingBits.size(); ++bitIndex) {
            int n = bitIndex >> 3;
            byteAddress[n] = (byte)((long)byteAddress[n] | (address >> bitIndex & 1L) << (bitIndex & 7));
        }
        return byteAddress;
    }

    public List<ZAddressRange<Long>> zOrderSearchCurveLongs(List<ZValueRange> ranges) {
        return this.zOrderSearchCurve(ranges);
    }

    public List<ZAddressRange<Integer>> zOrderSearchCurveIntegers(List<ZValueRange> ranges) {
        List<ZAddressRange<Long>> addressRanges = this.zOrderSearchCurve(ranges);
        ArrayList<ZAddressRange<Integer>> integerAddressRanges = new ArrayList<ZAddressRange<Integer>>();
        for (ZAddressRange<Long> addressRange : addressRanges) {
            Preconditions.checkArgument((addressRange.getMinimumAddress() <= Integer.MAX_VALUE && addressRange.getMaximumAddress() <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)String.format("The address range [%d, %d] contains addresses greater than integers.", addressRange.getMinimumAddress(), addressRange.getMaximumAddress()));
            integerAddressRanges.add(new ZAddressRange<Integer>(addressRange.getMinimumAddress().intValue(), addressRange.getMaximumAddress().intValue()));
        }
        return integerAddressRanges;
    }

    private void checkEncodeInputValidity(List<Integer> input) {
        Objects.requireNonNull(input, "Input list should not be null.");
        Preconditions.checkArgument((!input.isEmpty() ? 1 : 0) != 0, (Object)"Input list size should be greater than zero.");
        Preconditions.checkArgument((input.size() <= 10 ? 1 : 0) != 0, (Object)String.format("Current Z-Ordering implementation does not support more than %d input numbers.", 10));
        Preconditions.checkArgument((input.size() == this.encodingBits.size() ? 1 : 0) != 0, (Object)String.format("Input list size (%d) does not match encoding bits list size (%d).", input.size(), this.encodingBits.size()));
        for (int i = 0; i < input.size(); ++i) {
            if (this.positiveIntegersOnly) {
                Preconditions.checkArgument((input.get(i) >= 0 && input.get(i) < 1 << this.encodingBits.get(i) + 1 ? 1 : 0) != 0);
                continue;
            }
            Preconditions.checkArgument((boolean)(input.get(i) >= 0 ? input.get(i) < 1 << this.encodingBits.get(i) : input.get(i) >= -(1 << this.encodingBits.get(i))), (Object)String.format("Input value %d at index %d should not have more than %d bits.", input.get(i), i, this.encodingBits.get(i)));
        }
    }

    private void checkEncodeInputValidity(List<Integer> input, int maximumBits) {
        this.checkEncodeInputValidity(input);
        Preconditions.checkArgument((this.totalBitLength <= maximumBits ? 1 : 0) != 0, (Object)String.format("The z-address type specified is not large enough to hold %d values with a total of %d bits.", this.encodingBits.size(), this.totalBitLength - this.encodingBits.size()));
    }

    private List<ZAddressRange<Long>> zOrderSearchCurve(List<ZValueRange> valueRanges) {
        List<BoundedZValueRange> boundedValueRanges = this.fillUnspecifiedRangesWithDefaults(valueRanges);
        int[] zRanges = new int[boundedValueRanges.size()];
        for (int index = 0; index < boundedValueRanges.size(); ++index) {
            zRanges[index] = boundedValueRanges.get(index).getNumOfRanges();
        }
        int[] zRangeIndexes = new int[boundedValueRanges.size()];
        ArrayList<ZAddressRange<Long>> addressRanges = new ArrayList<ZAddressRange<Long>>();
        this.permuteValueRanges(zRangeIndexes, zRanges, 0, boundedValueRanges, addressRanges);
        return ZOrder.combineAddressRanges(addressRanges);
    }

    private List<BoundedZValueRange> fillUnspecifiedRangesWithDefaults(List<ZValueRange> valueRanges) {
        ArrayList<BoundedZValueRange> nonNullValues = new ArrayList<BoundedZValueRange>(valueRanges.size());
        for (int index = 0; index < valueRanges.size(); ++index) {
            ZValueRange range = valueRanges.get(index);
            List<Integer> minimumValues = range.getMinimumValues(this.encodingBits.get(index));
            List<Integer> maximumValues = range.getMaximumValues(this.encodingBits.get(index));
            nonNullValues.add(new BoundedZValueRange(minimumValues, maximumValues));
        }
        return nonNullValues;
    }

    private void permuteValueRanges(int[] zRangeIndexes, int[] maximumZRangeIndexes, int permutingIndex, List<BoundedZValueRange> valueRanges, List<ZAddressRange<Long>> addressRanges) {
        if (permutingIndex == zRangeIndexes.length) {
            this.findAddressesRecursively(this.maxBitLength - 1, 0L, this.totalBitLength, valueRanges, zRangeIndexes, addressRanges);
            return;
        }
        zRangeIndexes[permutingIndex] = 0;
        while (zRangeIndexes[permutingIndex] < maximumZRangeIndexes[permutingIndex]) {
            this.permuteValueRanges(zRangeIndexes, maximumZRangeIndexes, permutingIndex + 1, valueRanges, addressRanges);
            int n = permutingIndex;
            zRangeIndexes[n] = zRangeIndexes[n] + 1;
        }
    }

    private void findAddressesRecursively(int level, long startAddress, int totalCurveBits, List<BoundedZValueRange> valueRanges, int[] zRangeIndexes, List<ZAddressRange<Long>> addressRanges) {
        List<Integer> endValues;
        long endAddress = startAddress + (1L << totalCurveBits) - 1L;
        List<Integer> startValues = this.decode(startAddress);
        if (this.inRange(startValues, endValues = this.decode(endAddress), valueRanges, zRangeIndexes)) {
            addressRanges.add(new ZAddressRange<Long>(startAddress, endAddress));
            return;
        }
        if (this.outOfRange(startValues, endValues, valueRanges, zRangeIndexes)) {
            return;
        }
        totalCurveBits -= this.dimensions[level];
        int numOfSubspaces = 1 << this.dimensions[level];
        for (int i = 0; i < numOfSubspaces; ++i) {
            this.findAddressesRecursively(level - 1, startAddress, totalCurveBits, valueRanges, zRangeIndexes, addressRanges);
            startAddress += 1L << totalCurveBits;
        }
    }

    private boolean inRange(List<Integer> startValues, List<Integer> endValues, List<BoundedZValueRange> valueRanges, int[] zRangeIndexes) {
        for (int i = 0; i < this.encodingBits.size(); ++i) {
            if (valueRanges.get(i).getMinimumValueAt(zRangeIndexes[i]) <= startValues.get(i) && valueRanges.get(i).getMaximumValueAt(zRangeIndexes[i]) >= endValues.get(i)) continue;
            return false;
        }
        return true;
    }

    private boolean outOfRange(List<Integer> startValues, List<Integer> endValues, List<BoundedZValueRange> valueRanges, int[] zRangeIndexes) {
        for (int i = 0; i < this.encodingBits.size(); ++i) {
            if (valueRanges.get(i).getMinimumValueAt(zRangeIndexes[i]) <= endValues.get(i) && valueRanges.get(i).getMaximumValueAt(zRangeIndexes[i]) >= startValues.get(i)) continue;
            return true;
        }
        return false;
    }

    private static List<ZAddressRange<Long>> combineAddressRanges(List<ZAddressRange<Long>> addressRanges) {
        if (addressRanges.isEmpty()) {
            return addressRanges;
        }
        addressRanges.sort((range1, range2) -> {
            if (range1.equals(range2)) {
                return 0;
            }
            if (((Long)range1.getMinimumAddress()).equals(range2.getMinimumAddress())) {
                return (Long)range1.getMaximumAddress() > (Long)range2.getMaximumAddress() ? 1 : -1;
            }
            return (Long)range1.getMinimumAddress() > (Long)range2.getMinimumAddress() ? 1 : -1;
        });
        ArrayList<ZAddressRange<Long>> combinedAddressRanges = new ArrayList<ZAddressRange<Long>>();
        combinedAddressRanges.add(addressRanges.get(0));
        for (int index = 1; index < addressRanges.size(); ++index) {
            ZAddressRange<Long> currentAddressRange;
            ZAddressRange previousAddressRange = (ZAddressRange)combinedAddressRanges.get(combinedAddressRanges.size() - 1);
            if (ZOrder.isOverlapping(previousAddressRange, currentAddressRange = addressRanges.get(index))) {
                combinedAddressRanges.set(combinedAddressRanges.size() - 1, new ZAddressRange<Long>((Long)previousAddressRange.getMinimumAddress(), currentAddressRange.getMaximumAddress()));
                continue;
            }
            combinedAddressRanges.add(currentAddressRange);
        }
        return combinedAddressRanges;
    }

    private static boolean isOverlapping(ZAddressRange<Long> previousAddressRange, ZAddressRange<Long> currentAddressRange) {
        return previousAddressRange.getMaximumAddress() + 1L >= currentAddressRange.getMinimumAddress();
    }

    private static class BoundedZValueRange {
        private final List<Integer> minimumValues;
        private final List<Integer> maximumValues;
        private final int numOfRanges;

        public BoundedZValueRange(List<Integer> minimumValues, List<Integer> maximumValues) {
            this.minimumValues = Objects.requireNonNull(minimumValues);
            this.maximumValues = Objects.requireNonNull(maximumValues);
            this.numOfRanges = minimumValues.size();
        }

        public int getMinimumValueAt(int index) {
            return this.minimumValues.get(index);
        }

        public int getMaximumValueAt(int index) {
            return this.maximumValues.get(index);
        }

        public int getNumOfRanges() {
            return this.numOfRanges;
        }
    }
}

