/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.EncryptionLibrary;
import com.facebook.presto.orc.metadata.OrcType;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DwrfEncryptionInfo {
    public static final DwrfEncryptionInfo UNENCRYPTED = new DwrfEncryptionInfo((Map<Integer, DwrfDataEncryptor>)ImmutableMap.of(), (List<byte[]>)ImmutableList.of(), (Map<Integer, Integer>)ImmutableMap.of());
    private final Map<Integer, DwrfDataEncryptor> dwrfEncryptors;
    private final List<byte[]> encryptedKeyMetadatas;
    private final Map<Integer, Integer> nodeToGroupMap;

    public DwrfEncryptionInfo(Map<Integer, DwrfDataEncryptor> dwrfEncryptors, List<byte[]> encryptedKeyMetadatas, Map<Integer, Integer> nodeToGroupMap) {
        this.dwrfEncryptors = ImmutableMap.copyOf(Objects.requireNonNull(dwrfEncryptors, "dwrfDecryptors is null"));
        this.encryptedKeyMetadatas = ImmutableList.copyOf((Collection)Objects.requireNonNull(encryptedKeyMetadatas, "keyMetadatas is null"));
        this.nodeToGroupMap = ImmutableMap.copyOf(Objects.requireNonNull(nodeToGroupMap, "nodeToGroupMap is null"));
    }

    public static DwrfEncryptionInfo createDwrfEncryptionInfo(EncryptionLibrary encryptionLibrary, List<byte[]> encryptedKeyMetadatas, Map<Integer, Slice> intermediateKeyMetadatas, Map<Integer, Integer> nodeToGroupMap) {
        ImmutableMap.Builder encryptorsBuilder = ImmutableMap.builder();
        for (Integer groupId : intermediateKeyMetadatas.keySet()) {
            byte[] encryptedDataKey = encryptedKeyMetadatas.get(groupId);
            byte[] decryptedKeyMetadata = encryptionLibrary.decryptKey(intermediateKeyMetadatas.get(groupId).getBytes(), encryptedDataKey, 0, encryptedDataKey.length);
            encryptorsBuilder.put((Object)groupId, (Object)new DwrfDataEncryptor(decryptedKeyMetadata, encryptionLibrary));
        }
        return new DwrfEncryptionInfo((Map<Integer, DwrfDataEncryptor>)encryptorsBuilder.build(), encryptedKeyMetadatas, nodeToGroupMap);
    }

    public static Map<Integer, Integer> createNodeToGroupMap(List<List<Integer>> encryptionGroups, List<OrcType> types) {
        HashMap<Integer, Integer> nodeToGroupMapBuilder = new HashMap<Integer, Integer>();
        for (int groupId = 0; groupId < encryptionGroups.size(); ++groupId) {
            for (Integer nodeId : encryptionGroups.get(groupId)) {
                DwrfEncryptionInfo.fillNodeToGroupMap(groupId, nodeId, types, nodeToGroupMapBuilder);
            }
        }
        return ImmutableMap.copyOf(nodeToGroupMapBuilder);
    }

    private static void fillNodeToGroupMap(int groupId, int nodeId, List<OrcType> types, Map<Integer, Integer> nodeToGroupMapBuilder) {
        if (nodeToGroupMapBuilder.containsKey(nodeId) && nodeToGroupMapBuilder.get(nodeId) != groupId) {
            throw new VerifyException(String.format("Column or sub-column %s belongs to more than one encryption group: %s and %s", nodeId, nodeToGroupMapBuilder.get(nodeId), groupId));
        }
        nodeToGroupMapBuilder.put(nodeId, groupId);
        OrcType type = types.get(nodeId);
        for (int childIndex : type.getFieldTypeIndexes()) {
            DwrfEncryptionInfo.fillNodeToGroupMap(groupId, childIndex, types, nodeToGroupMapBuilder);
        }
    }

    public DwrfDataEncryptor getEncryptorByGroupId(int groupId) {
        Verify.verify((boolean)this.dwrfEncryptors.containsKey(groupId), (String)"no encryptor available for group %s", (int)groupId);
        return this.dwrfEncryptors.get(groupId);
    }

    public Optional<DwrfDataEncryptor> getEncryptorByNodeId(int nodeId) {
        if (!this.nodeToGroupMap.containsKey(nodeId)) {
            return Optional.empty();
        }
        return Optional.of(this.getEncryptorByGroupId(this.nodeToGroupMap.get(nodeId)));
    }

    public Optional<Integer> getGroupByNodeId(int nodeId) {
        return Optional.ofNullable(this.nodeToGroupMap.get(nodeId));
    }

    public Set<Integer> getEncryptorGroupIds() {
        return this.dwrfEncryptors.keySet();
    }

    public List<byte[]> getEncryptedKeyMetadatas() {
        return this.encryptedKeyMetadatas;
    }
}

