/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.IntegerStatistics;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class IntegerColumnStatistics
extends ColumnStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(IntegerColumnStatistics.class).instanceSize();
    private final IntegerStatistics integerStatistics;

    public IntegerColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter, IntegerStatistics integerStatistics) {
        super(numberOfValues, bloomFilter);
        Objects.requireNonNull(integerStatistics, "integerStatistics is null");
        this.integerStatistics = integerStatistics;
    }

    @Override
    public IntegerStatistics getIntegerStatistics() {
        return this.integerStatistics;
    }

    @Override
    public long getMinAverageValueSizeInBytes() {
        return 9L;
    }

    @Override
    public ColumnStatistics withBloomFilter(HiveBloomFilter bloomFilter) {
        return new IntegerColumnStatistics(this.getNumberOfValues(), bloomFilter, this.integerStatistics);
    }

    @Override
    public long getRetainedSizeInBytes() {
        long sizeInBytes = (long)INSTANCE_SIZE + this.getMembersSizeInBytes();
        return sizeInBytes + this.integerStatistics.getRetainedSizeInBytes();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        super.addHash(hasher);
        hasher.putOptionalHashable(this.integerStatistics);
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("integerStatistics", (Object)this.integerStatistics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegerColumnStatistics that = (IntegerColumnStatistics)o;
        return this.equalsInternal(that) && Objects.equals(this.integerStatistics, that.integerStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.integerStatistics);
    }
}

