/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata.statistics;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.HiveBloomFilter;
import com.facebook.presto.orc.metadata.statistics.StatisticsHasher;
import com.facebook.presto.orc.metadata.statistics.StringStatistics;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class StringColumnStatistics
extends ColumnStatistics {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(StringColumnStatistics.class).instanceSize();
    private final StringStatistics stringStatistics;

    public StringColumnStatistics(Long numberOfValues, HiveBloomFilter bloomFilter, StringStatistics stringStatistics) {
        super(numberOfValues, bloomFilter);
        Objects.requireNonNull(stringStatistics, "stringStatistics is null");
        this.stringStatistics = stringStatistics;
    }

    @Override
    public StringStatistics getStringStatistics() {
        return this.stringStatistics;
    }

    @Override
    public long getMinAverageValueSizeInBytes() {
        long numberOfValues = this.getNumberOfValues();
        return 5L + (numberOfValues > 0L ? this.stringStatistics.getSum() / numberOfValues : 0L);
    }

    @Override
    public ColumnStatistics withBloomFilter(HiveBloomFilter bloomFilter) {
        return new StringColumnStatistics(this.getNumberOfValues(), bloomFilter, this.stringStatistics);
    }

    @Override
    public long getRetainedSizeInBytes() {
        long sizeInBytes = (long)INSTANCE_SIZE + this.getMembersSizeInBytes();
        return sizeInBytes + this.stringStatistics.getRetainedSizeInBytes();
    }

    @Override
    public void addHash(StatisticsHasher hasher) {
        super.addHash(hasher);
        hasher.putOptionalHashable(this.stringStatistics);
    }

    @Override
    protected MoreObjects.ToStringHelper getToStringHelper() {
        return super.getToStringHelper().add("stringStatistics", (Object)this.stringStatistics);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringColumnStatistics that = (StringColumnStatistics)o;
        return this.equalsInternal(that) && Objects.equals(this.stringStatistics, that.stringStatistics);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.stringStatistics);
    }
}

