/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.InvalidFunctionArgumentException;
import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.ArrayBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockLease;
import com.facebook.presto.common.block.ClosingBlockLease;
import com.facebook.presto.common.block.RunLengthEncodedBlock;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcLocalMemoryContext;
import com.facebook.presto.orc.OrcRecordReaderOptions;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.Stripe;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.reader.ListFilter;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.SelectiveStreamReaders;
import com.facebook.presto.orc.stream.BooleanInputStream;
import com.facebook.presto.orc.stream.InputStreamSource;
import com.facebook.presto.orc.stream.InputStreamSources;
import com.facebook.presto.orc.stream.LongInputStream;
import com.facebook.presto.orc.stream.MissingInputStreamSource;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.slice.SizeOf;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.joda.time.DateTimeZone;
import org.openjdk.jol.info.ClassLayout;

public class ListSelectiveStreamReader
implements SelectiveStreamReader {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ListSelectiveStreamReader.class).instanceSize();
    private static final int ELEMENT_LENGTH_UNBOUNDED = -1;
    private final StreamDescriptor streamDescriptor;
    private final int level;
    private final ListFilter listFilter;
    private final TupleDomainFilter.NullsFilter nullsFilter;
    private final boolean nullsAllowed;
    private final boolean nonNullsAllowed;
    private final boolean outputRequired;
    @Nullable
    private final ArrayType outputType;
    private final int maxElementLength;
    @Nullable
    private final SelectiveStreamReader elementStreamReader;
    private final OrcLocalMemoryContext systemMemoryContext;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;
    private int readOffset;
    @Nullable
    private int[] offsets;
    @Nullable
    private boolean[] nulls;
    @Nullable
    private int[] outputPositions;
    private int outputPositionCount;
    private boolean[] indexOutOfBounds;
    private boolean allNulls;
    private int elementReadOffset;
    private int[] elementOffsets;
    private int[] elementLengths;
    private int[] elementPositions;
    private int elementOutputPositionCount;
    private int[] elementOutputPositions;
    private boolean valuesInUse;

    public ListSelectiveStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, List<Subfield> subfields, ListFilter listFilter, int subfieldLevel, Optional<Type> outputType, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, boolean legacyMapSubscript, OrcAggregatedMemoryContext systemMemoryContext) {
        Objects.requireNonNull(filters, "filters is null");
        Objects.requireNonNull(subfields, "subfields is null");
        Objects.requireNonNull(systemMemoryContext, "systemMemoryContext is null");
        if (listFilter != null) {
            Preconditions.checkArgument((subfieldLevel > 0 ? 1 : 0) != 0, (Object)"SubfieldFilter is not expected at the top level");
            Preconditions.checkArgument((boolean)filters.isEmpty(), (Object)"Range filters are not expected at mid level");
        }
        this.streamDescriptor = Objects.requireNonNull(streamDescriptor, "streamDescriptor is null");
        this.outputRequired = Objects.requireNonNull(outputType, "outputType is null").isPresent();
        this.outputType = outputType.orElse(null);
        this.level = subfieldLevel;
        this.maxElementLength = subfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).anyMatch(Subfield.AllSubscripts.class::isInstance) ? -1 : subfields.stream().map(Subfield::getPath).map(path -> (Subfield.PathElement)path.get(0)).map(Subfield.LongSubscript.class::cast).map(Subfield.LongSubscript::getIndex).mapToInt(Long::intValue).max().orElse(-1);
        if (listFilter != null) {
            this.nullsAllowed = true;
            this.nonNullsAllowed = true;
            this.listFilter = listFilter;
            this.nullsFilter = listFilter.getParent().getNullsFilter();
        } else if (!filters.isEmpty()) {
            Optional<TupleDomainFilter> topLevelFilter = ListSelectiveStreamReader.getTopLevelFilter(filters);
            if (topLevelFilter.isPresent()) {
                this.nullsAllowed = topLevelFilter.get() == TupleDomainFilter.IS_NULL;
                this.nonNullsAllowed = !this.nullsAllowed;
            } else {
                this.nullsAllowed = filters.values().stream().allMatch(TupleDomainFilter::testNull);
                this.nonNullsAllowed = true;
            }
            this.listFilter = filters.keySet().stream().anyMatch(path -> !path.getPath().isEmpty()) ? new ListFilter(streamDescriptor, filters) : null;
            this.nullsFilter = null;
        } else {
            this.nullsAllowed = true;
            this.nonNullsAllowed = true;
            this.listFilter = null;
            this.nullsFilter = null;
        }
        StreamDescriptor elementStreamDescriptor = streamDescriptor.getNestedStreams().get(0);
        Optional<Type> elementOutputType = outputType.map(type -> (Type)type.getTypeParameters().get(0));
        Object elementSubfields = ImmutableList.of();
        if (subfields.stream().map(Subfield::getPath).allMatch(path -> path.size() > 1)) {
            elementSubfields = (List)subfields.stream().map(subfield -> subfield.tail(subfield.getRootName())).distinct().collect(ImmutableList.toImmutableList());
        }
        this.elementStreamReader = SelectiveStreamReaders.createNestedStreamReader(elementStreamDescriptor, this.level + 1, Optional.ofNullable(this.listFilter), elementOutputType, (List<Subfield>)elementSubfields, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext);
        this.systemMemoryContext = systemMemoryContext.newOrcLocalMemoryContext(ListSelectiveStreamReader.class.getSimpleName());
    }

    private static Optional<TupleDomainFilter> getTopLevelFilter(Map<Subfield, TupleDomainFilter> filters) {
        Map topLevelFilters = Maps.filterEntries(filters, entry -> ((Subfield)entry.getKey()).getPath().isEmpty());
        if (topLevelFilters.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((topLevelFilters.size() == 1 ? 1 : 0) != 0, (Object)"ARRAY column may have at most one top-level range filter");
        TupleDomainFilter filter = (TupleDomainFilter)Iterables.getOnlyElement(topLevelFilters.values());
        Preconditions.checkArgument((filter == TupleDomainFilter.IS_NULL || filter == TupleDomainFilter.IS_NOT_NULL ? 1 : 0) != 0, (Object)"Top-level range filter on ARRAY column must be IS NULL or IS NOT NULL");
        return Optional.of(filter);
    }

    @Override
    public int read(int offset, int[] positions, int positionCount) throws IOException {
        Preconditions.checkArgument((positionCount > 0 || this.listFilter != null ? 1 : 0) != 0, (Object)"positionCount must be greater than zero");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.allNulls = false;
        if (this.outputRequired) {
            this.offsets = Arrays.ensureCapacity((int[])this.offsets, (int)(positionCount + 1));
        }
        if (this.nullsAllowed && this.presentStream != null && (this.outputRequired || this.listFilter != null)) {
            this.nulls = Arrays.ensureCapacity((boolean[])this.nulls, (int)positionCount);
        }
        this.outputPositions = SelectiveStreamReaders.initializeOutputPositions(this.outputPositions, positions, positionCount);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        if (this.readOffset < offset) {
            this.elementReadOffset += this.skip(offset - this.readOffset);
        }
        int streamPosition = this.lengthStream == null && this.presentStream != null ? this.readAllNulls(positions, positionCount) : this.readNotAllNulls(positions, positionCount);
        this.readOffset = offset + streamPosition;
        return this.outputPositionCount;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private int skip(int items) throws IOException {
        if (this.lengthStream == null) {
            this.presentStream.skip(items);
            return 0;
        }
        if (this.presentStream != null) {
            int lengthsToSkip = this.presentStream.countBitsSet(items);
            return Math.toIntExact(this.lengthStream.sum(lengthsToSkip));
        }
        return Math.toIntExact(this.lengthStream.sum(items));
    }

    private int readAllNulls(int[] positions, int positionCount) throws IOException {
        this.presentStream.skip(positions[positionCount - 1]);
        if (this.nullsAllowed) {
            if (this.nullsFilter != null) {
                this.outputPositionCount = 0;
                for (int i = 0; i < positionCount; ++i) {
                    if (this.nullsFilter.testNull()) {
                        this.outputPositions[this.outputPositionCount] = positions[i];
                        ++this.outputPositionCount;
                        continue;
                    }
                    this.outputPositionCount -= this.nullsFilter.getPrecedingPositionsToFail();
                    i += this.nullsFilter.getSucceedingPositionsToFail();
                }
            } else {
                this.outputPositionCount = positionCount;
            }
        } else {
            this.outputPositionCount = 0;
        }
        if (this.listFilter != null) {
            this.listFilter.populateElementFilters(0, null, null, 0);
        }
        this.allNulls = true;
        return positions[positionCount - 1] + 1;
    }

    private int readNotAllNulls(int[] positions, int positionCount) throws IOException {
        this.elementOffsets = Arrays.ensureCapacity((int[])this.elementOffsets, (int)(positionCount + 1));
        this.elementLengths = Arrays.ensureCapacity((int[])this.elementLengths, (int)positionCount);
        this.systemMemoryContext.setBytes(this.getRetainedSizeInBytes());
        int streamPosition = 0;
        int skippedElements = 0;
        int elementPositionCount = 0;
        this.outputPositionCount = 0;
        for (int i = 0; i < positionCount; ++i) {
            int position = positions[i];
            if (position > streamPosition) {
                skippedElements += this.skip(position - streamPosition);
                streamPosition = position;
            }
            if (this.presentStream != null && !this.presentStream.nextBit()) {
                if (this.nullsAllowed && (this.nullsFilter == null || this.nullsFilter.testNull())) {
                    if (this.outputRequired || this.listFilter != null) {
                        this.nulls[this.outputPositionCount] = true;
                    }
                    this.elementOffsets[this.outputPositionCount] = elementPositionCount + skippedElements;
                    this.elementLengths[this.outputPositionCount] = 0;
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                }
            } else {
                int length = Math.toIntExact(this.lengthStream.next());
                if (this.nonNullsAllowed && (this.nullsFilter == null || this.nullsFilter.testNonNull())) {
                    this.elementOffsets[this.outputPositionCount] = elementPositionCount + skippedElements;
                    this.elementLengths[this.outputPositionCount] = length;
                    elementPositionCount += length;
                    if ((this.outputRequired || this.listFilter != null) && this.nullsAllowed && this.presentStream != null) {
                        this.nulls[this.outputPositionCount] = false;
                    }
                    this.outputPositions[this.outputPositionCount] = position;
                    ++this.outputPositionCount;
                } else {
                    skippedElements += length;
                }
            }
            ++streamPosition;
            if (this.nullsFilter == null) continue;
            int precedingPositionsToFail = this.nullsFilter.getPrecedingPositionsToFail();
            for (int j = 0; j < precedingPositionsToFail; ++j) {
                int length = this.elementLengths[this.outputPositionCount - 1 - j];
                skippedElements += length;
                elementPositionCount -= length;
            }
            this.outputPositionCount -= precedingPositionsToFail;
            int succeedingPositionsToFail = this.nullsFilter.getSucceedingPositionsToFail();
            if (succeedingPositionsToFail <= 0) continue;
            int positionsToSkip = 0;
            for (int j = 0; j < succeedingPositionsToFail; ++j) {
                int nextPosition = positions[++i];
                positionsToSkip += 1 + nextPosition - streamPosition;
                streamPosition = nextPosition + 1;
            }
            skippedElements += this.skip(positionsToSkip);
        }
        this.elementOffsets[this.outputPositionCount] = elementPositionCount + skippedElements;
        elementPositionCount = this.populateElementPositions(elementPositionCount);
        if (this.listFilter != null) {
            this.listFilter.populateElementFilters(this.outputPositionCount, this.nulls, this.elementLengths, elementPositionCount);
        }
        if (this.elementStreamReader != null && elementPositionCount > 0) {
            this.elementStreamReader.read(this.elementReadOffset, this.elementPositions, elementPositionCount);
        } else if (this.listFilter != null && this.listFilter.getChild() != null) {
            this.elementStreamReader.read(this.elementReadOffset, this.elementPositions, elementPositionCount);
        }
        this.elementReadOffset += this.elementOffsets[this.outputPositionCount];
        if (this.listFilter == null || this.level > 0) {
            this.populateOutputPositionsNoFilter(elementPositionCount);
        } else {
            this.populateOutputPositionsWithFilter(elementPositionCount);
        }
        return streamPosition;
    }

    private int populateElementPositions(int elementPositionCount) {
        this.elementPositions = Arrays.ensureCapacity((int[])this.elementPositions, (int)elementPositionCount);
        int index = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            int length = this.elementLengths[i];
            if (this.maxElementLength != -1 && length > this.maxElementLength) {
                this.elementLengths[i] = length = this.maxElementLength;
            }
            for (int j = 0; j < length; ++j) {
                this.elementPositions[index] = this.elementOffsets[i] + j;
                ++index;
            }
        }
        return index;
    }

    private void populateOutputPositionsNoFilter(int elementPositionCount) {
        if (this.outputRequired) {
            this.elementOutputPositionCount = elementPositionCount;
            this.elementOutputPositions = Arrays.ensureCapacity((int[])this.elementOutputPositions, (int)elementPositionCount);
            System.arraycopy(this.elementPositions, 0, this.elementOutputPositions, 0, elementPositionCount);
            int offset = 0;
            for (int i = 0; i < this.outputPositionCount; ++i) {
                this.offsets[i] = offset;
                offset += this.elementLengths[i];
            }
            this.offsets[this.outputPositionCount] = offset;
        }
    }

    private void populateOutputPositionsWithFilter(int elementPositionCount) {
        this.elementOutputPositionCount = 0;
        this.elementOutputPositions = Arrays.ensureCapacity((int[])this.elementOutputPositions, (int)elementPositionCount);
        this.indexOutOfBounds = this.listFilter.getTopLevelIndexOutOfBounds();
        int outputPosition = 0;
        int elementOffset = 0;
        boolean[] positionsFailed = this.listFilter.getTopLevelFailed();
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (!positionsFailed[i]) {
                this.indexOutOfBounds[outputPosition] = this.indexOutOfBounds[i];
                this.outputPositions[outputPosition] = this.outputPositions[i];
                if (this.outputRequired) {
                    if (this.nullsAllowed && this.presentStream != null) {
                        this.nulls[outputPosition] = this.nulls[i];
                    }
                    this.offsets[outputPosition] = this.elementOutputPositionCount;
                    for (int j = 0; j < this.elementLengths[i]; ++j) {
                        this.elementOutputPositions[this.elementOutputPositionCount] = this.elementPositions[elementOffset + j];
                        ++this.elementOutputPositionCount;
                    }
                }
                ++outputPosition;
            }
            elementOffset += this.elementLengths[i];
        }
        if (this.outputRequired) {
            this.offsets[outputPosition] = this.elementOutputPositionCount;
        }
        this.outputPositionCount = outputPosition;
    }

    @Override
    public int[] getReadPositions() {
        return this.outputPositions;
    }

    @Override
    public Block getBlock(int[] positions, int positionCount) {
        boolean mayHaveNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)("Not enough values: " + this.outputPositionCount + ", " + positionCount));
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount);
        }
        boolean bl = mayHaveNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount == this.outputPositionCount) {
            Block block = ArrayBlock.fromElementBlock((int)positionCount, Optional.ofNullable(mayHaveNulls ? this.nulls : null), (int[])this.offsets, (Block)this.makeElementBlock());
            this.nulls = null;
            this.offsets = null;
            return block;
        }
        int[] offsetsCopy = new int[positionCount + 1];
        boolean[] nullsCopy = null;
        if (mayHaveNulls) {
            nullsCopy = new boolean[positionCount];
        }
        this.elementOutputPositionCount = 0;
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int skippedElements = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                skippedElements += this.offsets[i + 1] - this.offsets[i];
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            offsetsCopy[positionIndex] = this.offsets[i] - skippedElements;
            if (nullsCopy != null) {
                nullsCopy[positionIndex] = this.nulls[i];
            }
            for (int j = 0; j < this.offsets[i + 1] - this.offsets[i]; ++j) {
                this.elementOutputPositions[this.elementOutputPositionCount] = this.elementOutputPositions[this.elementOutputPositionCount + skippedElements];
                ++this.elementOutputPositionCount;
            }
            if (++positionIndex >= positionCount) {
                offsetsCopy[positionCount] = this.offsets[i + 1] - skippedElements;
                break;
            }
            nextPosition = positions[positionIndex];
        }
        return ArrayBlock.fromElementBlock((int)positionCount, Optional.ofNullable(nullsCopy), (int[])offsetsCopy, (Block)this.makeElementBlock());
    }

    private Block makeElementBlock() {
        if (this.elementOutputPositionCount == 0) {
            return this.outputType.getElementType().createBlockBuilder(null, 0).build();
        }
        return this.elementStreamReader.getBlock(this.elementOutputPositions, this.elementOutputPositionCount);
    }

    @Override
    public BlockLease getBlockView(int[] positions, int positionCount) {
        boolean includeNulls;
        Preconditions.checkArgument((this.outputPositionCount > 0 ? 1 : 0) != 0, (Object)"outputPositionCount must be greater than zero");
        Preconditions.checkState((boolean)this.outputRequired, (Object)"This stream reader doesn't produce output");
        Preconditions.checkState((positionCount <= this.outputPositionCount ? 1 : 0) != 0, (Object)"Not enough values");
        Preconditions.checkState((!this.valuesInUse ? 1 : 0) != 0, (Object)"BlockLease hasn't been closed yet");
        if (this.allNulls) {
            return ClosingBlockLease.newLease((Block)new RunLengthEncodedBlock(this.outputType.createBlockBuilder(null, 1).appendNull().build(), positionCount), (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[0]);
        }
        boolean bl = includeNulls = this.nullsAllowed && this.presentStream != null;
        if (positionCount != this.outputPositionCount) {
            this.compactValues(positions, positionCount, includeNulls);
        }
        BlockLease elementBlockLease = this.elementOutputPositionCount == 0 ? ClosingBlockLease.newLease((Block)this.outputType.getElementType().createBlockBuilder(null, 0).build(), (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[0]) : this.elementStreamReader.getBlockView(this.elementOutputPositions, this.elementOutputPositionCount);
        this.valuesInUse = true;
        Block block = ArrayBlock.fromElementBlock((int)positionCount, Optional.ofNullable(includeNulls ? this.nulls : null), (int[])this.offsets, (Block)((Block)elementBlockLease.get()));
        return ClosingBlockLease.newLease((Block)block, (ClosingBlockLease.Closer[])new ClosingBlockLease.Closer[]{() -> this.closeBlockLease(elementBlockLease)});
    }

    @Override
    public void throwAnyError(int[] positions, int positionCount) {
        if (this.indexOutOfBounds == null) {
            return;
        }
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) continue;
            assert (this.outputPositions[i] == nextPosition);
            if (this.indexOutOfBounds[i]) {
                throw new InvalidFunctionArgumentException("Array subscript out of bounds");
            }
            if (++positionIndex >= positionCount) break;
            nextPosition = positions[positionIndex];
        }
    }

    private void closeBlockLease(BlockLease elementBlockLease) {
        elementBlockLease.close();
        this.valuesInUse = false;
    }

    private void compactValues(int[] positions, int positionCount, boolean compactNulls) {
        int positionIndex = 0;
        int nextPosition = positions[positionIndex];
        int skippedElements = 0;
        this.elementOutputPositionCount = 0;
        for (int i = 0; i < this.outputPositionCount; ++i) {
            if (this.outputPositions[i] < nextPosition) {
                skippedElements += this.offsets[i + 1] - this.offsets[i];
                continue;
            }
            assert (this.outputPositions[i] == nextPosition);
            for (int j = 0; j < this.offsets[i + 1] - this.offsets[i]; ++j) {
                this.elementOutputPositions[this.elementOutputPositionCount] = this.elementOutputPositions[this.elementOutputPositionCount + skippedElements];
                ++this.elementOutputPositionCount;
            }
            this.offsets[positionIndex] = this.offsets[i] - skippedElements;
            if (compactNulls) {
                this.nulls[positionIndex] = this.nulls[i];
            }
            this.outputPositions[positionIndex] = nextPosition;
            if (this.indexOutOfBounds != null) {
                this.indexOutOfBounds[positionIndex] = this.indexOutOfBounds[i];
            }
            if (++positionIndex >= positionCount) {
                this.offsets[positionCount] = this.offsets[i + 1] - skippedElements;
                break;
            }
            nextPosition = positions[positionIndex];
        }
        this.outputPositionCount = positionCount;
    }

    @Override
    public void close() {
        if (this.elementStreamReader != null) {
            this.elementStreamReader.close();
        }
        this.outputPositions = null;
        this.nulls = null;
        this.offsets = null;
        this.elementOffsets = null;
        this.elementLengths = null;
        this.elementPositions = null;
        this.elementOutputPositions = null;
        this.indexOutOfBounds = null;
        this.presentStream = null;
        this.presentStreamSource = null;
        this.lengthStream = null;
        this.lengthStreamSource = null;
    }

    @Override
    public void startStripe(Stripe stripe) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.elementReadOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        if (this.elementStreamReader != null) {
            this.elementStreamReader.startStripe(stripe);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.streamDescriptor, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.readOffset = 0;
        this.elementReadOffset = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        if (this.elementStreamReader != null) {
            this.elementStreamReader.startRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.streamDescriptor).toString();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((boolean[])this.nulls) + SizeOf.sizeOf((int[])this.outputPositions) + SizeOf.sizeOf((boolean[])this.indexOutOfBounds) + SizeOf.sizeOf((int[])this.elementOffsets) + SizeOf.sizeOf((int[])this.elementLengths) + SizeOf.sizeOf((int[])this.elementPositions) + SizeOf.sizeOf((int[])this.elementOutputPositions) + (this.listFilter != null ? this.listFilter.getRetainedSizeInBytes() : 0L) + (this.elementStreamReader != null ? this.elementStreamReader.getRetainedSizeInBytes() : 0L);
    }
}

