/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.reader;

import com.facebook.presto.common.Subfield;
import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.type.ArrayType;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.BooleanType;
import com.facebook.presto.common.type.CharType;
import com.facebook.presto.common.type.DateType;
import com.facebook.presto.common.type.DecimalType;
import com.facebook.presto.common.type.DoubleType;
import com.facebook.presto.common.type.IntegerType;
import com.facebook.presto.common.type.MapType;
import com.facebook.presto.common.type.RealType;
import com.facebook.presto.common.type.RowType;
import com.facebook.presto.common.type.SmallintType;
import com.facebook.presto.common.type.TimestampType;
import com.facebook.presto.common.type.TinyintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.common.type.VarbinaryType;
import com.facebook.presto.common.type.VarcharType;
import com.facebook.presto.orc.OrcAggregatedMemoryContext;
import com.facebook.presto.orc.OrcRecordReaderOptions;
import com.facebook.presto.orc.StreamDescriptor;
import com.facebook.presto.orc.TupleDomainFilter;
import com.facebook.presto.orc.metadata.OrcType;
import com.facebook.presto.orc.reader.BooleanSelectiveStreamReader;
import com.facebook.presto.orc.reader.ByteSelectiveStreamReader;
import com.facebook.presto.orc.reader.DoubleSelectiveStreamReader;
import com.facebook.presto.orc.reader.FloatSelectiveStreamReader;
import com.facebook.presto.orc.reader.HierarchicalFilter;
import com.facebook.presto.orc.reader.ListFilter;
import com.facebook.presto.orc.reader.ListSelectiveStreamReader;
import com.facebook.presto.orc.reader.LongDecimalSelectiveStreamReader;
import com.facebook.presto.orc.reader.LongSelectiveStreamReader;
import com.facebook.presto.orc.reader.MapSelectiveStreamReader;
import com.facebook.presto.orc.reader.ReaderUtils;
import com.facebook.presto.orc.reader.SelectiveStreamReader;
import com.facebook.presto.orc.reader.ShortDecimalSelectiveStreamReader;
import com.facebook.presto.orc.reader.SliceSelectiveStreamReader;
import com.facebook.presto.orc.reader.StructSelectiveStreamReader;
import com.facebook.presto.orc.reader.TimestampSelectiveStreamReader;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import org.joda.time.DateTimeZone;

public final class SelectiveStreamReaders {
    private SelectiveStreamReaders() {
    }

    public static SelectiveStreamReader createStreamReader(StreamDescriptor streamDescriptor, Map<Subfield, TupleDomainFilter> filters, Optional<Type> outputType, List<Subfield> requiredSubfields, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, boolean legacyMapSubscript, OrcAggregatedMemoryContext systemMemoryContext) {
        OrcType.OrcTypeKind type = streamDescriptor.getOrcTypeKind();
        switch (type) {
            case BOOLEAN: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Boolean stream reader doesn't support subfields");
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, BooleanType.class::isInstance);
                return new BooleanSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType.isPresent(), systemMemoryContext.newOrcLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case BYTE: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Byte stream reader doesn't support subfields");
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, TinyintType.class::isInstance);
                return new ByteSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType.isPresent(), systemMemoryContext.newOrcLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Primitive type stream reader doesn't support subfields");
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, t -> t instanceof BigintType || t instanceof IntegerType || t instanceof SmallintType || t instanceof DateType);
                return new LongSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType, systemMemoryContext);
            }
            case FLOAT: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Float type stream reader doesn't support subfields");
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, RealType.class::isInstance);
                return new FloatSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType.isPresent(), systemMemoryContext.newOrcLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case DOUBLE: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Double stream reader doesn't support subfields");
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, DoubleType.class::isInstance);
                return new DoubleSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType.isPresent(), systemMemoryContext.newOrcLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Primitive stream reader doesn't support subfields");
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, t -> t instanceof VarcharType || t instanceof CharType || t instanceof VarbinaryType);
                return new SliceSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType, systemMemoryContext);
            }
            case TIMESTAMP: {
                Preconditions.checkArgument((boolean)requiredSubfields.isEmpty(), (Object)"Timestamp stream reader doesn't support subfields");
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, TimestampType.class::isInstance);
                return new TimestampSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), hiveStorageTimeZone, outputType.isPresent(), systemMemoryContext.newOrcLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()), options);
            }
            case LIST: {
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, ArrayType.class::isInstance);
                return new ListSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, null, 0, outputType, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext);
            }
            case STRUCT: {
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, RowType.class::isInstance);
                return new StructSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, outputType, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext);
            }
            case MAP: {
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, MapType.class::isInstance);
                return new MapSelectiveStreamReader(streamDescriptor, filters, requiredSubfields, outputType, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext);
            }
            case DECIMAL: {
                SelectiveStreamReaders.verifyStreamType(streamDescriptor, outputType, DecimalType.class::isInstance);
                if (streamDescriptor.getOrcType().getPrecision().get() <= 18) {
                    return new ShortDecimalSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType, systemMemoryContext.newOrcLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
                }
                return new LongDecimalSelectiveStreamReader(streamDescriptor, SelectiveStreamReaders.getOptionalOnlyFilter(type, filters), outputType, systemMemoryContext.newOrcLocalMemoryContext(SelectiveStreamReaders.class.getSimpleName()));
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)type));
    }

    private static void verifyStreamType(StreamDescriptor streamDescriptor, Optional<Type> outputType, Predicate<Type> predicate) {
        if (outputType.isPresent()) {
            ReaderUtils.verifyStreamType(streamDescriptor, outputType.get(), predicate);
        }
    }

    private static Optional<TupleDomainFilter> getOptionalOnlyFilter(OrcType.OrcTypeKind type, Map<Subfield, TupleDomainFilter> filters) {
        if (filters.isEmpty()) {
            return Optional.empty();
        }
        Preconditions.checkArgument((filters.size() == 1 ? 1 : 0) != 0, (Object)String.format("Stream reader for %s doesn't support multiple range filters", new Object[]{type}));
        return Optional.of(Iterables.getOnlyElement(filters.values()));
    }

    public static SelectiveStreamReader createNestedStreamReader(StreamDescriptor streamDescriptor, int level, Optional<HierarchicalFilter> parentFilter, Optional<Type> outputType, List<Subfield> requiredSubfields, DateTimeZone hiveStorageTimeZone, OrcRecordReaderOptions options, boolean legacyMapSubscript, OrcAggregatedMemoryContext systemMemoryContext) {
        switch (streamDescriptor.getOrcTypeKind()) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: 
            case DATE: 
            case FLOAT: 
            case DOUBLE: 
            case BINARY: 
            case STRING: 
            case VARCHAR: 
            case CHAR: 
            case TIMESTAMP: 
            case DECIMAL: {
                TupleDomainFilter.PositionalFilter positionalFilter;
                ImmutableMap elementFilters = ImmutableMap.of();
                if (parentFilter.isPresent() && (positionalFilter = parentFilter.get().getPositionalFilter()) != null) {
                    elementFilters = ImmutableMap.of((Object)new Subfield("c"), (Object)positionalFilter);
                }
                if (!outputType.isPresent() && elementFilters.isEmpty()) {
                    return null;
                }
                return SelectiveStreamReaders.createStreamReader(streamDescriptor, (Map<Subfield, TupleDomainFilter>)elementFilters, outputType, requiredSubfields, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext.newOrcAggregatedMemoryContext());
            }
            case LIST: {
                Optional<ListFilter> childFilter = parentFilter.map(HierarchicalFilter::getChild).map(ListFilter.class::cast);
                return new ListSelectiveStreamReader(streamDescriptor, (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), requiredSubfields, childFilter.orElse(null), level, outputType, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext.newOrcAggregatedMemoryContext());
            }
            case STRUCT: {
                Preconditions.checkArgument((!parentFilter.isPresent() ? 1 : 0) != 0, (Object)"Filters on nested structs are not supported yet");
                return new StructSelectiveStreamReader(streamDescriptor, (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), requiredSubfields, outputType, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext.newOrcAggregatedMemoryContext());
            }
            case MAP: {
                Preconditions.checkArgument((!parentFilter.isPresent() ? 1 : 0) != 0, (Object)"Filters on nested maps are not supported yet");
                return new MapSelectiveStreamReader(streamDescriptor, (Map<Subfield, TupleDomainFilter>)ImmutableMap.of(), requiredSubfields, outputType, hiveStorageTimeZone, options, legacyMapSubscript, systemMemoryContext.newOrcAggregatedMemoryContext());
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)streamDescriptor.getOrcTypeKind()));
    }

    public static int[] initializeOutputPositions(int[] outputPositions, int[] positions, int positionCount) {
        outputPositions = Arrays.ensureCapacity((int[])outputPositions, (int)positionCount);
        System.arraycopy(positions, 0, outputPositions, 0, positionCount);
        return outputPositions;
    }
}

