/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.orc.array.IntBigArray;
import com.google.common.base.Preconditions;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import org.openjdk.jol.info.ClassLayout;

public class LongDictionaryBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongDictionaryBuilder.class).instanceSize() + ClassLayout.parseClass(LongArrayList.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private static final int EMPTY_SLOT = -1;
    private final IntBigArray elementPositionByHash;
    private final LongArrayList elements;
    private int maxFill;
    private int hashMask;

    public LongDictionaryBuilder(int expectedSize) {
        Preconditions.checkArgument((expectedSize >= 0 ? 1 : 0) != 0, (Object)"expectedSize must not be negative");
        int hashSize = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = LongDictionaryBuilder.calculateMaxFill(hashSize);
        this.hashMask = hashSize - 1;
        this.elements = new LongArrayList(expectedSize);
        this.elementPositionByHash = new IntBigArray();
        this.elementPositionByHash.ensureCapacity(hashSize);
        this.elementPositionByHash.fill(-1);
    }

    public void clear() {
        this.elementPositionByHash.fill(-1);
        this.elements.clear();
    }

    public int putIfAbsent(long value) {
        long hashPosition = this.getHashPositionOfElement(value);
        int slicePosition = this.elementPositionByHash.get(hashPosition) != -1 ? this.elementPositionByHash.get(hashPosition) : this.addNewElement(hashPosition, value);
        return slicePosition;
    }

    private long getHashPositionOfElement(long value) {
        long hashPosition = this.getHash(value);
        hashPosition = this.getMaskedHash(hashPosition);
        int slicePosition;
        while ((slicePosition = this.elementPositionByHash.get(hashPosition)) != -1) {
            if (this.elements.getLong(slicePosition) == value) {
                return hashPosition;
            }
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return hashPosition;
    }

    private long getRehashPositionOfElement(long value) {
        long hashPosition = this.getHash(value);
        hashPosition = this.getMaskedHash(hashPosition);
        while (this.elementPositionByHash.get(hashPosition) != -1) {
            hashPosition = this.getMaskedHash(hashPosition + 1L);
        }
        return hashPosition;
    }

    private int addNewElement(long hashPosition, long value) {
        int newElementPositionInBlock = this.elements.size();
        this.elements.add(value);
        this.elementPositionByHash.set(hashPosition, newElementPositionInBlock);
        if (this.elements.size() >= this.maxFill) {
            this.rehash(this.maxFill * 2);
        }
        return newElementPositionInBlock;
    }

    private void rehash(int size) {
        int newHashSize = HashCommon.arraySize((int)(size + 1), (float)0.75f);
        this.hashMask = newHashSize - 1;
        this.maxFill = LongDictionaryBuilder.calculateMaxFill(newHashSize);
        this.elementPositionByHash.ensureCapacity(newHashSize);
        this.elementPositionByHash.fill(-1);
        for (int i = 0; i < this.elements.size(); ++i) {
            this.elementPositionByHash.set(this.getRehashPositionOfElement(this.elements.getLong(i)), i);
        }
    }

    private static int calculateMaxFill(int hashSize) {
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        return maxFill;
    }

    protected long getHash(long value) {
        return HashCommon.murmurHash3((long)value);
    }

    private long getMaskedHash(long rawHash) {
        return rawHash & (long)this.hashMask;
    }

    public long[] elements() {
        return this.elements.elements();
    }

    public long getValue(int index) {
        return this.elements.getLong(index);
    }

    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.elementPositionByHash.sizeOf() + SizeOf.sizeOf((long[])this.elements.elements());
    }

    public int size() {
        return this.elements.size();
    }
}

