/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.AbstractVariableWidthBlock;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.block.BlockBuilderStatus;
import com.google.common.annotations.VisibleForTesting;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.XxHash64;
import java.util.Arrays;
import java.util.function.BiConsumer;
import org.openjdk.jol.info.ClassLayout;

public class SegmentedSliceBlockBuilder
extends AbstractVariableWidthBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SegmentedSliceBlockBuilder.class).instanceSize();
    private final DynamicSliceOutput openSliceOutput;
    private int openSegmentIndex;
    private int openSegmentOffset;
    private int[][] offsets;
    private Slice[] closedSlices;
    private long closedSlicesRetainedSize;
    private long closedSlicesSizeInBytes;

    public SegmentedSliceBlockBuilder(int expectedEntries, int expectedBytes) {
        int initialSize = Math.max(64, Segments.segment(expectedEntries) + 1);
        this.offsets = new int[initialSize][];
        this.closedSlices = new Slice[initialSize];
        this.offsets[0] = new int[16385];
        this.openSliceOutput = new DynamicSliceOutput(expectedBytes);
    }

    public void reset() {
        this.openSliceOutput.reset();
        Arrays.fill(this.closedSlices, null);
        this.closedSlicesRetainedSize = 0L;
        this.closedSlicesSizeInBytes = 0L;
        Arrays.fill(this.offsets[0], 0);
        Arrays.fill((Object[])this.offsets, 1, this.offsets.length, null);
        this.openSegmentIndex = 0;
        this.openSegmentOffset = 0;
    }

    public int getPositionOffset(int position) {
        return this.getOffset(position);
    }

    public int getSliceLength(int position) {
        int offset = Segments.offset(position);
        int segment = Segments.segment(position);
        return this.offsets[segment][offset + 1] - this.offsets[segment][offset];
    }

    private Slice getSegmentRawSlice(int segment) {
        return segment == this.openSegmentIndex ? this.openSliceOutput.getUnderlyingSlice() : this.closedSlices[segment];
    }

    public Slice getRawSlice(int position) {
        return this.getSegmentRawSlice(Segments.segment(position));
    }

    public int getPositionCount() {
        return Segments.getPositions(this.openSegmentIndex, this.openSegmentOffset);
    }

    public long getSizeInBytes() {
        long offsetsSizeInBytes = 4L * (long)this.getPositionCount();
        return (long)this.openSliceOutput.size() + offsetsSizeInBytes + this.closedSlicesSizeInBytes;
    }

    public long getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException("getRegionSizeInBytes is not supported by SegmentedSliceBlockBuilder");
    }

    public long getPositionsSizeInBytes(boolean[] positions) {
        throw new UnsupportedOperationException("getPositionsSizeInBytes is not supported by SegmentedSliceBlockBuilder");
    }

    public long getRetainedSizeInBytes() {
        long offsetsSize = SizeOf.sizeOf((Object[])this.offsets) + (long)(this.openSegmentIndex + 1) * SizeOf.sizeOf((int[])this.offsets[0]);
        long closedSlicesSize = SizeOf.sizeOf((Object[])this.closedSlices) + this.closedSlicesRetainedSize;
        return (long)INSTANCE_SIZE + this.openSliceOutput.getRetainedSize() + offsetsSize + closedSlicesSize;
    }

    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        throw new UnsupportedOperationException("retainedBytesForEachPart is not supported by SegmentedSliceBlockBuilder");
    }

    public Block copyPositions(int[] positions, int offset, int length) {
        throw new UnsupportedOperationException("copyPositions is not supported by SegmentedSliceBlockBuilder");
    }

    public BlockBuilder writeByte(int value) {
        throw new UnsupportedOperationException("writeByte is not supported by SegmentedSliceBlockBuilder");
    }

    public BlockBuilder writeShort(int value) {
        throw new UnsupportedOperationException("writeShort is not supported by SegmentedSliceBlockBuilder");
    }

    public BlockBuilder writeInt(int value) {
        throw new UnsupportedOperationException("writeInt is not supported by SegmentedSliceBlockBuilder");
    }

    public BlockBuilder writeLong(long value) {
        throw new UnsupportedOperationException("writeLong is not supported by SegmentedSliceBlockBuilder");
    }

    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        if (this.openSegmentOffset == 0) {
            if (this.openSegmentIndex >= this.offsets.length) {
                int newCapacity = Math.max(this.openSegmentIndex + 1, (int)((double)this.offsets.length * 1.5));
                this.closedSlices = Arrays.copyOf(this.closedSlices, newCapacity);
                this.offsets = (int[][])Arrays.copyOf(this.offsets, newCapacity);
            }
            if (this.offsets[this.openSegmentIndex] == null) {
                this.offsets[this.openSegmentIndex] = new int[16385];
            }
        }
        this.openSliceOutput.writeBytes(source, sourceIndex, length);
        return this;
    }

    public BlockBuilder closeEntry() {
        ++this.openSegmentOffset;
        this.offsets[this.openSegmentIndex][this.openSegmentOffset] = this.openSliceOutput.size();
        if (this.openSegmentOffset == 16384) {
            Slice slice;
            this.closedSlices[this.openSegmentIndex] = slice = this.openSliceOutput.copySlice();
            this.closedSlicesSizeInBytes += (long)slice.length();
            this.closedSlicesRetainedSize += slice.getRetainedSize();
            this.openSliceOutput.reset();
            this.openSegmentOffset = 0;
            ++this.openSegmentIndex;
        }
        return this;
    }

    public BlockBuilder appendNull() {
        throw new UnsupportedOperationException("appendNull is not supported by SegmentedSliceBlockBuilder");
    }

    public BlockBuilder readPositionFrom(SliceInput input) {
        throw new UnsupportedOperationException("readPositionFrom is not supported by SegmentedSliceBlockBuilder");
    }

    public boolean mayHaveNull() {
        return false;
    }

    protected boolean isEntryNull(int position) {
        return false;
    }

    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException("getRegion is not supported by SegmentedSliceBlockBuilder");
    }

    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException("copyRegion is not supported by SegmentedSliceBlockBuilder");
    }

    public Block build() {
        throw new UnsupportedOperationException("build is not supported by SegmentedSliceBlockBuilder");
    }

    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        return this.newBlockBuilderLike(blockBuilderStatus, this.getPositionCount());
    }

    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        if (blockBuilderStatus != null) {
            throw new UnsupportedOperationException("blockBuilderStatus is not supported by SegmentedSliceBlockBuilder");
        }
        return new SegmentedSliceBlockBuilder(expectedEntries, this.openSliceOutput.getUnderlyingSlice().length());
    }

    private int getOffset(int position) {
        int offset = Segments.offset(position);
        int segment = Segments.segment(position);
        return this.offsets[segment][offset];
    }

    public String toString() {
        return String.format("SegmentedSliceBlockBuilder(%d){positionCount=%d,size=%d}", ((Object)((Object)this)).hashCode(), this.getPositionCount(), this.openSliceOutput.size());
    }

    public boolean isNullUnchecked(int internalPosition) {
        return false;
    }

    public int getOffsetBase() {
        return 0;
    }

    public boolean equals(int position, Block block, int blockPosition, int blockLength) {
        int offset;
        int segmentOffset;
        int segment = Segments.segment(position);
        int length = this.offsets[segment][(segmentOffset = Segments.offset(position)) + 1] - (offset = this.offsets[segment][segmentOffset]);
        return blockLength == length && block.bytesEqual(blockPosition, 0, this.getSegmentRawSlice(segment), offset, length);
    }

    public int compareTo(int left, int right) {
        int leftSegment = Segments.segment(left);
        int leftSegmentOffset = Segments.offset(left);
        int rightSegment = Segments.segment(right);
        int rightSegmentOffset = Segments.offset(right);
        Slice leftRawSlice = this.getSegmentRawSlice(leftSegment);
        int leftOffset = this.offsets[leftSegment][leftSegmentOffset];
        int leftLen = this.offsets[leftSegment][leftSegmentOffset + 1] - leftOffset;
        Slice rightRawSlice = this.getSegmentRawSlice(rightSegment);
        int rightOffset = this.offsets[rightSegment][rightSegmentOffset];
        int rightLen = this.offsets[rightSegment][rightSegmentOffset + 1] - rightOffset;
        return leftRawSlice.compareTo(leftOffset, leftLen, rightRawSlice, rightOffset, rightLen);
    }

    public long hash(int position) {
        int segment = Segments.segment(position);
        int segmentOffset = Segments.offset(position);
        int offset = this.offsets[segment][segmentOffset];
        int length = this.offsets[segment][segmentOffset + 1] - offset;
        return XxHash64.hash((Slice)this.getSegmentRawSlice(segment), (int)offset, (int)length);
    }

    @VisibleForTesting
    int getOpenSegmentIndex() {
        return this.openSegmentIndex;
    }

    static class Segments {
        public static final int INITIAL_SEGMENTS = 64;
        public static final int SEGMENT_SHIFT = 14;
        public static final int SEGMENT_SIZE = 16384;
        public static final int SEGMENT_MASK = 16383;

        Segments() {
        }

        public static int segment(int index) {
            return index >>> 14;
        }

        public static int offset(int index) {
            return index & 0x3FFF;
        }

        public static int getPositions(int segment, int offset) {
            return (segment << 14) + offset;
        }
    }
}

