/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.StringStatisticsBuilder;
import com.facebook.presto.orc.stream.ByteArrayOutputStream;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.facebook.presto.orc.writer.SliceDictionaryBuilder;
import com.facebook.presto.orc.writer.SliceDirectColumnWriter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import it.unimi.dsi.fastutil.ints.IntArrays;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class SliceDictionaryColumnWriter
extends DictionaryColumnWriter {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(SliceDictionaryColumnWriter.class).instanceSize();
    private static final int DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES = Math.toIntExact(new DataSize(32.0, DataSize.Unit.MEGABYTE).toBytes());
    private static final int NULL_INDEX = -1;
    private final ByteArrayOutputStream dictionaryDataStream;
    private final LongOutputStream dictionaryLengthStream;
    private final SliceDictionaryBuilder dictionary = new SliceDictionaryBuilder(10000);
    private final int stringStatisticsLimitInBytes;
    private final boolean sortDictionaryKeys;
    private StringStatisticsBuilder statisticsBuilder;
    private ColumnEncoding columnEncoding;
    private SliceDirectColumnWriter directColumnWriter;

    public SliceDictionaryColumnWriter(int column, Type type, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, MetadataWriter metadataWriter) {
        super(column, type, columnWriterOptions, dwrfEncryptor, orcEncoding, metadataWriter);
        this.dictionaryDataStream = new ByteArrayOutputStream(columnWriterOptions, dwrfEncryptor, Stream.StreamKind.DICTIONARY_DATA);
        this.dictionaryLengthStream = LongOutputStream.createLengthOutputStream(columnWriterOptions, dwrfEncryptor, orcEncoding);
        this.stringStatisticsLimitInBytes = Math.toIntExact(columnWriterOptions.getStringStatisticsLimit().toBytes());
        this.statisticsBuilder = this.newStringStatisticsBuilder();
        this.sortDictionaryKeys = columnWriterOptions.isStringDictionarySortingEnabled();
        Preconditions.checkState((this.sortDictionaryKeys || orcEncoding == OrcEncoding.DWRF ? 1 : 0) != 0, (Object)"Disabling sort is only supported in DWRF format");
    }

    @Override
    public int getDictionaryBytes() {
        Preconditions.checkState((!this.isDirectEncoded() ? 1 : 0) != 0);
        return Math.toIntExact(this.dictionary.getSizeInBytes());
    }

    @Override
    public int getDictionaryEntries() {
        Preconditions.checkState((!this.isDirectEncoded() ? 1 : 0) != 0);
        return this.dictionary.getEntryCount();
    }

    @Override
    protected boolean tryConvertRowGroupToDirect(int dictionaryIndexCount, int[] dictionaryIndexes, int maxDirectBytes) {
        for (int offset = 0; offset < dictionaryIndexCount; ++offset) {
            this.directColumnWriter.writePresentValue(dictionaryIndexes[offset] != -1);
        }
        long size = 0L;
        for (int offset = 0; offset < dictionaryIndexCount; ++offset) {
            int dictionaryIndex = dictionaryIndexes[offset];
            if (dictionaryIndex == -1) continue;
            int length = this.dictionary.getSliceLength(dictionaryIndex);
            Slice rawSlice = this.dictionary.getRawSlice(dictionaryIndex);
            int rawSliceOffset = this.dictionary.getRawSliceOffset(dictionaryIndex);
            this.directColumnWriter.writeSlice(rawSlice, rawSliceOffset, length);
            if ((size += (long)length) <= (long)DIRECT_CONVERSION_CHUNK_MAX_LOGICAL_BYTES) continue;
            if (this.directColumnWriter.getBufferedBytes() > (long)maxDirectBytes) {
                return false;
            }
            size = 0L;
        }
        return this.directColumnWriter.getBufferedBytes() <= (long)maxDirectBytes;
    }

    @Override
    protected ColumnEncoding getDictionaryColumnEncoding() {
        Preconditions.checkState((this.columnEncoding != null ? 1 : 0) != 0);
        return this.columnEncoding;
    }

    @Override
    protected DictionaryColumnWriter.BlockStatistics addBlockToDictionary(Block block, int rowGroupValueCount, int[] rowGroupIndexes) {
        int nonNullValueCount = 0;
        long rawBytes = 0L;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            int index;
            if (!block.isNull(position)) {
                index = this.dictionary.putIfAbsent(block, position);
                Slice slice = this.type.getSlice(block, position);
                this.statisticsBuilder.addValue(slice, 0, slice.length());
                rawBytes += (long)block.getSliceLength(position);
                ++nonNullValueCount;
            } else {
                index = -1;
            }
            rowGroupIndexes[rowGroupValueCount++] = index;
        }
        long rawBytesIncludingNulls = rawBytes + (long)(block.getPositionCount() - nonNullValueCount) * 1L;
        return new DictionaryColumnWriter.BlockStatistics(nonNullValueCount, rawBytes, rawBytesIncludingNulls);
    }

    @Override
    protected void closeDictionary() {
        this.dictionary.clear();
        this.dictionaryDataStream.close();
        this.dictionaryLengthStream.close();
    }

    @Override
    protected ColumnStatistics createColumnStatistics() {
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.statisticsBuilder = this.newStringStatisticsBuilder();
        return statistics;
    }

    private static int[] getSortedDictionary(SliceDictionaryBuilder dictionary) {
        int[] sortedPositions = new int[dictionary.getEntryCount()];
        for (int i = 0; i < sortedPositions.length; ++i) {
            sortedPositions[i] = i;
        }
        IntArrays.quickSort((int[])sortedPositions, (int)0, (int)sortedPositions.length, dictionary::compareIndex);
        return sortedPositions;
    }

    @Override
    protected Optional<int[]> writeDictionary() {
        ColumnEncoding.ColumnEncodingKind encodingKind = this.orcEncoding == OrcEncoding.DWRF ? ColumnEncoding.ColumnEncodingKind.DICTIONARY : ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2;
        int dictionaryEntryCount = this.dictionary.getEntryCount();
        this.columnEncoding = new ColumnEncoding(encodingKind, dictionaryEntryCount);
        if (this.sortDictionaryKeys) {
            return this.writeSortedDictionary();
        }
        for (int i = 0; i < dictionaryEntryCount; ++i) {
            this.writeDictionaryEntry(i);
        }
        return Optional.empty();
    }

    private Optional<int[]> writeSortedDictionary() {
        int[] sortedDictionaryIndexes;
        for (int sortedDictionaryIndex : sortedDictionaryIndexes = SliceDictionaryColumnWriter.getSortedDictionary(this.dictionary)) {
            this.writeDictionaryEntry(sortedDictionaryIndex);
        }
        int[] originalDictionaryToSortedIndex = new int[sortedDictionaryIndexes.length];
        int sortOrdinal = 0;
        while (sortOrdinal < sortedDictionaryIndexes.length) {
            int dictionaryIndex = sortedDictionaryIndexes[sortOrdinal];
            originalDictionaryToSortedIndex[dictionaryIndex] = sortOrdinal++;
        }
        return Optional.of(originalDictionaryToSortedIndex);
    }

    private void writeDictionaryEntry(int dictionaryIndex) {
        int length = this.dictionary.getSliceLength(dictionaryIndex);
        this.dictionaryLengthStream.writeLong(length);
        Slice rawSlice = this.dictionary.getRawSlice(dictionaryIndex);
        int rawSliceOffset = this.dictionary.getRawSliceOffset(dictionaryIndex);
        this.dictionaryDataStream.writeSlice(rawSlice, rawSliceOffset, length);
    }

    @Override
    protected void writePresentAndDataStreams(int rowGroupValueCount, int[] rowGroupIndexes, Optional<int[]> optionalSortedIndex, PresentOutputStream presentStream, LongOutputStream dataStream) {
        int position;
        Preconditions.checkState((optionalSortedIndex.isPresent() == this.sortDictionaryKeys ? 1 : 0) != 0, (String)"SortedIndex and sortDictionaryKeys(%s) are inconsistent", (Object)this.sortDictionaryKeys);
        for (position = 0; position < rowGroupValueCount; ++position) {
            presentStream.writeBoolean(rowGroupIndexes[position] != -1);
        }
        if (this.sortDictionaryKeys) {
            int[] sortedIndexes = optionalSortedIndex.get();
            for (int position2 = 0; position2 < rowGroupValueCount; ++position2) {
                int originalDictionaryIndex = rowGroupIndexes[position2];
                if (originalDictionaryIndex == -1) continue;
                int sortedIndex = sortedIndexes[originalDictionaryIndex];
                if (sortedIndex < 0) {
                    throw new IllegalArgumentException(String.format("Invalid index %s at position %s", sortedIndex, position2));
                }
                dataStream.writeLong(sortedIndex);
            }
        } else {
            for (position = 0; position < rowGroupValueCount; ++position) {
                int dictionaryIndex = rowGroupIndexes[position];
                if (dictionaryIndex == -1) continue;
                if (dictionaryIndex < 0) {
                    throw new IllegalArgumentException(String.format("Invalid index %s at position %s", dictionaryIndex, position));
                }
                dataStream.writeLong(dictionaryIndex);
            }
        }
    }

    @Override
    protected long getRetainedDictionaryBytes() {
        return INSTANCE_SIZE + this.dictionaryDataStream.getRetainedBytes() + this.dictionaryLengthStream.getRetainedBytes() + this.dictionary.getRetainedSizeInBytes() + (this.directColumnWriter == null ? 0L : this.directColumnWriter.getRetainedBytes());
    }

    @Override
    protected void resetDictionary() {
        this.columnEncoding = null;
        this.dictionary.clear();
        this.dictionaryDataStream.reset();
        this.dictionaryLengthStream.reset();
        this.statisticsBuilder = this.newStringStatisticsBuilder();
    }

    private StringStatisticsBuilder newStringStatisticsBuilder() {
        return new StringStatisticsBuilder(this.stringStatisticsLimitInBytes);
    }

    @Override
    protected ColumnWriter createDirectColumnWriter() {
        if (this.directColumnWriter == null) {
            this.directColumnWriter = new SliceDirectColumnWriter(this.column, this.type, this.columnWriterOptions, this.dwrfEncryptor, this.orcEncoding, this::newStringStatisticsBuilder, this.metadataWriter);
        }
        return this.directColumnWriter;
    }

    @Override
    protected ColumnWriter getDirectColumnWriter() {
        Preconditions.checkState((this.directColumnWriter != null ? 1 : 0) != 0);
        return this.directColumnWriter;
    }

    @Override
    protected List<StreamDataOutput> getDictionaryStreams(int column) {
        return ImmutableList.of((Object)this.dictionaryLengthStream.getStreamDataOutput(column), (Object)this.dictionaryDataStream.getStreamDataOutput(column));
    }
}

