/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.com.google.common.collect;

import com.facebook.presto.hive.$internal.com.google.common.annotations.GwtCompatible;
import com.facebook.presto.hive.$internal.com.google.common.annotations.GwtIncompatible;
import com.facebook.presto.hive.$internal.com.google.common.collect.CollectSpliterators;
import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableList;
import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableSortedSet;
import com.facebook.presto.hive.$internal.com.google.common.collect.RegularImmutableAsList;
import com.facebook.presto.hive.$internal.com.google.common.collect.RegularImmutableSortedSet;
import com.facebook.presto.hive.$internal.com.google.common.collect.SortedIterable;
import java.util.Comparator;
import java.util.Spliterator;
import org.checkerframework.checker.nullness.compatqual.NullableDecl;

@GwtCompatible(emulated=true)
final class ImmutableSortedAsList<E>
extends RegularImmutableAsList<E>
implements SortedIterable<E> {
    ImmutableSortedAsList(ImmutableSortedSet<E> backingSet, ImmutableList<E> backingList) {
        super(backingSet, backingList);
    }

    @Override
    ImmutableSortedSet<E> delegateCollection() {
        return (ImmutableSortedSet)super.delegateCollection();
    }

    @Override
    public Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.delegateCollection()).comparator();
    }

    @Override
    @GwtIncompatible
    public int indexOf(@NullableDecl Object target) {
        int index = ((ImmutableSortedSet)this.delegateCollection()).indexOf(target);
        return index >= 0 && this.get(index).equals(target) ? index : -1;
    }

    @Override
    @GwtIncompatible
    public int lastIndexOf(@NullableDecl Object target) {
        return this.indexOf(target);
    }

    @Override
    public boolean contains(Object target) {
        return this.indexOf(target) >= 0;
    }

    @Override
    @GwtIncompatible
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        ImmutableList parentSubList = super.subListUnchecked(fromIndex, toIndex);
        return new RegularImmutableSortedSet(parentSubList, this.comparator()).asList();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1301, this.delegateList()::get, this.comparator());
    }
}

