/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.jsonexplain;

import com.facebook.presto.hive.$internal.org.json.JSONObject;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hive.common.jsonexplain.Connection;
import org.apache.hadoop.hive.common.jsonexplain.JsonParser;
import org.apache.hadoop.hive.common.jsonexplain.Op;
import org.apache.hadoop.hive.common.jsonexplain.Printer;
import org.apache.hadoop.hive.common.jsonexplain.Stage;
import org.apache.hadoop.hive.common.jsonexplain.Vertex;

public abstract class DagJsonParser
implements JsonParser {
    public final Map<String, Stage> stages = new LinkedHashMap<String, Stage>();
    protected final Logger LOG;
    public final Set<Object> printSet = new LinkedHashSet<Object>();
    public final Map<Op, List<Connection>> inlineMap = new LinkedHashMap<Op, List<Connection>>();
    public boolean rewriteObject;

    public DagJsonParser() {
        this.LOG = LoggerFactory.getLogger(this.getClass().getName());
    }

    public void extractStagesAndPlans(JSONObject inputObject) throws Exception {
        JSONObject stagePlans;
        JSONObject dependency = inputObject.getJSONObject("STAGE DEPENDENCIES");
        if (dependency != null && dependency.length() > 0) {
            for (String stageName : JSONObject.getNames(dependency)) {
                this.stages.put(stageName, new Stage(stageName, this));
            }
            for (String stageName : JSONObject.getNames(dependency)) {
                JSONObject dependentStageNames = dependency.getJSONObject(stageName);
                this.stages.get(stageName).addDependency(dependentStageNames, this.stages);
            }
        }
        if ((stagePlans = inputObject.getJSONObject("STAGE PLANS")) != null && stagePlans.length() > 0) {
            for (String stageName : JSONObject.getNames(stagePlans)) {
                JSONObject stagePlan = stagePlans.getJSONObject(stageName);
                this.stages.get(stageName).extractVertex(stagePlan);
            }
        }
    }

    public static String prefixString(int indentFlag) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indentFlag; ++index) {
            sb.append("  ");
        }
        return sb.toString();
    }

    public static String prefixString(int indentFlag, String tail) {
        StringBuilder sb = new StringBuilder();
        for (int index = 0; index < indentFlag; ++index) {
            sb.append("  ");
        }
        int len = sb.length();
        return sb.replace(len - tail.length(), len, tail).toString();
    }

    @Override
    public void print(JSONObject inputObject, PrintStream outputStream) throws Exception {
        this.LOG.info("JsonParser is parsing:" + inputObject.toString());
        this.rewriteObject = outputStream == null;
        this.extractStagesAndPlans(inputObject);
        if (this.rewriteObject) {
            return;
        }
        Printer printer = new Printer();
        if (inputObject.has("cboInfo")) {
            printer.println(inputObject.getString("cboInfo"));
            printer.println();
        }
        for (Stage candidate : this.stages.values()) {
            if (candidate.tezStageDependency == null || candidate.tezStageDependency.size() <= 0) continue;
            if (candidate.parentStages.size() == 0) {
                printer.println("Vertex dependency in root stage");
            } else {
                printer.println("Vertex dependency in " + candidate.externalName);
            }
            for (Map.Entry<Vertex, List<Connection>> entry : candidate.tezStageDependency.entrySet()) {
                StringBuilder sb = new StringBuilder();
                sb.append(entry.getKey().name);
                sb.append(" <- ");
                boolean printcomma = false;
                for (Connection connection : entry.getValue()) {
                    if (printcomma) {
                        sb.append(", ");
                    } else {
                        printcomma = true;
                    }
                    sb.append(connection.from.name + " (" + connection.type + ")");
                }
                printer.println(sb.toString());
            }
            printer.println();
        }
        for (Stage candidate : this.stages.values()) {
            if (!candidate.childStages.isEmpty()) continue;
            candidate.print(printer, 0);
        }
        outputStream.println(printer.toString());
    }

    public void addInline(Op op, Connection connection) {
        List<Connection> list = this.inlineMap.get(op);
        if (list == null) {
            list = new ArrayList<Connection>();
            list.add(connection);
            this.inlineMap.put(op, list);
        } else {
            list.add(connection);
        }
    }

    public boolean isInline(Vertex v) {
        for (List<Connection> list : this.inlineMap.values()) {
            for (Connection connection : list) {
                if (!connection.from.equals(v)) continue;
                return true;
            }
        }
        return false;
    }

    public abstract String mapEdgeType(String var1);

    public abstract String getFrameworkName();
}

