/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.debug;

import com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import javax.management.MBeanServer;

public class Utils {
    private static final Logger LOG;
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static volatile Object hotspotMBean;
    private static final Method DUMP_HEAP_METHOD;
    private static final Class HOTSPOT_MXBEAN_CLASS;

    public static void dumpHeapToTmp(String ... args) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        if (StringUtils.isBlank(tmpDir)) {
            tmpDir = "/tmp/";
        }
        String fileName = tmpDir + File.pathSeparatorChar + "dump";
        for (String arg : args) {
            fileName = fileName + "_" + arg;
        }
        fileName = fileName + "_" + System.nanoTime() + ".hprof";
        Utils.dumpHeap(fileName, true);
    }

    public static void dumpHeap(String fileName, boolean live) {
        if (hotspotMBean == null) {
            try {
                MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                hotspotMBean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, HOTSPOT_MXBEAN_CLASS);
            }
            catch (IOException e) {
                LOG.error(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        if (DUMP_HEAP_METHOD != null) {
            try {
                DUMP_HEAP_METHOD.invoke(hotspotMBean, fileName, live);
            }
            catch (RuntimeException re) {
                LOG.error(re.getMessage());
                throw re;
            }
            catch (Exception exp) {
                LOG.error(exp.getMessage());
                throw new RuntimeException(exp);
            }
        } else {
            LOG.error("Cannot find method dumpHeap() in com.sun.management.HotSpotDiagnosticMXBean.");
        }
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        try {
            String first = new String(b, off, len, "ISO-8859-1");
            for (int i = 0; i < first.length(); ++i) {
                int ch = first.charAt(i) & 0xFF;
                if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || " `~!@#$%^&*()-_=+[]{}\\|;:'\",.<>/?".indexOf(ch) >= 0) {
                    result.append(first.charAt(i));
                    continue;
                }
                result.append(String.format("\\x%02X", ch));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("ISO-8859-1 not supported?", e);
        }
        return result.toString();
    }

    static {
        Method method;
        Class<?> clazz;
        LOG = LoggerFactory.getLogger(Utils.class.getName());
        try {
            clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
            method = clazz.getMethod("dumpHeap", String.class, Boolean.class);
        }
        catch (ClassNotFoundException ce) {
            LOG.error("com.sun.management.HotSpotDiagnosticMXBean is not supported.", ce);
            throw new RuntimeException(ce);
        }
        catch (NoSuchMethodException ne) {
            LOG.error("Failed to inject operation dumpHeap.", ne);
            throw new RuntimeException(ne);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
        HOTSPOT_MXBEAN_CLASS = clazz;
        DUMP_HEAP_METHOD = method;
    }
}

