/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;

public class InterruptibleProcessing {
    private static final Logger LOG = LoggerFactory.getLogger(InterruptibleProcessing.class);
    private static final int CHECK_INTERRUPTION_AFTER_ROWS_DEFAULT = 1000;
    private static final int CHECK_INTERRUPTION_AFTER_ROWS_MAX = 100000;
    private static final int CHECK_INTERRUPTION_AFTER_ROWS_MIN = 1;
    private static final double TARGET_INTERRUPT_CHECK_TIME_NS = 3.0E9;
    private int checkInterruptionAfterRows = 1000;
    private long lastInterruptCheckNs = 0L;
    private int nRows;
    private volatile boolean isAborted;

    public final void startAbortChecks() {
        this.lastInterruptCheckNs = System.nanoTime();
        this.nRows = 0;
    }

    public final void addRowAndMaybeCheckAbort() throws InterruptedException {
        if (this.nRows++ < this.checkInterruptionAfterRows) {
            return;
        }
        long time = System.nanoTime();
        this.checkAbortCondition();
        long elapsedNs = time - this.lastInterruptCheckNs;
        if (elapsedNs >= 0L) {
            double diff = elapsedNs == 0L ? 10.0 : 3.0E9 / (double)elapsedNs;
            int newRows = Math.min(100000, Math.max(1, (int)(diff * (double)this.checkInterruptionAfterRows)));
            if (this.checkInterruptionAfterRows != newRows && LOG.isDebugEnabled()) {
                LOG.debug("Adjusting abort check rows to " + newRows + " from " + this.checkInterruptionAfterRows);
            }
            this.checkInterruptionAfterRows = newRows;
        }
        this.nRows = 0;
        this.lastInterruptCheckNs = time;
    }

    public final void checkAbortCondition() throws InterruptedException {
        boolean isInterrupted = Thread.currentThread().isInterrupted();
        if (!this.isAborted && !isInterrupted) {
            return;
        }
        throw new InterruptedException("Processing thread aborted. Interrupt state: " + isInterrupted);
    }

    public final void setAborted(boolean b) {
        this.isAborted = b;
    }

    public void abort() {
        this.setAborted(true);
    }

    public final boolean isAborted() {
        return this.isAborted;
    }
}

