/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.DateTimeMath;
import org.apache.hadoop.hive.serde2.io.DateWritable;

public class DateColAddIntervalDayTimeScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum;
    private final HiveIntervalDayTime value;
    private final transient Timestamp scratchTimestamp1 = new Timestamp(0L);
    private final transient DateTimeMath dtm = new DateTimeMath();

    public DateColAddIntervalDayTimeScalar(int colNum, HiveIntervalDayTime value, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.value = value;
    }

    public DateColAddIntervalDayTimeScalar() {
        this.colNum = -1;
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector inputColVector1 = (LongColumnVector)batch.cols[this.colNum];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColVector1.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.isRepeating = false;
        long[] vector1 = inputColVector1.vector;
        if (inputColVector1.isRepeating) {
            if (inputColVector1.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[0]));
                this.dtm.add(this.scratchTimestamp1, this.value, outputColVector.getScratchTimestamp());
                outputColVector.setFromScratchTimestamp(0);
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColVector1.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                        this.dtm.add(this.scratchTimestamp1, this.value, outputColVector.getScratchTimestamp());
                        outputColVector.setFromScratchTimestamp(i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                        this.dtm.add(this.scratchTimestamp1, this.value, outputColVector.getScratchTimestamp());
                        outputColVector.setFromScratchTimestamp(i);
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                    this.dtm.add(this.scratchTimestamp1, this.value, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                    this.dtm.add(this.scratchTimestamp1, this.value, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inputIsNull[i]) {
                    outputIsNull[i] = false;
                    this.scratchTimestamp1.setTime(DateWritable.daysToMillis((int)vector1[i]));
                    this.dtm.add(this.scratchTimestamp1, this.value, outputColVector.getScratchTimestamp());
                    outputColVector.setFromScratchTimestamp(i);
                    continue;
                }
                outputIsNull[i] = true;
                outputColVector.noNulls = false;
            }
        }
        NullUtil.setNullOutputEntriesColScalar(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", val " + this.value.toString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("date"), VectorExpressionDescriptor.ArgumentType.getType("interval_day_time")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

