/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.facebook.presto.hive.$internal.com.google.common.base.Preconditions;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import org.apache.hadoop.hive.common.MemoryEstimate;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.serde2.WriteBuffers;

public class VectorMapJoinFastValueStore
implements MemoryEstimate {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastValueStore.class.getName());
    private WriteBuffers writeBuffers;

    public WriteBuffers writeBuffers() {
        return this.writeBuffers;
    }

    @Override
    public long getEstimatedMemorySize() {
        return this.writeBuffers == null ? 0L : this.writeBuffers.getEstimatedMemorySize();
    }

    private static String valueRefWordToString(long valueRef) {
        StringBuilder sb = new StringBuilder();
        sb.append(Long.toHexString(valueRef));
        sb.append(", ");
        if ((valueRef & Long.MIN_VALUE) != 0L) {
            sb.append("(Invalid optimized hash table reference), ");
        }
        long absoluteValueOffset = valueRef & 0xFFFFFFFFFFL;
        int smallValueLength = (int)((valueRef & 0x3FF0000000000L) >> 40);
        boolean isValueLengthSmall = smallValueLength != 1023;
        int cappedCount = (int)((valueRef & 0xFFC000000000000L) >> 50);
        boolean isValueLast = (valueRef & 0x1000000000000000L) != 0L;
        sb.append("absoluteValueOffset ");
        sb.append(absoluteValueOffset);
        sb.append(" (");
        sb.append(Long.toHexString(absoluteValueOffset));
        sb.append("), ");
        if (isValueLengthSmall) {
            sb.append("smallValueLength ");
            sb.append(smallValueLength);
            sb.append(", ");
        } else {
            sb.append("isValueLengthSmall = false, ");
        }
        sb.append("cappedCount ");
        sb.append(cappedCount);
        sb.append(", ");
        sb.append("isValueLast ");
        sb.append(isValueLast);
        return sb.toString();
    }

    private static String relativeOffsetWordToString(long relativeOffsetWord) {
        StringBuilder sb = new StringBuilder();
        sb.append(Long.toHexString(relativeOffsetWord));
        sb.append(", ");
        long nextRelativeOffset = (relativeOffsetWord & 0x3FFFFFFFFFCL) >> 2;
        sb.append("nextRelativeOffset ");
        sb.append(nextRelativeOffset);
        sb.append(" (");
        sb.append(Long.toHexString(nextRelativeOffset));
        sb.append("), ");
        boolean isNextLast = (relativeOffsetWord & 2L) != 0L;
        sb.append("isNextLast ");
        sb.append(isNextLast);
        sb.append(", ");
        boolean isNextValueLengthSmall = (relativeOffsetWord & 1L) != 0L;
        sb.append("isNextValueLengthSmall ");
        sb.append(isNextValueLengthSmall);
        return sb.toString();
    }

    public long addFirst(byte[] valueBytes, int valueStart, int valueLength) {
        long newAbsoluteOffset;
        long valueRefWord = 0x1000000000000000L;
        valueRefWord |= 0x4000000000000L;
        if (valueLength < 1023) {
            if (valueLength == 0) {
                newAbsoluteOffset = this.writeBuffers.getWritePoint();
            } else {
                newAbsoluteOffset = this.writeBuffers.getWritePoint();
                this.writeBuffers.write(valueBytes, valueStart, valueLength);
            }
            valueRefWord |= (long)valueLength << 40;
        } else {
            newAbsoluteOffset = this.writeBuffers.getWritePoint();
            this.writeBuffers.writeVInt(valueLength);
            this.writeBuffers.write(valueBytes, valueStart, valueLength);
            valueRefWord |= 0x3FF0000000000L;
        }
        return valueRefWord |= newAbsoluteOffset;
    }

    public long addMore(long oldValueRef, byte[] valueBytes, int valueStart, int valueLength) {
        boolean isNewValueSmall;
        int newCappedCount;
        if ((oldValueRef & Long.MIN_VALUE) != 0L) {
            throw new RuntimeException("Invalid optimized hash table reference");
        }
        long oldAbsoluteValueOffset = oldValueRef & 0xFFFFFFFFFFL;
        int oldSmallValueLength = (int)((oldValueRef & 0x3FF0000000000L) >> 40);
        boolean isOldValueLengthSmall = oldSmallValueLength != 1023;
        int oldCappedCount = (int)((oldValueRef & 0xFFC000000000000L) >> 50);
        boolean isOldValueLast = (oldValueRef & 0x1000000000000000L) != 0L;
        long newAbsoluteOffset = this.writeBuffers.getWritePoint();
        long relativeOffsetWord = 0L;
        if (isOldValueLengthSmall) {
            relativeOffsetWord |= 1L;
        }
        if (isOldValueLast) {
            relativeOffsetWord |= 2L;
        }
        if ((newCappedCount = oldCappedCount) < 1023) {
            ++newCappedCount;
        }
        long relativeOffset = newAbsoluteOffset - oldAbsoluteValueOffset;
        this.writeBuffers.writeVLong(relativeOffsetWord |= relativeOffset << 2);
        long newValueRef = (long)newCappedCount << 50;
        boolean bl = isNewValueSmall = valueLength < 1023;
        if (!isNewValueSmall) {
            Preconditions.checkState((int)(((newValueRef |= 0x3FF0000000000L) & 0x3FF0000000000L) >> 40) == 1023);
            this.writeBuffers.writeVInt(valueLength);
        } else {
            newValueRef |= (long)valueLength << 40;
        }
        if (isOldValueLengthSmall) {
            this.writeBuffers.writeVInt(oldSmallValueLength);
        }
        this.writeBuffers.write(valueBytes, valueStart, valueLength);
        return newValueRef |= newAbsoluteOffset;
    }

    public VectorMapJoinFastValueStore(int writeBuffersSize) {
        this.writeBuffers = new WriteBuffers(writeBuffersSize, 0x4000000000L);
    }

    private final class NextRelativeValueOffset {
        private static final int bitLength = 40;
        private static final long allBitsOn = 0xFFFFFFFFFFL;
        private static final int bitShift = 2;
        private static final long bitMask = 0x3FFFFFFFFFCL;

        private NextRelativeValueOffset() {
        }
    }

    private final class IsNextValueLastFlag {
        private static final int bitLength = 1;
        private static final int bitShift = 1;
        private static final long flagOnMask = 2L;

        private IsNextValueLastFlag() {
        }
    }

    private final class IsNextValueLengthSmallFlag {
        private static final int bitLength = 1;
        private static final long flagOnMask = 1L;

        private IsNextValueLengthSmallFlag() {
        }
    }

    private final class IsInvalidFlag {
        private static final int bitShift = 63;
        private static final long flagOnMask = Long.MIN_VALUE;

        private IsInvalidFlag() {
        }
    }

    private final class IsLastFlag {
        private static final int bitShift = 60;
        private static final long flagOnMask = 0x1000000000000000L;

        private IsLastFlag() {
        }
    }

    private final class CappedCount {
        private static final int bitLength = 10;
        private static final int allBitsOn = 1023;
        private static final int limit = 1023;
        private static final int bitShift = 50;
        private static final long bitMask = 0xFFC000000000000L;

        private CappedCount() {
        }
    }

    private final class SmallValueLength {
        private static final int bitLength = 10;
        private static final int allBitsOn = 1023;
        private static final int threshold = 1023;
        private static final int bitShift = 40;
        private static final long bitMask = 0x3FF0000000000L;
        private static final long allBitsOnBitShifted = 0x3FF0000000000L;

        private SmallValueLength() {
        }
    }

    private final class AbsoluteValueOffset {
        private static final int bitLength = 40;
        private static final long allBitsOn = 0xFFFFFFFFFFL;
        private static final long bitMask = 0xFFFFFFFFFFL;
        private static final long maxSize = 0x4000000000L;

        private AbsoluteValueOffset() {
        }
    }

    public static class HashMapResult
    extends VectorMapJoinHashMapResult {
        private VectorMapJoinFastValueStore valueStore;
        private boolean hasRows = false;
        private long valueRefWord = -1L;
        private boolean isSingleRow;
        private int cappedCount;
        private int readIndex;
        private boolean isNextEof;
        private boolean isNextLast;
        long nextAbsoluteValueOffset;
        boolean isNextValueLengthSmall;
        int nextSmallValueLength;
        private WriteBuffers.ByteSegmentRef byteSegmentRef = new WriteBuffers.ByteSegmentRef();
        private WriteBuffers.Position readPos = new WriteBuffers.Position();

        public void set(VectorMapJoinFastValueStore valueStore, long valueRefWord) {
            this.valueStore = valueStore;
            this.valueRefWord = valueRefWord;
            this.hasRows = true;
            this.isSingleRow = (valueRefWord & 0x1000000000000000L) != 0L;
            this.cappedCount = (int)((valueRefWord & 0xFFC000000000000L) >> 50);
            this.readIndex = 0;
        }

        @Override
        public String getDetailedHashMapResultPositionString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Read index ");
            sb.append(this.readIndex);
            if (this.isSingleRow) {
                sb.append(" single row");
            } else {
                sb.append(" capped count ");
                sb.append(this.cappedCount);
            }
            if (this.readIndex > 0) {
                sb.append(" byteSegmentRef is byte[] of length ");
                sb.append(this.byteSegmentRef.getBytes().length);
                sb.append(" at offset ");
                sb.append(this.byteSegmentRef.getOffset());
                sb.append(" for length ");
                sb.append(this.byteSegmentRef.getLength());
                if (!this.isSingleRow) {
                    sb.append(" (isNextEof ");
                    sb.append(this.isNextEof);
                    sb.append(" isNextLast ");
                    sb.append(this.isNextLast);
                    sb.append(" nextAbsoluteValueOffset ");
                    sb.append(this.nextAbsoluteValueOffset);
                    sb.append(" isNextValueLengthSmall ");
                    sb.append(this.isNextValueLengthSmall);
                    sb.append(" nextSmallValueLength ");
                    sb.append(this.nextSmallValueLength);
                    sb.append(")");
                }
            }
            return sb.toString();
        }

        @Override
        public boolean hasRows() {
            return this.hasRows;
        }

        @Override
        public boolean isSingleRow() {
            if (!this.hasRows) {
                return false;
            }
            return this.isSingleRow;
        }

        @Override
        public boolean isCappedCountAvailable() {
            return true;
        }

        @Override
        public int cappedCount() {
            if (!this.hasRows) {
                return 0;
            }
            return this.cappedCount;
        }

        @Override
        public WriteBuffers.ByteSegmentRef first() {
            if (!this.hasRows) {
                return null;
            }
            this.readIndex = 0;
            return this.internalRead();
        }

        @Override
        public WriteBuffers.ByteSegmentRef next() {
            if (!this.hasRows) {
                return null;
            }
            return this.internalRead();
        }

        public WriteBuffers.ByteSegmentRef internalRead() {
            int valueLength;
            if (this.readIndex == 0) {
                long absoluteValueOffset = this.valueRefWord & 0xFFFFFFFFFFL;
                this.valueStore.writeBuffers.setReadPoint(absoluteValueOffset, this.readPos);
                if (this.isSingleRow) {
                    boolean isValueLengthSmall;
                    this.isNextEof = true;
                    valueLength = (int)((this.valueRefWord & 0x3FF0000000000L) >> 40);
                    boolean bl = isValueLengthSmall = valueLength != 1023;
                    if (!isValueLengthSmall) {
                        valueLength = this.valueStore.writeBuffers.readVInt(this.readPos);
                    }
                } else {
                    boolean isValueLengthSmall;
                    this.isNextEof = false;
                    long relativeOffsetWord = this.valueStore.writeBuffers.readVLong(this.readPos);
                    long relativeOffset = (relativeOffsetWord & 0x3FFFFFFFFFCL) >> 2;
                    this.nextAbsoluteValueOffset = absoluteValueOffset - relativeOffset;
                    valueLength = (int)((this.valueRefWord & 0x3FF0000000000L) >> 40);
                    boolean bl = isValueLengthSmall = valueLength != 1023;
                    if (!isValueLengthSmall) {
                        valueLength = this.valueStore.writeBuffers.readVInt(this.readPos);
                    }
                    this.isNextLast = (relativeOffsetWord & 2L) != 0L;
                    boolean bl2 = this.isNextValueLengthSmall = (relativeOffsetWord & 1L) != 0L;
                    this.nextSmallValueLength = this.isNextValueLengthSmall ? this.valueStore.writeBuffers.readVInt(this.readPos) : -1;
                }
            } else {
                if (this.isNextEof) {
                    return null;
                }
                long absoluteValueOffset = this.nextAbsoluteValueOffset;
                this.valueStore.writeBuffers.setReadPoint(absoluteValueOffset, this.readPos);
                if (this.isNextLast) {
                    this.isNextEof = true;
                    valueLength = this.isNextValueLengthSmall ? this.nextSmallValueLength : this.valueStore.writeBuffers.readVInt(this.readPos);
                } else {
                    this.isNextEof = false;
                    long relativeOffsetWord = this.valueStore.writeBuffers.readVLong(this.readPos);
                    valueLength = this.isNextValueLengthSmall ? this.nextSmallValueLength : this.valueStore.writeBuffers.readVInt(this.readPos);
                    long relativeOffset = (relativeOffsetWord & 0x3FFFFFFFFFCL) >> 2;
                    this.nextAbsoluteValueOffset = absoluteValueOffset - relativeOffset;
                    this.isNextLast = (relativeOffsetWord & 2L) != 0L;
                    this.isNextValueLengthSmall = (relativeOffsetWord & 1L) != 0L;
                    this.nextSmallValueLength = this.isNextValueLengthSmall ? this.valueStore.writeBuffers.readVInt(this.readPos) : -1;
                }
            }
            this.valueStore.writeBuffers.getByteSegmentRefToCurrent(this.byteSegmentRef, valueLength, this.readPos);
            ++this.readIndex;
            return this.byteSegmentRef;
        }

        @Override
        public void forget() {
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("(" + super.toString() + ", ");
            sb.append("cappedCount " + this.cappedCount() + ")");
            return sb.toString();
        }
    }
}

