/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.udf;

import org.apache.hadoop.hive.ql.exec.MapredContext;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFArgDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

public class VectorUDFAdaptor
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private String resultType;
    private VectorUDFArgDesc[] argDescs;
    private ExprNodeGenericFuncDesc expr;
    private boolean suppressEvaluateExceptions;
    private transient GenericUDF genericUDF;
    private transient GenericUDF.DeferredObject[] deferredChildren;
    private transient TypeInfo outputTypeInfo;
    private transient VectorAssignRow outputVectorAssignRow;
    private transient ObjectInspector[] childrenOIs;
    private transient VectorExpressionWriter[] writers;

    public VectorUDFAdaptor() {
    }

    public VectorUDFAdaptor(ExprNodeGenericFuncDesc expr, int outputColumnNum, String resultType, VectorUDFArgDesc[] argDescs) throws HiveException {
        super(outputColumnNum);
        this.expr = expr;
        this.resultType = resultType;
        this.argDescs = argDescs;
    }

    public void setSuppressEvaluateExceptions(boolean suppressEvaluateExceptions) {
        this.suppressEvaluateExceptions = suppressEvaluateExceptions;
    }

    public void init() throws HiveException, UDFArgumentException {
        this.genericUDF = this.expr.getGenericUDF();
        this.deferredChildren = new GenericUDF.DeferredObject[this.expr.getChildren().size()];
        this.childrenOIs = new ObjectInspector[this.expr.getChildren().size()];
        this.writers = VectorExpressionWriterFactory.getExpressionWriters(this.expr.getChildren());
        for (int i = 0; i < this.childrenOIs.length; ++i) {
            this.childrenOIs[i] = this.writers[i].getObjectInspector();
        }
        MapredContext context = MapredContext.get();
        if (context != null) {
            context.setup(this.genericUDF);
        }
        this.outputTypeInfo = this.expr.getTypeInfo();
        this.outputVectorAssignRow = new VectorAssignRow();
        this.outputVectorAssignRow.init(this.outputTypeInfo, this.outputColumnNum);
        this.genericUDF.initialize(this.childrenOIs);
        for (int i = 0; i < this.argDescs.length; ++i) {
            if (!this.argDescs[i].isConstant()) continue;
            this.argDescs[i].prepareConstant();
        }
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.genericUDF == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        int[] sel = batch.selected;
        int n = batch.size;
        ColumnVector outV = batch.cols[this.outputColumnNum];
        if (outV instanceof BytesColumnVector) {
            ((BytesColumnVector)outV).initBuffer();
        }
        if (n == 0) {
            return;
        }
        if (this.allInputColsRepeating(batch)) {
            this.setResult(0, batch);
            batch.cols[this.outputColumnNum].isRepeating = true;
            return;
        }
        batch.cols[this.outputColumnNum].isRepeating = false;
        if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                this.setResult(i, batch);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                this.setResult(i, batch);
            }
        }
    }

    private boolean allInputColsRepeating(VectorizedRowBatch batch) {
        int varArgCount = 0;
        for (int i = 0; i < this.argDescs.length; ++i) {
            if (this.argDescs[i].isVariable() && !batch.cols[this.argDescs[i].getColumnNum()].isRepeating) {
                return false;
            }
            ++varArgCount;
        }
        return varArgCount > 0;
    }

    private void setResult(int i, VectorizedRowBatch b) throws HiveException {
        Object result;
        for (int j = 0; j < this.argDescs.length; ++j) {
            this.deferredChildren[j] = this.argDescs[j].getDeferredJavaObject(i, b, j, this.writers);
        }
        if (!this.suppressEvaluateExceptions) {
            result = this.genericUDF.evaluate(this.deferredChildren);
        } else {
            try {
                result = this.genericUDF.evaluate(this.deferredChildren);
            }
            catch (HiveException e) {
                result = null;
            }
        }
        this.outputVectorAssignRow.assignRowColumn(b, i, 0, result);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.expr.getExprString();
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().build();
    }
}

