/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.facebook.presto.hive.$internal.com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.facebook.presto.hive.$internal.org.json.JSONObject;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.ExplainTask;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.DatePartitionedLogger;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.ProtoMessageWriter;
import org.apache.hadoop.hive.ql.hooks.proto.HiveHookEvents;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hive.common.util.ShutdownHookManager;

public class HiveProtoLoggingHook
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger(HiveProtoLoggingHook.class.getName());
    private static final Set<String> includedOperationSet = Arrays.stream(new HiveOperation[]{HiveOperation.LOAD, HiveOperation.EXPORT, HiveOperation.IMPORT, HiveOperation.CREATEDATABASE, HiveOperation.DROPDATABASE, HiveOperation.DROPTABLE, HiveOperation.MSCK, HiveOperation.ALTERTABLE_ADDCOLS, HiveOperation.ALTERTABLE_REPLACECOLS, HiveOperation.ALTERTABLE_RENAMECOL, HiveOperation.ALTERTABLE_RENAMEPART, HiveOperation.ALTERTABLE_UPDATEPARTSTATS, HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_RENAME, HiveOperation.ALTERTABLE_DROPPARTS, HiveOperation.ALTERTABLE_ADDPARTS, HiveOperation.ALTERTABLE_TOUCH, HiveOperation.ALTERTABLE_ARCHIVE, HiveOperation.ALTERTABLE_UNARCHIVE, HiveOperation.ALTERTABLE_PROPERTIES, HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER, HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES, HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ANALYZE_TABLE, HiveOperation.CACHE_METADATA, HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM, HiveOperation.CREATEFUNCTION, HiveOperation.DROPFUNCTION, HiveOperation.RELOADFUNCTION, HiveOperation.CREATEMACRO, HiveOperation.DROPMACRO, HiveOperation.CREATEVIEW, HiveOperation.DROPVIEW, HiveOperation.ALTERVIEW_PROPERTIES, HiveOperation.DROPVIEW_PROPERTIES, HiveOperation.LOCKTABLE, HiveOperation.UNLOCKTABLE, HiveOperation.CREATEROLE, HiveOperation.DROPROLE, HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT, HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION, HiveOperation.CREATETABLE, HiveOperation.TRUNCATETABLE, HiveOperation.CREATETABLE_AS_SELECT, HiveOperation.QUERY, HiveOperation.ALTERDATABASE, HiveOperation.ALTERDATABASE_OWNER, HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES, HiveOperation.ALTERTABLE_SKEWED, HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTABLE_PARTCOLTYPE, HiveOperation.ALTERTABLE_EXCHANGEPARTITION, HiveOperation.ALTERTABLE_DROPCONSTRAINT, HiveOperation.ALTERTABLE_ADDCONSTRAINT, HiveOperation.ALTERVIEW_RENAME, HiveOperation.ALTERVIEW_AS, HiveOperation.ALTERTABLE_COMPACT, HiveOperation.KILL_QUERY}).map(HiveOperation::getOperationName).collect(Collectors.toSet());
    private static final int VERSION = 1;
    public static final String HIVE_EVENTS_BASE_PATH = "hive.hook.proto.base-directory";
    public static final String HIVE_HOOK_PROTO_QUEUE_CAPACITY = "hive.hook.proto.queue.capacity";
    public static final int HIVE_HOOK_PROTO_QUEUE_CAPACITY_DEFAULT = 64;
    private static final int WAIT_TIME = 5;

    @Override
    public void run(HookContext hookContext) throws Exception {
        try {
            EventLogger logger = EventLogger.getInstance(hookContext.getConf());
            logger.handle(hookContext);
        }
        catch (Exception e) {
            LOG.error("Got exceptoin while processing event: ", e);
        }
    }

    static class EventLogger {
        private final Clock clock;
        private final String logFileName;
        private final DatePartitionedLogger<HiveHookEvents.HiveHookEventProto> logger;
        private final ExecutorService eventHandler;
        private final ExecutorService logWriter;
        private static volatile EventLogger instance;

        EventLogger(HiveConf conf, Clock clock) {
            this.clock = clock;
            this.logFileName = "hive_" + UUID.randomUUID().toString();
            String baseDir = conf.get(HiveProtoLoggingHook.HIVE_EVENTS_BASE_PATH);
            if (baseDir == null) {
                LOG.error("hive.hook.proto.base-directory is not set, logging disabled.");
            }
            DatePartitionedLogger<HiveHookEvents.HiveHookEventProto> tmpLogger = null;
            try {
                if (baseDir != null) {
                    tmpLogger = new DatePartitionedLogger<HiveHookEvents.HiveHookEventProto>(HiveHookEvents.HiveHookEventProto.PARSER, new Path(baseDir), conf, clock);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to intialize logger, logging disabled.", e);
            }
            this.logger = tmpLogger;
            if (this.logger == null) {
                this.eventHandler = null;
                this.logWriter = null;
                return;
            }
            int queueCapacity = conf.getInt(HiveProtoLoggingHook.HIVE_HOOK_PROTO_QUEUE_CAPACITY, 64);
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Hive Hook Proto Event Handler %d").build();
            this.eventHandler = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), threadFactory);
            threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Hive Hook Proto Log Writer %d").build();
            this.logWriter = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueCapacity), threadFactory);
        }

        void shutdown() {
            for (ExecutorService service : new ExecutorService[]{this.eventHandler, this.logWriter}) {
                if (service == null) continue;
                service.shutdown();
                try {
                    service.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.warn("Got interrupted exception while waiting for events to be flushed", e);
                }
            }
        }

        void handle(HookContext hookContext) {
            if (this.logger == null) {
                return;
            }
            try {
                this.eventHandler.execute(() -> this.generateEvent(hookContext));
            }
            catch (RejectedExecutionException e) {
                LOG.warn("Handler queue full ignoring event: " + (Object)((Object)hookContext.getHookType()));
            }
        }

        private void generateEvent(HookContext hookContext) {
            HiveHookEvents.HiveHookEventProto event;
            QueryPlan plan = hookContext.getQueryPlan();
            if (plan == null) {
                LOG.debug("Received null query plan.");
                return;
            }
            if (!includedOperationSet.contains(plan.getOperationName())) {
                LOG.debug("Not logging events of operation type : {}", (Object)plan.getOperationName());
                return;
            }
            switch (hookContext.getHookType()) {
                case PRE_EXEC_HOOK: {
                    event = this.getPreHookEvent(hookContext);
                    break;
                }
                case POST_EXEC_HOOK: {
                    event = this.getPostHookEvent(hookContext, true);
                    break;
                }
                case ON_FAILURE_HOOK: {
                    event = this.getPostHookEvent(hookContext, false);
                    break;
                }
                default: {
                    LOG.warn("Ignoring event of type: {}", (Object)hookContext.getHookType());
                    event = null;
                }
            }
            if (event != null) {
                try {
                    this.logWriter.execute(() -> this.writeEvent(event));
                }
                catch (RejectedExecutionException e) {
                    LOG.warn("Writer queue full ignoring event {} for query {}", (Object)hookContext.getHookType(), (Object)plan.getQueryId());
                }
            }
        }

        private void writeEvent(HiveHookEvents.HiveHookEventProto event) {
            try (ProtoMessageWriter<HiveHookEvents.HiveHookEventProto> writer = this.logger.getWriter(this.logFileName);){
                writer.writeProto(event);
            }
            catch (IOException e) {
                LOG.error("Error writing proto message for query {}, eventType: {}: ", event.getHiveQueryId(), event.getEventType(), e);
            }
        }

        private HiveHookEvents.HiveHookEventProto getPreHookEvent(HookContext hookContext) {
            QueryPlan plan = hookContext.getQueryPlan();
            LOG.info("Received pre-hook notification for: " + plan.getQueryId());
            HiveConf conf = new HiveConf(hookContext.getConf());
            List<ExecDriver> mrTasks = Utilities.getMRTasks(plan.getRootTasks());
            List<TezTask> tezTasks = Utilities.getTezTasks(plan.getRootTasks());
            ExecutionMode executionMode = this.getExecutionMode(plan, mrTasks, tezTasks);
            HiveHookEvents.HiveHookEventProto.Builder builder = HiveHookEvents.HiveHookEventProto.newBuilder();
            builder.setEventType(EventType.QUERY_SUBMITTED.name());
            builder.setTimestamp(plan.getQueryStartTime());
            builder.setHiveQueryId(plan.getQueryId());
            builder.setUser(this.getUser(hookContext));
            builder.setRequestUser(this.getRequestUser(hookContext));
            builder.setQueue(conf.get("mapreduce.job.queuename"));
            builder.setExecutionMode(executionMode.name());
            builder.addAllTablesRead(this.getTablesFromEntitySet(hookContext.getInputs()));
            builder.addAllTablesWritten(this.getTablesFromEntitySet(hookContext.getOutputs()));
            if (hookContext.getOperationId() != null) {
                builder.setOperationId(hookContext.getOperationId());
            }
            try {
                JSONObject queryObj = new JSONObject();
                queryObj.put("queryText", plan.getQueryStr());
                queryObj.put("queryPlan", this.getExplainPlan(plan, conf, hookContext));
                this.addMapEntry(builder, OtherInfoType.QUERY, queryObj.toString());
            }
            catch (Exception e) {
                LOG.error("Unexpected exception while serializing json.", e);
            }
            this.addMapEntry(builder, OtherInfoType.TEZ, Boolean.toString(tezTasks.size() > 0));
            this.addMapEntry(builder, OtherInfoType.MAPRED, Boolean.toString(mrTasks.size() > 0));
            this.addMapEntry(builder, OtherInfoType.SESSION_ID, hookContext.getSessionId());
            String logID = conf.getLogIdVar(hookContext.getSessionId());
            this.addMapEntry(builder, OtherInfoType.INVOKER_INFO, logID);
            this.addMapEntry(builder, OtherInfoType.THREAD_NAME, hookContext.getThreadId());
            this.addMapEntry(builder, OtherInfoType.VERSION, Integer.toString(1));
            this.addMapEntry(builder, OtherInfoType.CLIENT_IP_ADDRESS, hookContext.getIpAddress());
            String hiveInstanceAddress = hookContext.getHiveInstanceAddress();
            if (hiveInstanceAddress == null) {
                try {
                    hiveInstanceAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    LOG.error("Error tyring to get localhost address: ", e);
                }
            }
            this.addMapEntry(builder, OtherInfoType.HIVE_ADDRESS, hiveInstanceAddress);
            String hiveInstanceType = hookContext.isHiveServerQuery() ? "HS2" : "CLI";
            this.addMapEntry(builder, OtherInfoType.HIVE_INSTANCE_TYPE, hiveInstanceType);
            ApplicationId llapId = this.determineLlapId(conf, executionMode);
            if (llapId != null) {
                this.addMapEntry(builder, OtherInfoType.LLAP_APP_ID, llapId.toString());
            }
            conf.stripHiddenConfigurations(conf);
            JSONObject confObj = new JSONObject();
            Iterator iterator = conf.iterator();
            while (iterator.hasNext()) {
                Map.Entry setting = (Map.Entry)iterator.next();
                confObj.put((String)setting.getKey(), setting.getValue());
            }
            this.addMapEntry(builder, OtherInfoType.CONF, confObj.toString());
            return builder.build();
        }

        private HiveHookEvents.HiveHookEventProto getPostHookEvent(HookContext hookContext, boolean success) {
            QueryPlan plan = hookContext.getQueryPlan();
            LOG.info("Received post-hook notification for: " + plan.getQueryId());
            HiveHookEvents.HiveHookEventProto.Builder builder = HiveHookEvents.HiveHookEventProto.newBuilder();
            builder.setEventType(EventType.QUERY_COMPLETED.name());
            builder.setTimestamp(this.clock.getTime());
            builder.setHiveQueryId(plan.getQueryId());
            builder.setUser(this.getUser(hookContext));
            builder.setRequestUser(this.getRequestUser(hookContext));
            if (hookContext.getOperationId() != null) {
                builder.setOperationId(hookContext.getOperationId());
            }
            this.addMapEntry(builder, OtherInfoType.STATUS, Boolean.toString(success));
            JSONObject perfObj = new JSONObject(hookContext.getPerfLogger().getEndTimes());
            this.addMapEntry(builder, OtherInfoType.PERF, perfObj.toString());
            return builder.build();
        }

        private void addMapEntry(HiveHookEvents.HiveHookEventProto.Builder builder, OtherInfoType key, String value) {
            if (value != null) {
                builder.addOtherInfo(HiveHookEvents.MapFieldEntry.newBuilder().setKey(key.name()).setValue(value).build());
            }
        }

        private String getUser(HookContext hookContext) {
            return hookContext.getUgi().getShortUserName();
        }

        private String getRequestUser(HookContext hookContext) {
            String requestuser = hookContext.getUserName();
            if (requestuser == null) {
                requestuser = hookContext.getUgi().getUserName();
            }
            return requestuser;
        }

        private List<String> getTablesFromEntitySet(Set<? extends Entity> entities) {
            ArrayList<String> tableNames = new ArrayList<String>();
            for (Entity entity : entities) {
                if (entity.getType() != Entity.Type.TABLE) continue;
                tableNames.add(entity.getTable().getDbName() + "." + entity.getTable().getTableName());
            }
            return tableNames;
        }

        private ExecutionMode getExecutionMode(QueryPlan plan, List<ExecDriver> mrTasks, List<TezTask> tezTasks) {
            if (tezTasks.size() > 0) {
                for (TezTask tezTask : tezTasks) {
                    if (!((TezWork)tezTask.getWork()).getLlapMode()) continue;
                    return ExecutionMode.LLAP;
                }
                return ExecutionMode.TEZ;
            }
            if (mrTasks.size() > 0) {
                return ExecutionMode.MR;
            }
            if (Utilities.getSparkTasks(plan.getRootTasks()).size() > 0) {
                return ExecutionMode.SPARK;
            }
            return ExecutionMode.NONE;
        }

        private JSONObject getExplainPlan(QueryPlan plan, HiveConf conf, HookContext hookContext) throws Exception {
            ExplainConfiguration config = new ExplainConfiguration();
            config.setFormatted(true);
            ExplainWork work = new ExplainWork(null, null, plan.getRootTasks(), plan.getFetchTask(), null, config, null);
            ExplainTask explain = (ExplainTask)TaskFactory.get(work, conf);
            explain.initialize(hookContext.getQueryState(), plan, null, null);
            return explain.getJSONPlan(null, work);
        }

        private ApplicationId determineLlapId(HiveConf conf, ExecutionMode mode) {
            if (mode == ExecutionMode.LLAP) {
                String hosts = HiveConf.getVar(conf, HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
                if (hosts != null && !hosts.isEmpty()) {
                    try {
                        return LlapRegistryService.getClient((Configuration)conf).getApplicationId();
                    }
                    catch (IOException e) {
                        LOG.error("Error trying to get llap instance", e);
                    }
                } else {
                    LOG.info("Cannot determine LLAP instance on client - service hosts are not set");
                    return null;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static EventLogger getInstance(HiveConf conf) {
            if (instance != null) return instance;
            Class<EventLogger> clazz = EventLogger.class;
            synchronized (EventLogger.class) {
                if (instance != null) return instance;
                instance = new EventLogger(conf, (Clock)SystemClock.getInstance());
                ShutdownHookManager.addShutdownHook(instance::shutdown);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }
    }

    public static enum ExecutionMode {
        MR,
        TEZ,
        LLAP,
        SPARK,
        NONE;

    }

    public static enum OtherInfoType {
        QUERY,
        STATUS,
        TEZ,
        MAPRED,
        INVOKER_INFO,
        SESSION_ID,
        THREAD_NAME,
        VERSION,
        CLIENT_IP_ADDRESS,
        HIVE_ADDRESS,
        HIVE_INSTANCE_TYPE,
        CONF,
        PERF,
        LLAP_APP_ID;

    }

    public static enum EventType {
        QUERY_SUBMITTED,
        QUERY_COMPLETED;

    }
}

