/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import com.facebook.presto.hive.$internal.com.google.common.collect.Interner;
import com.facebook.presto.hive.$internal.com.google.common.collect.Interners;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.HiveStatsUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.DDLTask;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.MaterializedViewDesc;
import org.apache.hadoop.hive.ql.exec.StatsTask;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ColumnStatsAutoGatherContext;
import org.apache.hadoop.hive.ql.parse.GlobalLimitCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BasicStatsWork;
import org.apache.hadoop.hive.ql.plan.ColumnStatsDesc;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.IStatsGatherDesc;
import org.apache.hadoop.hive.ql.plan.LoadFileDesc;
import org.apache.hadoop.hive.ql.plan.LoadTableDesc;
import org.apache.hadoop.hive.ql.plan.MoveWork;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.StatsWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.serde2.DefaultFetchFormatter;
import org.apache.hadoop.hive.serde2.NoOpFetchFormatter;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.thrift.ThriftFormatter;
import org.apache.hadoop.hive.serde2.thrift.ThriftJDBCBinarySerDe;
import org.apache.hadoop.mapred.InputFormat;

public abstract class TaskCompiler {
    protected final Logger LOG = LoggerFactory.getLogger(TaskCompiler.class);
    protected Hive db;
    protected SessionState.LogHelper console;
    protected QueryState queryState;
    protected HiveConf conf;

    public void init(QueryState queryState, SessionState.LogHelper console, Hive db) {
        this.queryState = queryState;
        this.conf = queryState.getConf();
        this.db = db;
        this.console = console;
    }

    /*
     * WARNING - void declaration
     */
    public void compile(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks, HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs) throws SemanticException {
        StatsTask tsk;
        Context ctx = pCtx.getContext();
        GlobalLimitCtx globalLimitCtx = pCtx.getGlobalLimitCtx();
        ArrayList<Task<MoveWork>> mvTask = new ArrayList<Task<MoveWork>>();
        List<LoadTableDesc> loadTableWork = pCtx.getLoadTableWork();
        List<LoadFileDesc> loadFileWork = pCtx.getLoadFileWork();
        boolean isCStats = pCtx.getQueryProperties().isAnalyzeRewrite();
        int outerQueryLimit = pCtx.getQueryProperties().getOuterQueryLimit();
        if (pCtx.getFetchTask() != null) {
            if (pCtx.getFetchTask().getTblDesc() == null) {
                return;
            }
            ((FetchWork)pCtx.getFetchTask().getWork()).setHiveServerQuery(SessionState.get().isHiveServerQuery());
            TableDesc resultTab = pCtx.getFetchTask().getTblDesc();
            if (!resultTab.getSerdeClassName().equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName())) {
                if (SessionState.get().isHiveServerQuery()) {
                    this.conf.set("list.sink.output.formatter", ThriftFormatter.class.getName());
                } else {
                    String string = this.conf.get("list.sink.output.formatter");
                    if (string == null || string.isEmpty()) {
                        this.conf.set("list.sink.output.formatter", DefaultFetchFormatter.class.getName());
                    }
                }
            }
            return;
        }
        this.optimizeOperatorPlan(pCtx, inputs, outputs);
        if (pCtx.getQueryProperties().isQuery() && !isCStats) {
            void var15_39;
            if (!loadTableWork.isEmpty() || loadFileWork.size() != 1) {
                throw new SemanticException(ErrorMsg.INVALID_LOAD_TABLE_FILE_WORK.getMsg());
            }
            LoadFileDesc loadFileDesc = loadFileWork.get(0);
            String string = loadFileDesc.getColumns();
            String colTypes = loadFileDesc.getColumnTypes();
            TableDesc tableDesc = pCtx.getFetchTableDesc();
            if (tableDesc == null) {
                String resFileFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
                if (SessionState.get().getIsUsingThriftJDBCBinarySerDe() && resFileFormat.equalsIgnoreCase("SequenceFile")) {
                    TableDesc tableDesc2 = PlanUtils.getDefaultQueryOutputTableDesc(string, colTypes, resFileFormat, ThriftJDBCBinarySerDe.class);
                    this.conf.set("list.sink.output.formatter", NoOpFetchFormatter.class.getName());
                } else {
                    TableDesc tableDesc3 = PlanUtils.getDefaultQueryOutputTableDesc(string, colTypes, resFileFormat, LazySimpleSerDe.class);
                }
            } else if (tableDesc.getProperties().getProperty("serialization.lib").equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName())) {
                this.conf.set("list.sink.output.formatter", NoOpFetchFormatter.class.getName());
            }
            FetchWork fetch = new FetchWork(loadFileDesc.getSourcePath(), (TableDesc)var15_39, outerQueryLimit);
            boolean isHiveServerQuery = SessionState.get().isHiveServerQuery();
            fetch.setHiveServerQuery(isHiveServerQuery);
            fetch.setSource(pCtx.getFetchSource());
            fetch.setSink(pCtx.getFetchSink());
            if (isHiveServerQuery && null != var15_39 && var15_39.getSerdeClassName().equalsIgnoreCase(ThriftJDBCBinarySerDe.class.getName()) && HiveConf.getBoolVar(this.conf, HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS)) {
                fetch.setIsUsingThriftJDBCBinarySerDe(true);
            } else {
                fetch.setIsUsingThriftJDBCBinarySerDe(false);
            }
            pCtx.setFetchTask((FetchTask)TaskFactory.get(fetch));
            int fetchLimit = HiveConf.getIntVar(this.conf, HiveConf.ConfVars.HIVELIMITOPTMAXFETCH);
            if (globalLimitCtx.isEnable() && globalLimitCtx.getGlobalLimit() > fetchLimit) {
                this.LOG.info("For FetchTask, LIMIT " + globalLimitCtx.getGlobalLimit() + " > " + fetchLimit + ". Doesn't qualify limit optimization.");
                globalLimitCtx.disableOpt();
            }
            if (outerQueryLimit == 0) {
                this.LOG.info("Limit 0. No query execution needed.");
                return;
            }
        } else if (!isCStats) {
            for (LoadTableDesc loadTableDesc : loadTableWork) {
                tsk = TaskFactory.get(new MoveWork(null, null, loadTableDesc, null, false));
                mvTask.add(tsk);
            }
            boolean oneLoadFileForCtas = true;
            for (LoadFileDesc lfd : loadFileWork) {
                if (pCtx.getQueryProperties().isCTAS() || pCtx.getQueryProperties().isMaterializedView()) {
                    if (!oneLoadFileForCtas) {
                        throw new SemanticException("One query is not expected to contain multiple CTAS loads statements");
                    }
                    this.setLoadFileLocation(pCtx, lfd);
                    oneLoadFileForCtas = false;
                }
                mvTask.add(TaskFactory.get(new MoveWork(null, null, null, lfd, false)));
            }
        }
        this.generateTaskTree(rootTasks, pCtx, mvTask, inputs, outputs);
        for (Task<? extends Serializable> task : rootTasks) {
            GenMapRedUtils.setKeyAndValueDescForTaskTree(task);
        }
        for (Task<? extends Serializable> task : rootTasks) {
            this.setInputFormat(task);
        }
        this.optimizeTaskPlan(rootTasks, pCtx, ctx);
        if (isCStats || !pCtx.getColumnStatsAutoGatherContexts().isEmpty()) {
            LinkedHashMap<String, StatsTask> map = new LinkedHashMap<String, StatsTask>();
            if (isCStats) {
                if (rootTasks == null || rootTasks.size() != 1 || pCtx.getTopOps() == null || pCtx.getTopOps().size() != 1) {
                    throw new SemanticException("Can not find correct root task!");
                }
                try {
                    Task<? extends Serializable> task = rootTasks.iterator().next();
                    tsk = (StatsTask)this.genTableStats(pCtx, pCtx.getTopOps().values().iterator().next(), task, outputs);
                    task.addDependentTask(tsk);
                    map.put(this.extractTableFullName(tsk), tsk);
                }
                catch (HiveException hiveException) {
                    throw new SemanticException(hiveException);
                }
                this.genColumnStatsTask(pCtx.getAnalyzeRewrite(), loadFileWork, map, outerQueryLimit, 0);
            } else {
                LinkedHashSet<Task<? extends Serializable>> linkedHashSet = new LinkedHashSet<Task<? extends Serializable>>();
                this.getLeafTasks(rootTasks, linkedHashSet);
                ArrayList<Task> nonStatsLeafTasks = new ArrayList<Task>();
                for (Task task : linkedHashSet) {
                    if (task instanceof StatsTask) {
                        map.put(this.extractTableFullName((StatsTask)task), (StatsTask)task);
                        continue;
                    }
                    nonStatsLeafTasks.add(task);
                }
                for (Task task : nonStatsLeafTasks) {
                    for (Task cStatsTask : map.values()) {
                        task.addDependentTask(cStatsTask);
                    }
                }
                for (ColumnStatsAutoGatherContext columnStatsAutoGatherContext : pCtx.getColumnStatsAutoGatherContexts()) {
                    int numBitVector;
                    if (!columnStatsAutoGatherContext.isInsertInto()) {
                        this.genColumnStatsTask(columnStatsAutoGatherContext.getAnalyzeRewrite(), columnStatsAutoGatherContext.getLoadFileWork(), map, outerQueryLimit, 0);
                        continue;
                    }
                    try {
                        numBitVector = HiveStatsUtils.getNumBitVectorsForNDVEstimation(this.conf);
                    }
                    catch (Exception e) {
                        throw new SemanticException(e.getMessage());
                    }
                    this.genColumnStatsTask(columnStatsAutoGatherContext.getAnalyzeRewrite(), columnStatsAutoGatherContext.getLoadFileWork(), map, outerQueryLimit, numBitVector);
                }
            }
        }
        this.decideExecMode(rootTasks, ctx, globalLimitCtx);
        if (pCtx.getQueryProperties().isCTAS() && !pCtx.getCreateTable().isMaterialization()) {
            CreateTableDesc crtTblDesc = pCtx.getCreateTable();
            crtTblDesc.validate(this.conf);
            Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, crtTblDesc));
            this.patchUpAfterCTASorMaterializedView(rootTasks, outputs, task);
        } else if (pCtx.getQueryProperties().isMaterializedView()) {
            CreateViewDesc viewDesc = pCtx.getCreateViewDesc();
            Task<DDLWork> task = TaskFactory.get(new DDLWork(inputs, outputs, viewDesc));
            this.patchUpAfterCTASorMaterializedView(rootTasks, outputs, task);
        } else if (pCtx.getMaterializedViewUpdateDesc() != null) {
            MaterializedViewDesc materializedViewDesc = pCtx.getMaterializedViewUpdateDesc();
            LinkedHashSet<Task<? extends Serializable>> linkedHashSet = new LinkedHashSet<Task<? extends Serializable>>();
            this.getLeafTasks(rootTasks, linkedHashSet);
            Task<MaterializedViewDesc> materializedViewTask = TaskFactory.get(materializedViewDesc, this.conf);
            for (Task task : linkedHashSet) {
                task.addDependentTask(materializedViewTask);
            }
        }
        if (globalLimitCtx.isEnable() && pCtx.getFetchTask() != null) {
            this.LOG.info("set least row check for FetchTask: " + globalLimitCtx.getGlobalLimit());
            ((FetchWork)pCtx.getFetchTask().getWork()).setLeastNumRows(globalLimitCtx.getGlobalLimit());
        }
        if (globalLimitCtx.isEnable() && globalLimitCtx.getLastReduceLimitDesc() != null) {
            this.LOG.info("set least row check for LimitDesc: " + globalLimitCtx.getGlobalLimit());
            globalLimitCtx.getLastReduceLimitDesc().setLeastRows(globalLimitCtx.getGlobalLimit());
        }
        Interner<TableDesc> interner = Interners.newStrongInterner();
        for (Task<? extends Serializable> rootTask : rootTasks) {
            GenMapRedUtils.internTableDesc(rootTask, interner);
            GenMapRedUtils.deriveFinalExplainAttributes(rootTask, pCtx.getConf());
        }
    }

    private String extractTableFullName(StatsTask tsk) throws SemanticException {
        return ((StatsWork)tsk.getWork()).getFullTableName();
    }

    private Task<?> genTableStats(ParseContext parseContext, TableScanOperator tableScan, Task currentTask, HashSet<WriteEntity> outputs) throws HiveException {
        Class<? extends InputFormat> inputFormat = ((TableScanDesc)tableScan.getConf()).getTableMetadata().getInputFormatClass();
        Table table = ((TableScanDesc)tableScan.getConf()).getTableMetadata();
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        if (table.isPartitioned()) {
            partitions.addAll(parseContext.getPrunedPartitions(tableScan).getPartitions());
            for (Partition partn : partitions) {
                this.LOG.trace("adding part: " + partn);
                outputs.add(new WriteEntity(partn, WriteEntity.WriteType.DDL_NO_LOCK));
            }
        }
        BaseSemanticAnalyzer.TableSpec tableSpec = new BaseSemanticAnalyzer.TableSpec(table, partitions);
        ((TableScanDesc)tableScan.getConf()).getTableMetadata().setTableSpec(tableSpec);
        if (inputFormat.equals(OrcInputFormat.class)) {
            StatsWork columnStatsWork = new StatsWork(table, parseContext.getConf());
            columnStatsWork.setFooterScan();
            if (partitions.size() > 0) {
                columnStatsWork.addInputPartitions(parseContext.getPrunedPartitions(tableScan).getPartitions());
            }
            return TaskFactory.get(columnStatsWork);
        }
        BasicStatsWork statsWork = new BasicStatsWork(((TableScanDesc)tableScan.getConf()).getTableMetadata().getTableSpec());
        statsWork.setIsExplicitAnalyze(true);
        StatsWork columnStatsWork = new StatsWork(table, statsWork, parseContext.getConf());
        columnStatsWork.collectStatsFromAggregator((IStatsGatherDesc)tableScan.getConf());
        columnStatsWork.setSourceTask(currentTask);
        return TaskFactory.get(columnStatsWork);
    }

    private void setLoadFileLocation(ParseContext pCtx, LoadFileDesc lfd) throws SemanticException {
        Path location;
        Long txnIdForCtas = null;
        int stmtId = 0;
        FileSinkDesc dataSinkForCtas = null;
        String loc = null;
        if (pCtx.getQueryProperties().isCTAS()) {
            CreateTableDesc ctd = pCtx.getCreateTable();
            dataSinkForCtas = ctd.getAndUnsetWriter();
            txnIdForCtas = ctd.getInitialMmWriteId();
            loc = ctd.getLocation();
        } else {
            loc = pCtx.getCreateViewDesc().getLocation();
        }
        Path path = location = loc == null ? this.getDefaultCtasLocation(pCtx) : new Path(loc);
        if (txnIdForCtas != null) {
            dataSinkForCtas.setDirName(location);
            location = new Path(location, AcidUtils.deltaSubdir(txnIdForCtas, txnIdForCtas, stmtId));
            lfd.setSourcePath(location);
            if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
                Utilities.FILE_OP_LOGGER.trace("Setting MM CTAS to " + location);
            }
        }
        if (Utilities.FILE_OP_LOGGER.isTraceEnabled()) {
            Utilities.FILE_OP_LOGGER.trace("Location for LFD is being set to " + location + "; moving from " + lfd.getSourcePath());
        }
        lfd.setTargetDir(location);
    }

    private Path getDefaultCtasLocation(ParseContext pCtx) throws SemanticException {
        try {
            String protoName = null;
            if (pCtx.getQueryProperties().isCTAS()) {
                protoName = pCtx.getCreateTable().getTableName();
            } else if (pCtx.getQueryProperties().isMaterializedView()) {
                protoName = pCtx.getCreateViewDesc().getViewName();
            }
            String[] names = Utilities.getDbTableName(protoName);
            if (!this.db.databaseExists(names[0])) {
                throw new SemanticException("ERROR: The database " + names[0] + " does not exist.");
            }
            Warehouse wh = new Warehouse(this.conf);
            return wh.getDefaultTablePath(this.db.getDatabase(names[0]), names[1]);
        }
        catch (HiveException e) {
            throw new SemanticException(e);
        }
        catch (MetaException e) {
            throw new SemanticException((Throwable)((Object)e));
        }
    }

    private void patchUpAfterCTASorMaterializedView(List<Task<? extends Serializable>> rootTasks, HashSet<WriteEntity> outputs, Task<? extends Serializable> createTask) {
        Iterator<WriteEntity> outIter = outputs.iterator();
        block3: while (outIter.hasNext()) {
            switch (outIter.next().getType()) {
                case DFS_DIR: 
                case LOCAL_DIR: {
                    outIter.remove();
                    continue block3;
                }
            }
        }
        LinkedHashSet<Task<? extends Serializable>> leaves = new LinkedHashSet<Task<? extends Serializable>>();
        this.getLeafTasks(rootTasks, leaves);
        assert (leaves.size() > 0);
        Task targetTask = createTask;
        for (Task task : leaves) {
            if (task instanceof StatsTask) {
                for (Task<Serializable> parentOfStatsTask : task.getParentTasks()) {
                    parentOfStatsTask.addDependentTask(createTask);
                }
                for (Task<Serializable> parentOfCrtTblTask : createTask.getParentTasks()) {
                    parentOfCrtTblTask.removeDependentTask(task);
                }
                createTask.addDependentTask(task);
                targetTask = task;
                continue;
            }
            task.addDependentTask(createTask);
        }
        if (createTask instanceof DDLTask) {
            DDLTask ddlTask = (DDLTask)createTask;
            DDLWork dDLWork = (DDLWork)ddlTask.getWork();
            String tableName = null;
            boolean retrieveAndInclude = false;
            boolean disableRewrite = false;
            if (dDLWork.getCreateViewDesc() != null && dDLWork.getCreateViewDesc().isMaterialized()) {
                tableName = dDLWork.getCreateViewDesc().getViewName();
                retrieveAndInclude = dDLWork.getCreateViewDesc().isRewriteEnabled();
            } else if (dDLWork.getAlterMaterializedViewDesc() != null) {
                tableName = dDLWork.getAlterMaterializedViewDesc().getMaterializedViewName();
                if (dDLWork.getAlterMaterializedViewDesc().isRewriteEnable()) {
                    retrieveAndInclude = true;
                } else {
                    disableRewrite = true;
                }
            } else {
                return;
            }
            targetTask.addDependentTask(TaskFactory.get(new MaterializedViewDesc(tableName, retrieveAndInclude, disableRewrite, false), this.conf));
        }
    }

    protected void genColumnStatsTask(BaseSemanticAnalyzer.AnalyzeRewriteContext analyzeRewrite, List<LoadFileDesc> loadFileWork, Map<String, StatsTask> map, int outerQueryLimit, int numBitVector) throws SemanticException {
        TableDesc resultTab;
        String tableName = analyzeRewrite.getTableName();
        List<String> colName = analyzeRewrite.getColName();
        List<String> colType = analyzeRewrite.getColType();
        boolean isTblLevel = analyzeRewrite.isTblLvl();
        String cols = loadFileWork.get(0).getColumns();
        String colTypes = loadFileWork.get(0).getColumnTypes();
        if (SessionState.get().isHiveServerQuery() && this.conf.getBoolVar(HiveConf.ConfVars.HIVE_SERVER2_THRIFT_RESULTSET_SERIALIZE_IN_TASKS)) {
            String resFileFormat = "SequenceFile";
            resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, resFileFormat, ThriftJDBCBinarySerDe.class);
        } else {
            String resFileFormat = HiveConf.getVar(this.conf, HiveConf.ConfVars.HIVEQUERYRESULTFILEFORMAT);
            resultTab = PlanUtils.getDefaultQueryOutputTableDesc(cols, colTypes, resFileFormat, LazySimpleSerDe.class);
        }
        FetchWork fetch = new FetchWork(loadFileWork.get(0).getSourcePath(), resultTab, outerQueryLimit);
        ColumnStatsDesc cStatsDesc = new ColumnStatsDesc(tableName, colName, colType, isTblLevel, numBitVector, fetch);
        StatsTask columnStatsTask = map.get(tableName);
        if (columnStatsTask == null) {
            throw new SemanticException("Can not find " + tableName + " in genColumnStatsTask");
        }
        ((StatsWork)columnStatsTask.getWork()).setColStats(cStatsDesc);
    }

    private void getLeafTasks(List<Task<? extends Serializable>> rootTasks, Set<Task<? extends Serializable>> leaves) {
        for (Task<? extends Serializable> root : rootTasks) {
            this.getLeafTasks(root, leaves);
        }
    }

    private void getLeafTasks(Task<? extends Serializable> task, Set<Task<? extends Serializable>> leaves) {
        if (task.getDependentTasks() == null) {
            if (!leaves.contains(task)) {
                leaves.add(task);
            }
        } else {
            this.getLeafTasks(task.getDependentTasks(), leaves);
        }
    }

    protected abstract void decideExecMode(List<Task<? extends Serializable>> var1, Context var2, GlobalLimitCtx var3) throws SemanticException;

    protected void optimizeOperatorPlan(ParseContext pCtxSet, Set<ReadEntity> inputs, Set<WriteEntity> outputs) throws SemanticException {
    }

    protected abstract void optimizeTaskPlan(List<Task<? extends Serializable>> var1, ParseContext var2, Context var3) throws SemanticException;

    protected abstract void setInputFormat(Task<? extends Serializable> var1);

    protected abstract void generateTaskTree(List<Task<? extends Serializable>> var1, ParseContext var2, List<Task<MoveWork>> var3, Set<ReadEntity> var4, Set<WriteEntity> var5) throws SemanticException;

    public ParseContext getParseContext(ParseContext pCtx, List<Task<? extends Serializable>> rootTasks) {
        ParseContext clone = new ParseContext(this.queryState, pCtx.getOpToPartPruner(), pCtx.getOpToPartList(), pCtx.getTopOps(), pCtx.getJoinOps(), pCtx.getSmbMapJoinOps(), pCtx.getLoadTableWork(), pCtx.getLoadFileWork(), pCtx.getColumnStatsAutoGatherContexts(), pCtx.getContext(), pCtx.getIdToTableNameMap(), pCtx.getDestTableId(), pCtx.getUCtx(), pCtx.getListMapJoinOpsNoReducer(), pCtx.getPrunedPartitions(), pCtx.getTabNameToTabObject(), pCtx.getOpToSamplePruner(), pCtx.getGlobalLimitCtx(), pCtx.getNameToSplitSample(), pCtx.getSemanticInputs(), rootTasks, pCtx.getOpToPartToSkewedPruner(), pCtx.getViewAliasToInput(), pCtx.getReduceSinkOperatorsAddedByEnforceBucketingSorting(), pCtx.getAnalyzeRewrite(), pCtx.getCreateTable(), pCtx.getCreateViewDesc(), pCtx.getMaterializedViewUpdateDesc(), pCtx.getQueryProperties(), pCtx.getViewProjectToTableSchema(), pCtx.getAcidSinks());
        clone.setFetchTask(pCtx.getFetchTask());
        clone.setLineageInfo(pCtx.getLineageInfo());
        clone.setMapJoinOps(pCtx.getMapJoinOps());
        clone.setRsToRuntimeValuesInfoMap(pCtx.getRsToRuntimeValuesInfoMap());
        clone.setRsToSemiJoinBranchInfo(pCtx.getRsToSemiJoinBranchInfo());
        clone.setColExprToGBMap(pCtx.getColExprToGBMap());
        clone.setSemiJoinHints(pCtx.getSemiJoinHints());
        return clone;
    }
}

