/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.binarysortable.fast;

import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveIntervalDayTime;
import org.apache.hadoop.hive.common.type.HiveIntervalYearMonth;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.fast.SerializeWrite;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;

public final class BinarySortableSerializeWrite
implements SerializeWrite {
    public static final Logger LOG = LoggerFactory.getLogger(BinarySortableSerializeWrite.class.getName());
    private ByteStream.Output output;
    private boolean[] columnSortOrderIsDesc;
    private byte[] columnNullMarker;
    private byte[] columnNotNullMarker;
    private int index;
    private int level;
    private TimestampWritable tempTimestampWritable = new TimestampWritable();
    private HiveDecimalWritable hiveDecimalWritable;
    private byte[] decimalBytesScratch;

    public BinarySortableSerializeWrite(boolean[] columnSortOrderIsDesc, byte[] columnNullMarker, byte[] columnNotNullMarker) {
        this();
        this.columnSortOrderIsDesc = columnSortOrderIsDesc;
        this.columnNullMarker = columnNullMarker;
        this.columnNotNullMarker = columnNotNullMarker;
    }

    public BinarySortableSerializeWrite(int fieldCount) {
        this();
        this.columnSortOrderIsDesc = new boolean[fieldCount];
        Arrays.fill(this.columnSortOrderIsDesc, false);
        this.columnNullMarker = new byte[fieldCount];
        Arrays.fill(this.columnNullMarker, (byte)0);
        this.columnNotNullMarker = new byte[fieldCount];
        Arrays.fill(this.columnNotNullMarker, (byte)1);
    }

    private BinarySortableSerializeWrite() {
    }

    @Override
    public void set(ByteStream.Output output) {
        this.output = output;
        this.output.reset();
        this.index = -1;
        this.level = 0;
    }

    @Override
    public void setAppend(ByteStream.Output output) {
        this.output = output;
        this.index = -1;
        this.level = 0;
    }

    @Override
    public void reset() {
        this.output.reset();
        this.index = -1;
        this.level = 0;
    }

    @Override
    public void writeNull() throws IOException {
        if (this.level == 0) {
            ++this.index;
        }
        BinarySortableSerDe.writeByte(this.output, this.columnNullMarker[this.index], this.columnSortOrderIsDesc[this.index]);
    }

    private void beginElement() {
        if (this.level == 0) {
            ++this.index;
        }
        BinarySortableSerDe.writeByte(this.output, this.columnNotNullMarker[this.index], this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.beginElement();
        BinarySortableSerDe.writeByte(this.output, (byte)(v ? 2 : 1), this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeByte(byte v) throws IOException {
        this.beginElement();
        BinarySortableSerDe.writeByte(this.output, (byte)(v ^ 0x80), this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeShort(short v) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeShort(this.output, v, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeInt(this.output, v, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeLong(this.output, v, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeFloat(float vf) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeFloat(this.output, vf, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeDouble(double vd) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeDouble(this.output, vd, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeString(byte[] v) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeBytes(this.output, v, 0, v.length, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeString(byte[] v, int start, int length) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeBytes(this.output, v, start, length, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeHiveChar(HiveChar hiveChar) throws IOException {
        String string = hiveChar.getStrippedValue();
        byte[] bytes = string.getBytes();
        this.writeString(bytes);
    }

    @Override
    public void writeHiveVarchar(HiveVarchar hiveVarchar) throws IOException {
        String string = hiveVarchar.getValue();
        byte[] bytes = string.getBytes();
        this.writeString(bytes);
    }

    @Override
    public void writeBinary(byte[] v) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeBytes(this.output, v, 0, v.length, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeBinary(byte[] v, int start, int length) {
        this.beginElement();
        BinarySortableSerDe.serializeBytes(this.output, v, start, length, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeDate(Date date) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeInt(this.output, DateWritable.dateToDays(date), this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeDate(int dateAsDays) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeInt(this.output, dateAsDays, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeTimestamp(Timestamp vt) throws IOException {
        this.beginElement();
        this.tempTimestampWritable.set(vt);
        BinarySortableSerDe.serializeTimestampWritable(this.output, this.tempTimestampWritable, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeHiveIntervalYearMonth(HiveIntervalYearMonth viyt) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeHiveIntervalYearMonth(this.output, viyt, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeHiveIntervalYearMonth(int totalMonths) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeInt(this.output, totalMonths, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeHiveIntervalDayTime(HiveIntervalDayTime vidt) throws IOException {
        this.beginElement();
        BinarySortableSerDe.serializeHiveIntervalDayTime(this.output, vidt, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void writeDecimal64(long decimal64Long, int scale) throws IOException {
        if (this.hiveDecimalWritable == null) {
            this.hiveDecimalWritable = new HiveDecimalWritable();
        }
        this.hiveDecimalWritable.deserialize64(decimal64Long, scale);
        this.writeHiveDecimal(this.hiveDecimalWritable, scale);
    }

    @Override
    public void writeHiveDecimal(HiveDecimal dec, int scale) throws IOException {
        this.beginElement();
        if (this.decimalBytesScratch == null) {
            this.decimalBytesScratch = new byte[79];
        }
        BinarySortableSerDe.serializeHiveDecimal(this.output, dec, this.columnSortOrderIsDesc[this.index], this.decimalBytesScratch);
    }

    @Override
    public void writeHiveDecimal(HiveDecimalWritable decWritable, int scale) throws IOException {
        this.beginElement();
        if (this.decimalBytesScratch == null) {
            this.decimalBytesScratch = new byte[79];
        }
        BinarySortableSerDe.serializeHiveDecimal(this.output, decWritable, this.columnSortOrderIsDesc[this.index], this.decimalBytesScratch);
    }

    @Override
    public void beginList(List list) {
        this.beginElement();
        ++this.level;
        if (!list.isEmpty()) {
            BinarySortableSerDe.writeByte(this.output, (byte)1, this.columnSortOrderIsDesc[this.index]);
        }
    }

    @Override
    public void separateList() {
        BinarySortableSerDe.writeByte(this.output, (byte)1, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void finishList() {
        --this.level;
        BinarySortableSerDe.writeByte(this.output, (byte)0, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void beginMap(Map<?, ?> map) {
        this.beginElement();
        ++this.level;
        if (!map.isEmpty()) {
            BinarySortableSerDe.writeByte(this.output, (byte)1, this.columnSortOrderIsDesc[this.index]);
        }
    }

    @Override
    public void separateKey() {
    }

    @Override
    public void separateKeyValuePair() {
        BinarySortableSerDe.writeByte(this.output, (byte)1, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void finishMap() {
        --this.level;
        BinarySortableSerDe.writeByte(this.output, (byte)0, this.columnSortOrderIsDesc[this.index]);
    }

    @Override
    public void beginStruct(List fieldValues) {
        this.beginElement();
        ++this.level;
    }

    @Override
    public void separateStruct() {
    }

    @Override
    public void finishStruct() {
        --this.level;
    }

    @Override
    public void beginUnion(int tag) throws IOException {
        this.beginElement();
        BinarySortableSerDe.writeByte(this.output, (byte)tag, this.columnSortOrderIsDesc[this.index]);
        ++this.level;
    }

    @Override
    public void finishUnion() {
        --this.level;
    }
}

