/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.hcatalog.cli.SemanticAnalysis;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.HiveSemanticAnalyzerHookContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateDatabaseDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;
import org.apache.hive.hcatalog.cli.SemanticAnalysis.HCatSemanticAnalyzerBase;

final class CreateDatabaseHook
extends HCatSemanticAnalyzerBase {
    String databaseName;

    CreateDatabaseHook() {
    }

    @Override
    public ASTNode preAnalyze(HiveSemanticAnalyzerHookContext context, ASTNode ast) throws SemanticException {
        Hive db;
        try {
            db = context.getHive();
        }
        catch (HiveException e) {
            throw new SemanticException("Couldn't get Hive DB instance in semantic analysis phase.", e);
        }
        int numCh = ast.getChildCount();
        this.databaseName = BaseSemanticAnalyzer.getUnescapedName((ASTNode)ast.getChild(0));
        block7: for (int num = 1; num < numCh; ++num) {
            ASTNode child = (ASTNode)ast.getChild(num);
            switch (child.getToken().getType()) {
                case 859: {
                    try {
                        List<String> dbs = db.getDatabasesByPattern(this.databaseName);
                        if (dbs == null || dbs.size() <= 0) continue block7;
                        return ast;
                    }
                    catch (HiveException e) {
                        throw new SemanticException(e);
                    }
                }
            }
        }
        return ast;
    }

    @Override
    public void postAnalyze(HiveSemanticAnalyzerHookContext context, List<Task<? extends Serializable>> rootTasks) throws SemanticException {
        context.getConf().set("hcat.create.db.name", this.databaseName);
        super.postAnalyze(context, rootTasks);
    }

    @Override
    protected void authorizeDDLWork(HiveSemanticAnalyzerHookContext context, Hive hive, DDLWork work) throws HiveException {
        CreateDatabaseDesc createDb = work.getCreateDatabaseDesc();
        if (createDb != null) {
            Database db = new Database(createDb.getName(), createDb.getComment(), createDb.getLocationUri(), createDb.getDatabaseProperties());
            this.authorize(db, Privilege.CREATE);
        }
    }
}

