/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.internal.builtin;

import com.facebook.drift.codec.ThriftCodec;
import com.facebook.drift.codec.internal.coercion.FromThrift;
import com.facebook.drift.codec.internal.coercion.ToThrift;
import com.facebook.drift.codec.metadata.ThriftCatalog;
import com.facebook.drift.codec.metadata.ThriftType;
import com.facebook.drift.protocol.TProtocolReader;
import com.facebook.drift.protocol.TProtocolWriter;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Objects;

public class UriThriftCodec
implements ThriftCodec<URI> {
    public UriThriftCodec(ThriftCatalog thriftCatalog) {
        Objects.requireNonNull(thriftCatalog, "thriftCatalog is null");
        thriftCatalog.addDefaultCoercions(this.getClass());
    }

    @Override
    public ThriftType getType() {
        return new ThriftType(ThriftType.STRING, (Type)((Object)URI.class));
    }

    @Override
    public URI read(TProtocolReader protocol) throws Exception {
        Objects.requireNonNull(protocol, "protocol is null");
        return URI.create(protocol.readString());
    }

    @Override
    public void write(URI value, TProtocolWriter protocol) throws Exception {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(protocol, "protocol is null");
        protocol.writeString(value.toString());
    }

    @FromThrift
    public static URI stringToUri(String uri) {
        return URI.create(uri);
    }

    @ToThrift
    public static String uriToString(URI uri) {
        return uri.toString();
    }
}

