/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.Injection;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.google.common.base.MoreObjects;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

class FieldInjection
extends Injection {
    private final Type thriftStructType;
    private final Field field;

    FieldInjection(Type thriftStructType, Field field, ThriftField annotation, FieldKind fieldKind) {
        super(annotation, fieldKind);
        this.thriftStructType = thriftStructType;
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    @Override
    public String extractName() {
        return this.field.getName();
    }

    @Override
    public Type getJavaType() {
        return ReflectionHelper.resolveFieldType(this.thriftStructType, this.field.getGenericType());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).toString();
    }
}

