/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.drift.codec.metadata;

import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.codec.metadata.Extractor;
import com.facebook.drift.codec.metadata.FieldKind;
import com.facebook.drift.codec.metadata.ReflectionHelper;
import com.google.common.base.MoreObjects;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

class MethodExtractor
extends Extractor {
    private final Type thriftStructType;
    private final Method method;

    public MethodExtractor(Type thriftStructType, Method method, ThriftField annotation, FieldKind fieldKind) {
        super(annotation, fieldKind);
        this.thriftStructType = thriftStructType;
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public String extractName() {
        return ReflectionHelper.extractFieldName(this.method.getName());
    }

    @Override
    public Type getJavaType() {
        return ReflectionHelper.resolveFieldType(this.thriftStructType, this.method.getGenericReturnType());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("method", (Object)this.method).toString();
    }
}

