/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc;

import io.airlift.units.DataSize;
import java.util.Objects;

public class OrcReaderOptions {
    private final DataSize maxMergeDistance;
    private final DataSize tinyStripeThreshold;
    private final DataSize maxBlockSize;
    private final boolean zstdJniDecompressionEnabled;
    private final boolean mapNullKeysEnabled;
    private final boolean enableTimestampMicroPrecision;

    public OrcReaderOptions(DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, boolean zstdJniDecompressionEnabled) {
        this(maxMergeDistance, tinyStripeThreshold, maxBlockSize, zstdJniDecompressionEnabled, false, false);
    }

    public OrcReaderOptions(DataSize maxMergeDistance, DataSize tinyStripeThreshold, DataSize maxBlockSize, boolean zstdJniDecompressionEnabled, boolean mapNullKeysEnabled, boolean enableTimestampMicroPrecision) {
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxBlockSize = Objects.requireNonNull(maxBlockSize, "maxBlockSize is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.zstdJniDecompressionEnabled = zstdJniDecompressionEnabled;
        this.mapNullKeysEnabled = mapNullKeysEnabled;
        this.enableTimestampMicroPrecision = enableTimestampMicroPrecision;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxBlockSize() {
        return this.maxBlockSize;
    }

    public boolean isOrcZstdJniDecompressionEnabled() {
        return this.zstdJniDecompressionEnabled;
    }

    public DataSize getTinyStripeThreshold() {
        return this.tinyStripeThreshold;
    }

    public boolean mapNullKeysEnabled() {
        return this.mapNullKeysEnabled;
    }

    public boolean enableTimestampMicroPrecision() {
        return this.enableTimestampMicroPrecision;
    }
}

