/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.metadata;

import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.ClassLayout;

public class RowGroupIndex {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(RowGroupIndex.class).instanceSize();
    private static final int INTEGER_INSTANCE_SIZE = ClassLayout.parseClass(Integer.class).instanceSize();
    private final List<Integer> positions;
    private final ColumnStatistics statistics;

    public RowGroupIndex(List<Integer> positions, ColumnStatistics statistics) {
        this.positions = ImmutableList.copyOf((Collection)Objects.requireNonNull(positions, "positions is null"));
        this.statistics = Objects.requireNonNull(statistics, "statistics is null");
    }

    public List<Integer> getPositions() {
        return this.positions;
    }

    public ColumnStatistics getColumnStatistics() {
        return this.statistics;
    }

    public long getRetainedSizeInBytes() {
        return (long)(INSTANCE_SIZE + this.positions.size() * INTEGER_INSTANCE_SIZE) + this.statistics.getRetainedSizeInBytes();
    }
}

