/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.orc.writer;

import com.facebook.presto.common.array.Arrays;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.LongArrayBlock;
import com.facebook.presto.common.type.FixedWidthType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.orc.ColumnWriterOptions;
import com.facebook.presto.orc.DwrfDataEncryptor;
import com.facebook.presto.orc.OrcEncoding;
import com.facebook.presto.orc.metadata.ColumnEncoding;
import com.facebook.presto.orc.metadata.MetadataWriter;
import com.facebook.presto.orc.metadata.Stream;
import com.facebook.presto.orc.metadata.statistics.ColumnStatistics;
import com.facebook.presto.orc.metadata.statistics.IntegerStatisticsBuilder;
import com.facebook.presto.orc.stream.LongOutputStream;
import com.facebook.presto.orc.stream.LongOutputStreamDwrf;
import com.facebook.presto.orc.stream.PresentOutputStream;
import com.facebook.presto.orc.stream.StreamDataOutput;
import com.facebook.presto.orc.writer.ColumnWriter;
import com.facebook.presto.orc.writer.DictionaryColumnWriter;
import com.facebook.presto.orc.writer.LongColumnWriter;
import com.facebook.presto.orc.writer.LongDictionaryBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import java.util.List;
import java.util.Optional;
import org.openjdk.jol.info.ClassLayout;

public class LongDictionaryColumnWriter
extends DictionaryColumnWriter {
    private static final long INSTANCE_SIZE = ClassLayout.parseClass(LongDictionaryColumnWriter.class).instanceSize();
    private static final int NULL_INDEX = -1;
    private static final int EXPECTED_ENTRIES = 10000;
    private final int typeSize;
    private LongOutputStream dictionaryDataStream;
    private LongDictionaryBuilder dictionary;
    private IntegerStatisticsBuilder statisticsBuilder;
    private ColumnEncoding columnEncoding;
    private LongColumnWriter directColumnWriter;
    private long[] directValues;
    private boolean[] directNulls;

    public LongDictionaryColumnWriter(int column, Type type, ColumnWriterOptions columnWriterOptions, Optional<DwrfDataEncryptor> dwrfEncryptor, OrcEncoding orcEncoding, MetadataWriter metadataWriter) {
        super(column, type, columnWriterOptions, dwrfEncryptor, orcEncoding, metadataWriter);
        Preconditions.checkArgument((orcEncoding == OrcEncoding.DWRF ? 1 : 0) != 0, (Object)"Long dictionary encoding is only supported in DWRF");
        Preconditions.checkArgument((boolean)(type instanceof FixedWidthType), (Object)"Not a fixed width type");
        this.typeSize = ((FixedWidthType)type).getFixedSize();
        this.dictionaryDataStream = new LongOutputStreamDwrf(columnWriterOptions, dwrfEncryptor, true, Stream.StreamKind.DICTIONARY_DATA);
        this.dictionary = new LongDictionaryBuilder(10000);
        this.statisticsBuilder = new IntegerStatisticsBuilder();
    }

    @Override
    public int getDictionaryEntries() {
        return this.dictionary.size();
    }

    @Override
    public int getDictionaryBytes() {
        return this.dictionary.size() * 8;
    }

    @Override
    protected ColumnWriter createDirectColumnWriter() {
        if (this.directColumnWriter == null) {
            this.directColumnWriter = new LongColumnWriter(this.column, this.type, this.columnWriterOptions, this.dwrfEncryptor, this.orcEncoding, IntegerStatisticsBuilder::new, this.metadataWriter);
        }
        return this.directColumnWriter;
    }

    @Override
    protected ColumnWriter getDirectColumnWriter() {
        Preconditions.checkState((this.directColumnWriter != null ? 1 : 0) != 0);
        return this.directColumnWriter;
    }

    private void resizeDirectArrays(int count) {
        this.directValues = Arrays.ensureCapacity((long[])this.directValues, (int)count);
        this.directNulls = Arrays.ensureCapacity((boolean[])this.directNulls, (int)count);
    }

    @Override
    protected boolean tryConvertRowGroupToDirect(int dictionaryIndexCount, int[] dictionaryIndexes, int maxDirectBytes) {
        if (dictionaryIndexCount == 0) {
            return true;
        }
        this.resizeDirectArrays(dictionaryIndexCount);
        this.convertIntToDirect(dictionaryIndexCount, dictionaryIndexes);
        return this.writeDirect(dictionaryIndexCount, maxDirectBytes);
    }

    @Override
    protected boolean tryConvertRowGroupToDirect(int dictionaryIndexCount, short[] dictionaryIndexes, int maxDirectBytes) {
        if (dictionaryIndexCount == 0) {
            return true;
        }
        this.resizeDirectArrays(dictionaryIndexCount);
        this.convertShortToDirect(dictionaryIndexCount, dictionaryIndexes);
        return this.writeDirect(dictionaryIndexCount, maxDirectBytes);
    }

    @Override
    protected boolean tryConvertRowGroupToDirect(int dictionaryIndexCount, byte[] dictionaryIndexes, int maxDirectBytes) {
        if (dictionaryIndexCount == 0) {
            return true;
        }
        this.resizeDirectArrays(dictionaryIndexCount);
        this.convertByteToDirect(dictionaryIndexCount, dictionaryIndexes);
        return this.writeDirect(dictionaryIndexCount, maxDirectBytes);
    }

    private boolean writeDirect(int dictionaryIndexCount, int maxDirectBytes) {
        LongArrayBlock longArrayBlock = new LongArrayBlock(dictionaryIndexCount, Optional.of(this.directNulls), this.directValues);
        this.directColumnWriter.writeBlock((Block)longArrayBlock);
        return this.directColumnWriter.getBufferedBytes() <= (long)maxDirectBytes;
    }

    private void convertIntToDirect(int dictionaryIndexCount, int[] dictionaryIndexes) {
        for (int i = 0; i < dictionaryIndexCount; ++i) {
            if (dictionaryIndexes[i] != -1) {
                this.directValues[i] = this.dictionary.getValue(dictionaryIndexes[i]);
                this.directNulls[i] = false;
                continue;
            }
            this.directNulls[i] = true;
        }
    }

    private void convertShortToDirect(int dictionaryIndexCount, short[] dictionaryIndexes) {
        for (int i = 0; i < dictionaryIndexCount; ++i) {
            if (dictionaryIndexes[i] != -1) {
                this.directValues[i] = this.dictionary.getValue(dictionaryIndexes[i]);
                this.directNulls[i] = false;
                continue;
            }
            this.directNulls[i] = true;
        }
    }

    private void convertByteToDirect(int dictionaryIndexCount, byte[] dictionaryIndexes) {
        for (int i = 0; i < dictionaryIndexCount; ++i) {
            if (dictionaryIndexes[i] != -1) {
                this.directValues[i] = this.dictionary.getValue(dictionaryIndexes[i]);
                this.directNulls[i] = false;
                continue;
            }
            this.directNulls[i] = true;
        }
    }

    @Override
    protected ColumnEncoding getDictionaryColumnEncoding() {
        Preconditions.checkState((this.columnEncoding != null ? 1 : 0) != 0);
        return this.columnEncoding;
    }

    @Override
    protected DictionaryColumnWriter.BlockStatistics addBlockToDictionary(Block block, int rowGroupOffset, int[] rowGroupIndexes) {
        int nonNullValueCount = 0;
        for (int position = 0; position < block.getPositionCount(); ++position) {
            int index;
            if (block.isNull(position)) {
                index = -1;
            } else {
                long value = this.type.getLong(block, position);
                index = this.dictionary.putIfAbsent(value);
                this.statisticsBuilder.addValue(value);
                ++nonNullValueCount;
            }
            rowGroupIndexes[rowGroupOffset++] = index;
        }
        long rawBytesIncludingNulls = (long)(nonNullValueCount * this.typeSize) + (long)(block.getPositionCount() - nonNullValueCount) * 1L;
        long rawBytesEstimate = 0L;
        if (nonNullValueCount > 0) {
            int perValueBits = 64 - Long.numberOfLeadingZeros(this.statisticsBuilder.getMaximum());
            long perValueBytes = perValueBits / 8 + 1;
            rawBytesEstimate = perValueBytes * (long)nonNullValueCount;
        }
        return new DictionaryColumnWriter.BlockStatistics(nonNullValueCount, rawBytesEstimate, rawBytesIncludingNulls);
    }

    @Override
    protected long getRetainedDictionaryBytes() {
        return INSTANCE_SIZE + this.dictionary.getRetainedBytes() + this.dictionaryDataStream.getRetainedBytes() + SizeOf.sizeOf((long[])this.directValues) + SizeOf.sizeOf((boolean[])this.directNulls) + (this.directColumnWriter == null ? 0L : this.directColumnWriter.getRetainedBytes());
    }

    @Override
    protected Optional<int[]> writeDictionary() {
        long[] elements = this.dictionary.elements();
        for (int i = 0; i < this.dictionary.size(); ++i) {
            this.dictionaryDataStream.writeLong(elements[i]);
        }
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DICTIONARY, this.dictionary.size());
        return Optional.empty();
    }

    @Override
    protected void writePresentAndDataStreams(int rowGroupValueCount, int[] rowGroupIndexes, Optional<int[]> originalDictionaryToSortedIndex, PresentOutputStream presentStream, LongOutputStream dataStream) {
        int position;
        Preconditions.checkArgument((!originalDictionaryToSortedIndex.isPresent() ? 1 : 0) != 0, (Object)"Unsupported originalDictionaryToSortedIndex");
        for (position = 0; position < rowGroupValueCount; ++position) {
            presentStream.writeBoolean(rowGroupIndexes[position] != -1);
        }
        for (position = 0; position < rowGroupValueCount; ++position) {
            int index = rowGroupIndexes[position];
            if (index == -1) continue;
            dataStream.writeLong(index);
        }
    }

    @Override
    protected void writePresentAndDataStreams(int rowGroupValueCount, short[] rowGroupIndexes, Optional<int[]> originalDictionaryToSortedIndex, PresentOutputStream presentStream, LongOutputStream dataStream) {
        int position;
        Preconditions.checkArgument((!originalDictionaryToSortedIndex.isPresent() ? 1 : 0) != 0, (Object)"Unsupported originalDictionaryToSortedIndex");
        for (position = 0; position < rowGroupValueCount; ++position) {
            presentStream.writeBoolean(rowGroupIndexes[position] != -1);
        }
        for (position = 0; position < rowGroupValueCount; ++position) {
            short index = rowGroupIndexes[position];
            if (index == -1) continue;
            dataStream.writeLong(index);
        }
    }

    @Override
    protected void writePresentAndDataStreams(int rowGroupValueCount, byte[] rowGroupIndexes, Optional<int[]> originalDictionaryToSortedIndex, PresentOutputStream presentStream, LongOutputStream dataStream) {
        int position;
        Preconditions.checkArgument((!originalDictionaryToSortedIndex.isPresent() ? 1 : 0) != 0, (Object)"Unsupported originalDictionaryToSortedIndex");
        for (position = 0; position < rowGroupValueCount; ++position) {
            presentStream.writeBoolean(rowGroupIndexes[position] != -1);
        }
        for (position = 0; position < rowGroupValueCount; ++position) {
            byte index = rowGroupIndexes[position];
            if (index == -1) continue;
            dataStream.writeLong(index);
        }
    }

    @Override
    protected List<StreamDataOutput> getDictionaryStreams(int column) {
        return ImmutableList.of((Object)this.dictionaryDataStream.getStreamDataOutput(column));
    }

    @Override
    protected ColumnStatistics createColumnStatistics() {
        ColumnStatistics statistics = this.statisticsBuilder.buildColumnStatistics();
        this.statisticsBuilder = new IntegerStatisticsBuilder();
        return statistics;
    }

    @Override
    protected void closeDictionary() {
        this.dictionary = null;
        this.dictionaryDataStream.close();
    }

    @Override
    protected void resetDictionary() {
        this.columnEncoding = null;
        this.dictionary = new LongDictionaryBuilder(10000);
        this.dictionaryDataStream = new LongOutputStreamDwrf(this.columnWriterOptions, this.dwrfEncryptor, true, Stream.StreamKind.DICTIONARY_DATA);
        this.statisticsBuilder = new IntegerStatisticsBuilder();
        this.directValues = null;
        this.directNulls = null;
    }
}

