/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.raptor.NodeSupplier;
import com.facebook.presto.raptor.RaptorBucketFunction;
import com.facebook.presto.raptor.RaptorPartitioningHandle;
import com.facebook.presto.raptor.RaptorSplit;
import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.connector.ConnectorBucketNodeMap;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.schedule.NodeSelectionStrategy;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;
import javax.inject.Inject;

public class RaptorNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeSupplier nodeSupplier;

    @Inject
    public RaptorNodePartitioningProvider(NodeSupplier nodeSupplier) {
        this.nodeSupplier = Objects.requireNonNull(nodeSupplier, "nodeSupplier is null");
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorPartitioningHandle partitioning, List<Node> sortedNodes) {
        RaptorPartitioningHandle handle = (RaptorPartitioningHandle)partitioning;
        ImmutableMap nodesById = Maps.uniqueIndex(this.nodeSupplier.getWorkerNodes(), Node::getNodeIdentifier);
        ImmutableList.Builder bucketToNode = ImmutableList.builder();
        for (String nodeIdentifier : handle.getBucketToNode()) {
            Node node = (Node)nodesById.get(nodeIdentifier);
            if (node == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "Node for bucket is offline: " + nodeIdentifier);
            }
            bucketToNode.add((Object)node);
        }
        return ConnectorBucketNodeMap.createBucketNodeMap((List)bucketToNode.build(), (NodeSelectionStrategy)NodeSelectionStrategy.HARD_AFFINITY);
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorPartitioningHandle partitioning) {
        return value -> ((RaptorSplit)value).getBucketNumber().getAsInt();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorPartitioningHandle partitioning, List<Type> partitionChannelTypes, int bucketCount) {
        return new RaptorBucketFunction(bucketCount, partitionChannelTypes);
    }

    public int getBucketCount(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        RaptorPartitioningHandle handle = (RaptorPartitioningHandle)partitioningHandle;
        return handle.getBucketToNode().size();
    }
}

