/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor;

import com.facebook.presto.hive.HdfsContext;
import com.facebook.presto.raptor.RaptorColumnHandle;
import com.facebook.presto.raptor.RaptorInsertTableHandle;
import com.facebook.presto.raptor.RaptorOutputTableHandle;
import com.facebook.presto.raptor.RaptorPageSink;
import com.facebook.presto.raptor.RaptorSessionProperties;
import com.facebook.presto.raptor.storage.StorageManager;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.raptor.storage.organization.TemporalFunction;
import com.facebook.presto.spi.ConnectorInsertTableHandle;
import com.facebook.presto.spi.ConnectorOutputTableHandle;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.PageSinkContext;
import com.facebook.presto.spi.PageSorter;
import com.facebook.presto.spi.connector.ConnectorPageSinkProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class RaptorPageSinkProvider
implements ConnectorPageSinkProvider {
    private final StorageManager storageManager;
    private final PageSorter pageSorter;
    private final TemporalFunction temporalFunction;
    private final int maxAllowedFilesPerWriter;

    @Inject
    public RaptorPageSinkProvider(StorageManager storageManager, PageSorter pageSorter, TemporalFunction temporalFunction, StorageManagerConfig config) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.temporalFunction = Objects.requireNonNull(temporalFunction, "temporalFunction is null");
        this.maxAllowedFilesPerWriter = config.getMaxAllowedFilesPerWriter();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Raptor connector does not support page sink commit");
        RaptorOutputTableHandle handle = (RaptorOutputTableHandle)tableHandle;
        return new RaptorPageSink(new HdfsContext(session, handle.getSchemaName(), handle.getTableName()), this.pageSorter, this.storageManager, this.temporalFunction, handle.getTransactionId(), RaptorPageSinkProvider.toColumnIds(handle.getColumnHandles()), handle.getColumnTypes(), RaptorPageSinkProvider.toColumnIds(handle.getSortColumnHandles()), handle.getSortOrders(), handle.getBucketCount(), RaptorPageSinkProvider.toColumnIds(handle.getBucketColumnHandles()), handle.getTemporalColumnHandle(), RaptorSessionProperties.getWriterMaxBufferSize(session), this.maxAllowedFilesPerWriter);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle, PageSinkContext pageSinkContext) {
        Preconditions.checkArgument((!pageSinkContext.isCommitRequired() ? 1 : 0) != 0, (Object)"Raptor connector does not support page sink commit");
        RaptorInsertTableHandle handle = (RaptorInsertTableHandle)tableHandle;
        return new RaptorPageSink(new HdfsContext(session), this.pageSorter, this.storageManager, this.temporalFunction, handle.getTransactionId(), RaptorPageSinkProvider.toColumnIds(handle.getColumnHandles()), handle.getColumnTypes(), RaptorPageSinkProvider.toColumnIds(handle.getSortColumnHandles()), handle.getSortOrders(), handle.getBucketCount(), RaptorPageSinkProvider.toColumnIds(handle.getBucketColumnHandles()), handle.getTemporalColumnHandle(), RaptorSessionProperties.getWriterMaxBufferSize(session), this.maxAllowedFilesPerWriter);
    }

    private static List<Long> toColumnIds(List<RaptorColumnHandle> columnHandles) {
        return columnHandles.stream().map(RaptorColumnHandle::getColumnId).collect(Collectors.toList());
    }
}

