/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.filesystem;

import com.facebook.airlift.configuration.AbstractConfigurationAwareModule;
import com.facebook.airlift.configuration.ConfigBinder;
import com.facebook.airlift.configuration.ConfigurationAwareModule;
import com.facebook.presto.raptor.filesystem.HdfsModule;
import com.facebook.presto.raptor.filesystem.LocalFileSystemModule;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.Map;

public class FileSystemModule
extends AbstractConfigurationAwareModule {
    private final Map<String, Module> providers;

    public FileSystemModule(Map<String, Module> providers) {
        this.providers = ImmutableMap.builder().put((Object)"file", (Object)new LocalFileSystemModule()).put((Object)"hdfs", (Object)new HdfsModule()).putAll(providers).build();
    }

    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(StorageManagerConfig.class);
        String fileSystemProvider = ((StorageManagerConfig)this.buildConfigObject(StorageManagerConfig.class)).getFileSystemProvider();
        Module module = this.providers.get(fileSystemProvider);
        if (module == null) {
            binder.addError("Unsupported file system: %s", new Object[]{fileSystemProvider});
        } else if (module instanceof ConfigurationAwareModule) {
            this.install(module);
        } else {
            binder.install(module);
        }
    }
}

