/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.metadata;

import com.facebook.presto.raptor.util.DatabaseUtil;
import com.google.common.base.MoreObjects;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public final class Table {
    private final long tableId;
    private final OptionalLong distributionId;
    private final Optional<String> distributionName;
    private final OptionalInt bucketCount;
    private final OptionalLong temporalColumnId;
    private final boolean organized;
    private final boolean tableSupportsDeltaDelete;

    public Table(long tableId, OptionalLong distributionId, Optional<String> distributionName, OptionalInt bucketCount, OptionalLong temporalColumnId, boolean organized, boolean tableSupportsDeltaDelete) {
        this.tableId = tableId;
        this.distributionId = Objects.requireNonNull(distributionId, "distributionId is null");
        this.distributionName = Objects.requireNonNull(distributionName, "distributionName is null");
        this.bucketCount = Objects.requireNonNull(bucketCount, "bucketCount is null");
        this.temporalColumnId = Objects.requireNonNull(temporalColumnId, "temporalColumnId is null");
        this.organized = organized;
        this.tableSupportsDeltaDelete = tableSupportsDeltaDelete;
    }

    public long getTableId() {
        return this.tableId;
    }

    public OptionalLong getDistributionId() {
        return this.distributionId;
    }

    public Optional<String> getDistributionName() {
        return this.distributionName;
    }

    public OptionalInt getBucketCount() {
        return this.bucketCount;
    }

    public OptionalLong getTemporalColumnId() {
        return this.temporalColumnId;
    }

    public boolean isOrganized() {
        return this.organized;
    }

    public boolean isTableSupportsDeltaDelete() {
        return this.tableSupportsDeltaDelete;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableId", this.tableId).add("distributionId", this.distributionId.isPresent() ? Long.valueOf(this.distributionId.getAsLong()) : null).add("bucketCount", this.bucketCount.isPresent() ? Integer.valueOf(this.bucketCount.getAsInt()) : null).add("temporalColumnId", this.temporalColumnId.isPresent() ? Long.valueOf(this.temporalColumnId.getAsLong()) : null).add("organized", this.organized).add("tableSupportsDeltaDelete", this.tableSupportsDeltaDelete).omitNullValues().toString();
    }

    public static class TableMapper
    implements ResultSetMapper<Table> {
        public Table map(int index, ResultSet r, StatementContext ctx) throws SQLException {
            return new Table(r.getLong("table_id"), DatabaseUtil.getOptionalLong(r, "distribution_id"), Optional.ofNullable(r.getString("distribution_name")), DatabaseUtil.getOptionalInt(r, "bucket_count"), DatabaseUtil.getOptionalLong(r, "temporal_column_id"), r.getBoolean("organization_enabled"), r.getBoolean("table_supports_delta_delete"));
        }
    }
}

