/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.storage;

import com.facebook.presto.raptor.RaptorSessionProperties;
import com.facebook.presto.raptor.storage.StorageManagerConfig;
import com.facebook.presto.spi.ConnectorSession;
import io.airlift.units.DataSize;
import java.util.Objects;
import javax.inject.Inject;

public class ReaderAttributes {
    private final DataSize maxMergeDistance;
    private final DataSize maxReadSize;
    private final DataSize tinyStripeThreshold;
    private final DataSize streamBufferSize;
    private final boolean lazyReadSmallRanges;
    private final boolean zstdJniDecompressionEnabled;

    @Inject
    public ReaderAttributes(StorageManagerConfig config) {
        this(config.getOrcMaxMergeDistance(), config.getOrcMaxReadSize(), config.getOrcStreamBufferSize(), config.getOrcTinyStripeThreshold(), config.isOrcLazyReadSmallRanges(), config.isZstdJniDecompressionEnabled());
    }

    public ReaderAttributes(DataSize maxMergeDistance, DataSize maxReadSize, DataSize streamBufferSize, DataSize tinyStripeThreshold, boolean lazyReadSmallRanges, boolean zstdJniDecompressionEnabled) {
        this.maxMergeDistance = Objects.requireNonNull(maxMergeDistance, "maxMergeDistance is null");
        this.maxReadSize = Objects.requireNonNull(maxReadSize, "maxReadSize is null");
        this.tinyStripeThreshold = Objects.requireNonNull(tinyStripeThreshold, "tinyStripeThreshold is null");
        this.streamBufferSize = Objects.requireNonNull(streamBufferSize, "streamBufferSize is null");
        this.lazyReadSmallRanges = lazyReadSmallRanges;
        this.zstdJniDecompressionEnabled = zstdJniDecompressionEnabled;
    }

    public DataSize getMaxMergeDistance() {
        return this.maxMergeDistance;
    }

    public DataSize getMaxReadSize() {
        return this.maxReadSize;
    }

    public DataSize getStreamBufferSize() {
        return this.streamBufferSize;
    }

    public DataSize getTinyStripeThreshold() {
        return this.tinyStripeThreshold;
    }

    public boolean isLazyReadSmallRanges() {
        return this.lazyReadSmallRanges;
    }

    public boolean isZstdJniDecompressionEnabled() {
        return this.zstdJniDecompressionEnabled;
    }

    public static ReaderAttributes from(ConnectorSession session) {
        return new ReaderAttributes(RaptorSessionProperties.getReaderMaxMergeDistance(session), RaptorSessionProperties.getReaderMaxReadSize(session), RaptorSessionProperties.getReaderStreamBufferSize(session), RaptorSessionProperties.getReaderTinyStripeThreshold(session), RaptorSessionProperties.isReaderLazyReadSmallRanges(session), RaptorSessionProperties.isZstdJniDecompressionEnabled(session));
    }
}

