/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.raptor.util;

import com.facebook.presto.common.Page;
import com.facebook.presto.spi.ConnectorPageSource;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class ConcatPageSource
implements ConnectorPageSource {
    private final Iterator<ConnectorPageSource> iterator;
    private ConnectorPageSource current;
    private long completedBytes;
    private long completedPositions;
    private long readTimeNanos;

    public ConcatPageSource(Iterator<ConnectorPageSource> iterator) {
        this.iterator = Objects.requireNonNull(iterator, "iterator is null");
    }

    public long getCompletedBytes() {
        this.setup();
        return this.completedBytes + (this.current != null ? this.current.getCompletedBytes() : 0L);
    }

    public long getCompletedPositions() {
        this.setup();
        return this.completedPositions;
    }

    public long getReadTimeNanos() {
        this.setup();
        return this.readTimeNanos + (this.current != null ? this.current.getReadTimeNanos() : 0L);
    }

    public boolean isFinished() {
        this.setup();
        return this.current == null;
    }

    public Page getNextPage() {
        while (true) {
            this.setup();
            if (this.current == null) {
                return null;
            }
            if (!this.current.isFinished()) {
                return this.current.getNextPage();
            }
            this.completedBytes += this.current.getCompletedBytes();
            this.completedPositions += this.current.getCompletedPositions();
            this.readTimeNanos += this.current.getReadTimeNanos();
            this.current = null;
        }
    }

    public long getSystemMemoryUsage() {
        return this.current != null ? this.current.getSystemMemoryUsage() : 0L;
    }

    public void close() throws IOException {
        if (this.current != null) {
            this.current.close();
        }
    }

    private void setup() {
        if (this.current == null && this.iterator.hasNext()) {
            this.current = this.iterator.next();
        }
    }
}

