/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import com.facebook.presto.hive.HiveFileContext;
import com.facebook.presto.hive.filesystem.ExtendedFileSystem;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsServerDefaults;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.AclStatus;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.util.Progressable;

public class HadoopExtendedFileSystem
extends ExtendedFileSystem {
    private FileSystem fs;
    private String swapScheme;

    public HadoopExtendedFileSystem(FileSystem fs) {
        this.fs = fs;
        this.statistics = fs.statistics;
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        String scheme;
        super.initialize(name, conf);
        if (this.fs.getConf() == null) {
            this.fs.initialize(name, conf);
        }
        if (!(scheme = name.getScheme()).equals(this.fs.getUri().getScheme())) {
            this.swapScheme = scheme;
        }
    }

    public FileSystem getRawFileSystem() {
        return this.fs;
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    protected URI getCanonicalUri() {
        return this.fs.getCanonicalUri();
    }

    protected URI canonicalizeUri(URI uri) {
        return this.fs.canonicalizeUri(uri);
    }

    public Path makeQualified(Path path) {
        Path fqPath = this.fs.makeQualified(path);
        if (this.swapScheme != null) {
            try {
                fqPath = new Path(new URI(this.swapScheme, fqPath.toUri().getSchemeSpecificPart(), null));
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return fqPath;
    }

    protected void checkPath(Path path) {
        this.fs.checkPath(path);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.fs.getFileBlockLocations(file, start, len);
    }

    public Path resolvePath(Path p) throws IOException {
        return this.fs.resolvePath(p);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.fs.open(f, bufferSize);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.fs.append(f, bufferSize, progress);
    }

    public void concat(Path f, Path[] psrcs) throws IOException {
        this.fs.concat(f, psrcs);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.fs.create(f, permission, flags, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    @Deprecated
    public FSDataOutputStream createNonRecursive(Path f, FsPermission permission, EnumSet<CreateFlag> flags, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.createNonRecursive(f, permission, flags, bufferSize, replication, blockSize, progress);
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.fs.setReplication(src, replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(src, dst);
    }

    @Override
    public ListenableFuture<Void> renameFileAsync(Path src, Path dst) throws IOException {
        this.fs.rename(src, dst);
        return Futures.immediateFuture(null);
    }

    protected void rename(Path src, Path dst, Options.Rename ... options) throws IOException {
        this.fs.rename(src, dst, options);
    }

    public boolean truncate(Path f, long newLength) throws IOException {
        return this.fs.truncate(f, newLength);
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(f, recursive);
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return this.fs.listStatus(f);
    }

    public RemoteIterator<Path> listCorruptFileBlocks(Path path) throws IOException {
        return this.fs.listCorruptFileBlocks(path);
    }

    public RemoteIterator<LocatedFileStatus> listLocatedStatus(Path f) throws IOException {
        return this.fs.listLocatedStatus(f);
    }

    public RemoteIterator<FileStatus> listStatusIterator(Path f) throws IOException {
        return this.fs.listStatusIterator(f);
    }

    public Path getHomeDirectory() {
        return this.fs.getHomeDirectory();
    }

    public void setWorkingDirectory(Path newDir) {
        this.fs.setWorkingDirectory(newDir);
    }

    public Path getWorkingDirectory() {
        return this.fs.getWorkingDirectory();
    }

    protected Path getInitialWorkingDirectory() {
        return this.fs.getInitialWorkingDirectory();
    }

    public FsStatus getStatus(Path p) throws IOException {
        return this.fs.getStatus(p);
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.fs.mkdirs(f, permission);
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyToLocalFile(delSrc, src, dst);
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.fs.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.fs.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public long getUsed() throws IOException {
        return this.fs.getUsed();
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.fs.getDefaultReplication();
    }

    public FsServerDefaults getServerDefaults() throws IOException {
        return this.fs.getServerDefaults();
    }

    public long getDefaultBlockSize(Path f) {
        return this.fs.getDefaultBlockSize(f);
    }

    public short getDefaultReplication(Path f) {
        return this.fs.getDefaultReplication(f);
    }

    public FsServerDefaults getServerDefaults(Path f) throws IOException {
        return this.fs.getServerDefaults(f);
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.fs.getFileStatus(f);
    }

    public void access(Path path, FsAction mode) throws IOException {
        this.fs.access(path, mode);
    }

    public void createSymlink(Path target, Path link, boolean createParent) throws IOException {
        this.fs.createSymlink(target, link, createParent);
    }

    public FileStatus getFileLinkStatus(Path f) throws IOException {
        return this.fs.getFileLinkStatus(f);
    }

    public boolean supportsSymlinks() {
        return this.fs.supportsSymlinks();
    }

    public Path getLinkTarget(Path f) throws IOException {
        return this.fs.getLinkTarget(f);
    }

    protected Path resolveLink(Path f) throws IOException {
        return this.fs.resolveLink(f);
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.fs.getFileChecksum(f);
    }

    public FileChecksum getFileChecksum(Path f, long length) throws IOException {
        return this.fs.getFileChecksum(f, length);
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.fs.setVerifyChecksum(verifyChecksum);
    }

    public void setWriteChecksum(boolean writeChecksum) {
        this.fs.setWriteChecksum(writeChecksum);
    }

    public Configuration getConf() {
        return this.fs.getConf();
    }

    public void close() throws IOException {
        super.close();
        this.fs.close();
    }

    public void setOwner(Path path, String user, String group) throws IOException {
        this.fs.setOwner(path, user, group);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.fs.setTimes(p, mtime, atime);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.fs.setPermission(p, permission);
    }

    protected FSDataOutputStream primitiveCreate(Path f, FsPermission absolutePermission, EnumSet<CreateFlag> flag, int bufferSize, short replication, long blockSize, Progressable progress, Options.ChecksumOpt checksumOpt) throws IOException {
        return this.fs.primitiveCreate(f, absolutePermission, flag, bufferSize, replication, blockSize, progress, checksumOpt);
    }

    protected boolean primitiveMkdir(Path f, FsPermission abdolutePermission) throws IOException {
        return this.fs.primitiveMkdir(f, abdolutePermission);
    }

    public FileSystem[] getChildFileSystems() {
        return new FileSystem[]{this.fs};
    }

    public Path createSnapshot(Path path, String snapshotName) throws IOException {
        return this.fs.createSnapshot(path, snapshotName);
    }

    public void renameSnapshot(Path path, String snapshotOldName, String snapshotNewName) throws IOException {
        this.fs.renameSnapshot(path, snapshotOldName, snapshotNewName);
    }

    public void deleteSnapshot(Path path, String snapshotName) throws IOException {
        this.fs.deleteSnapshot(path, snapshotName);
    }

    public void modifyAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fs.modifyAclEntries(path, aclSpec);
    }

    public void removeAclEntries(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fs.removeAclEntries(path, aclSpec);
    }

    public void removeDefaultAcl(Path path) throws IOException {
        this.fs.removeDefaultAcl(path);
    }

    public void removeAcl(Path path) throws IOException {
        this.fs.removeAcl(path);
    }

    public void setAcl(Path path, List<AclEntry> aclSpec) throws IOException {
        this.fs.setAcl(path, aclSpec);
    }

    public AclStatus getAclStatus(Path path) throws IOException {
        return this.fs.getAclStatus(path);
    }

    public void setXAttr(Path path, String name, byte[] value) throws IOException {
        this.fs.setXAttr(path, name, value);
    }

    public void setXAttr(Path path, String name, byte[] value, EnumSet<XAttrSetFlag> flag) throws IOException {
        this.fs.setXAttr(path, name, value, flag);
    }

    public byte[] getXAttr(Path path, String name) throws IOException {
        return this.fs.getXAttr(path, name);
    }

    public Map<String, byte[]> getXAttrs(Path path) throws IOException {
        return this.fs.getXAttrs(path);
    }

    public Map<String, byte[]> getXAttrs(Path path, List<String> names) throws IOException {
        return this.fs.getXAttrs(path, names);
    }

    public List<String> listXAttrs(Path path) throws IOException {
        return this.fs.listXAttrs(path);
    }

    public void removeXAttr(Path path, String name) throws IOException {
        this.fs.removeXAttr(path, name);
    }

    @Override
    public RemoteIterator<LocatedFileStatus> listDirectory(Path path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public FSDataInputStream openFile(Path path, HiveFileContext hiveFileContext) throws Exception {
        return this.fs.open(path);
    }
}

