/*
 * Decompiled with CFR 0.152.
 */
package alluxio.concurrent;

import alluxio.shaded.client.com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class CountingLatch {
    private static final int IGNORED_ARG = -1;
    private static final int BLOCK_INC_STATE = -1;
    private Sync mSync = new Sync();

    public void inc() throws InterruptedException {
        this.mSync.acquireSharedInterruptibly(-1);
    }

    public void dec() {
        this.mSync.release(-1);
    }

    public void await() {
        this.mSync.acquire(-1);
    }

    public void release() {
        this.mSync.releaseShared(-1);
    }

    @VisibleForTesting
    int getState() {
        return this.mSync.state();
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 8553010505281724322L;

        private Sync() {
        }

        @Override
        protected boolean tryAcquire(int arg) {
            return this.compareAndSetState(0, -1);
        }

        @Override
        protected boolean tryReleaseShared(int arg) {
            if (!this.compareAndSetState(-1, 0)) {
                throw new Error("state must be -1");
            }
            return true;
        }

        @Override
        protected int tryAcquireShared(int arg) {
            int current;
            do {
                if ((current = this.getState()) != -1) continue;
                return -1;
            } while (!this.compareAndSetState(current, current + 1));
            return 1;
        }

        @Override
        protected boolean tryRelease(int arg) {
            int newState;
            int current;
            do {
                if ((current = this.getState()) > 0) continue;
                throw new Error("state must be > 0");
            } while (!this.compareAndSetState(current, newState = current - 1));
            return newState == 0;
        }

        @VisibleForTesting
        int state() {
            return this.getState();
        }
    }
}

