/*
 * Decompiled with CFR 0.152.
 */
package alluxio.conf;

import alluxio.conf.PropertyKey;
import alluxio.shaded.client.javax.annotation.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RemovedKey {
    private static final String V2_0_0 = "v2.0.0";
    private static final String V2_1_0 = "v2.1.0";
    private static final String V2_3_0 = "v2.3.0";
    private static final String V2_4_0 = "v2.4.0";
    private static final String V2_6_0 = "v2.6.0";
    private static final Map<String, String> REMOVED_KEYS = new HashMap<String, String>(20){
        {
            this.put("alluxio.keyvalue.enabled", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.keyvalue.partition.size.bytes.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.client.socket.cleanup.interval", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.connection.timeout", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.file.async.persist.handler", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.heartbeat.interval", RemovedKey.replacedSince(RemovedKey.V2_0_0, PropertyKey.MASTER_LOST_WORKER_FILE_DETECTION_INTERVAL.getName()));
            this.put("alluxio.master.journal.formatter.class", "v2.0 removed the ability to specify the master journal formatter");
            this.put("alluxio.master.lineage.checkpoint.class", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.lineage.checkpoint.interval", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.lineage.recompute.interval", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.lineage.recompute.log.path", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.master.heartbeat.interval", RemovedKey.replacedSince(RemovedKey.V2_0_0, PropertyKey.MASTER_STANDBY_HEARTBEAT_INTERVAL.getName()));
            this.put("alluxio.master.startup.consistency.check.enabled", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.thrift.shutdown.timeout", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.retry", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.worker.threads.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.worker.threads.min", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.master.embedded.journal.appender.batch.size", RemovedKey.removedSince(RemovedKey.V2_4_0));
            this.put("alluxio.master.embedded.journal.storage.level", RemovedKey.removedSince(RemovedKey.V2_4_0));
            this.put("alluxio.master.embedded.journal.shutdown.timeout", RemovedKey.removedSince(RemovedKey.V2_4_0));
            this.put("alluxio.master.embedded.journal.triggered.snapshot.wait.timeout", RemovedKey.removedSince(RemovedKey.V2_4_0));
            this.put("alluxio.network.netty.heartbeat.timeout", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.network.thrift.frame.size.bytes.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.underfs.object.store.read.retry.base.sleep", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.underfs.object.store.read.retry.max.num", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.underfs.object.store.read.retry.max.sleep", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.underfs.s3a.consistency.timeout", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.security.authentication.socket.timeout", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.security.authentication.socket.timeout.ms", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.block.remote.reader.class", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.block.remote.writer.class", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.block.worker.client.pool.size.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.block.worker.client.threads", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.failed.space.request.limits", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.file.cache.partially.read.block", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.file.copyfromlocal.write.location.policy.class", RemovedKey.replacedSince(RemovedKey.V2_0_0, PropertyKey.USER_FILE_COPYFROMLOCAL_BLOCK_LOCATION_POLICY.getName()));
            this.put("alluxio.user.file.seek.buffer.size.bytes", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.file.write.avoid.eviction.policy.reserved.size.bytes", RemovedKey.replacedSince(RemovedKey.V2_0_0, PropertyKey.USER_BLOCK_AVOID_EVICTION_POLICY_RESERVED_BYTES.getName()));
            this.put("alluxio.user.file.write.location.policy.class", RemovedKey.replacedSince(RemovedKey.V2_0_0, PropertyKey.USER_BLOCK_WRITE_LOCATION_POLICY.getName()));
            this.put("alluxio.user.heartbeat.interval", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.hostname", RemovedKey.replacedSince(RemovedKey.V2_0_0, PropertyKey.LOCALITY_TIER_NODE.getName()));
            this.put("alluxio.user.lineage.enabled", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.lineage.master.client.threads", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.local.reader.packet.size.bytes", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.local.writer.packet.size.bytes", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.channel.pool.disabled", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.channel.pool.gc.threshold", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.channel.pool.size.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.channel.pool.size.min", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.reader.buffer.size.packets", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.reader.packet.size.bytes", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.writer.buffer.size.packets", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.writer.close.timeout", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.netty.writer.packet.size.bytes", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.network.socket.timeout", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.rpc.retry.max.num.retry", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.ufs.delegation.read.buffer.size.bytes", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.ufs.delegation.write.buffer.size.bytes", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.ufs.file.reader.class", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.user.ufs.file.writer.class", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.web.temp.path", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.block.threads.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.block.threads.min", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.data.bind.host", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.data.hostname", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.data.port", RemovedKey.replacedSince(RemovedKey.V2_0_0, PropertyKey.WORKER_RPC_PORT.getName()));
            this.put("alluxio.worker.data.server.class", RemovedKey.removedSince(RemovedKey.V2_6_0));
            this.put("alluxio.worker.filesystem.heartbeat.interval", RemovedKey.removedSince(RemovedKey.V2_1_0));
            this.put("alluxio.worker.file.buffer.size", RemovedKey.removedSince(RemovedKey.V2_6_0));
            this.put("alluxio.worker.file.persist.pool.size", RemovedKey.removedSince(RemovedKey.V2_1_0));
            this.put("alluxio.worker.file.persist.rate.limit", RemovedKey.removedSince(RemovedKey.V2_1_0));
            this.put("alluxio.worker.file.persist.rate.limit.enabled", RemovedKey.removedSince(RemovedKey.V2_1_0));
            this.put("alluxio.worker.memory.size", RemovedKey.replacedSince(RemovedKey.V2_4_0, "alluxio.worker.ramdisk.size"));
            this.put("alluxio.worker.network.netty.async.cache.manager.threads.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.backlog", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.block.reader.threads.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.block.writer.threads.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.buffer.receive", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.buffer.send", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.file.transfer", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.file.writer.threads.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.reader.buffer.size.packets", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.rpc.threads.max", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.shutdown.timeout", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.network.netty.writer.buffer.size.packets", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.tieredstore.reserver.enabled", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.tieredstore.retry", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put("alluxio.worker.evictor.lrfu.attenuation.factor", RemovedKey.removedSince(RemovedKey.V2_3_0));
            this.put("alluxio.worker.evictor.lrfu.step.factor", RemovedKey.removedSince(RemovedKey.V2_3_0));
            this.put("fs.swift.apikey", RemovedKey.replacedSince(RemovedKey.V2_0_0, "fs.swift.password"));
            this.put("fs.swift.use.public.url", RemovedKey.removedSince(RemovedKey.V2_0_0));
            this.put(Template.WORKER_TIERED_STORE_LEVEL_RESERVED_RATIO.format(new Object[]{0}), RemovedKey.replacedSince(RemovedKey.V2_0_0, "alluxio.worker.tieredstore.level0.watermark.{high/low}.ratio"));
            this.put(Template.WORKER_TIERED_STORE_LEVEL_RESERVED_RATIO.format(new Object[]{1}), RemovedKey.replacedSince(RemovedKey.V2_0_0, "alluxio.worker.tieredstore.level1.watermark.{high/low}.ratio"));
            this.put(Template.WORKER_TIERED_STORE_LEVEL_RESERVED_RATIO.format(new Object[]{2}), RemovedKey.replacedSince(RemovedKey.V2_0_0, "alluxio.worker.tieredstore.level2.watermark.{high/low}.ratio"));
            this.put("alluxio.test.removed.key", "This key is used only for testing. It is always removed");
        }
    };

    private static String removedSince(String version) {
        return String.format("this property has been removed since %s.", version);
    }

    private static String replacedSince(String version, String newProperty) {
        return String.format("this property has been removed since %s, use %s instead.", version, newProperty);
    }

    static boolean isRemoved(String key) {
        return RemovedKey.getMessage(key) != null;
    }

    @Nullable
    public static String getMessage(String key) {
        String msg = REMOVED_KEYS.getOrDefault(key, null);
        if (msg != null) {
            return msg;
        }
        for (Template t : Template.TEMPLATES) {
            if (!t.matches(key)) continue;
            return t.mMessage;
        }
        return null;
    }

    private RemovedKey() {
    }

    static final class Template {
        private static final List<Template> TEMPLATES = new ArrayList<Template>();
        public static final Template WORKER_TIERED_STORE_LEVEL_RESERVED_RATIO = new Template("alluxio.worker.tieredstore.level%d.reserved.ratio", "alluxio\\.worker\\.tieredstore\\.level(\\d+)\\.reserved\\.ratio", "The keys associated with this template have been removed");
        private final String mFormat;
        private final Pattern mPattern;
        private final String mMessage;

        private Template(String format, String re, String removalMessage) {
            this.mFormat = format;
            this.mPattern = Pattern.compile(re);
            this.mMessage = removalMessage;
            TEMPLATES.add(this);
        }

        private String format(Object ... o) {
            return String.format(this.mFormat, o);
        }

        private boolean matches(String input) {
            Matcher matcher = this.mPattern.matcher(input);
            return matcher.matches();
        }
    }

    static final class Name {
        public static final String TEST_REMOVED_KEY = "alluxio.test.removed.key";

        Name() {
        }
    }
}

