/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.hive.$internal.jodd.typeconverter;

import com.facebook.presto.hive.$internal.jodd.Jodd;
import com.facebook.presto.hive.$internal.jodd.datetime.JDateTime;
import com.facebook.presto.hive.$internal.jodd.mutable.MutableByte;
import com.facebook.presto.hive.$internal.jodd.mutable.MutableDouble;
import com.facebook.presto.hive.$internal.jodd.mutable.MutableFloat;
import com.facebook.presto.hive.$internal.jodd.mutable.MutableInteger;
import com.facebook.presto.hive.$internal.jodd.mutable.MutableLong;
import com.facebook.presto.hive.$internal.jodd.mutable.MutableShort;
import com.facebook.presto.hive.$internal.jodd.typeconverter.ConvertBean;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConversionException;
import com.facebook.presto.hive.$internal.jodd.typeconverter.TypeConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.ArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.BigDecimalConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.BigIntegerConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.BooleanArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.BooleanConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.ByteArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.ByteConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.CalendarConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.CharacterArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.CharacterConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.ClassArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.ClassConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.CollectionConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.DateConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.DoubleArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.DoubleConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.FileConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.FloatArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.FloatConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.IntegerArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.IntegerConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.JDateTimeConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.LocaleConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.LongArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.LongConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.MutableByteConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.MutableDoubleConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.MutableFloatConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.MutableIntegerConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.MutableLongConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.MutableShortConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.ShortArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.ShortConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.SqlDateConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.SqlTimeConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.SqlTimestampConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.StringArrayConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.StringConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.TimeZoneConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.URIConverter;
import com.facebook.presto.hive.$internal.jodd.typeconverter.impl.URLConverter;
import com.facebook.presto.hive.$internal.jodd.util.ReflectUtil;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeConverterManagerBean {
    private final HashMap<Class, TypeConverter> converters = new HashMap(70);
    protected ConvertBean convertBean = new ConvertBean();

    public ConvertBean getConvertBean() {
        return this.convertBean;
    }

    public TypeConverterManagerBean() {
        this.registerDefaults();
    }

    public void registerDefaults() {
        this.register(String.class, new StringConverter());
        this.register(String[].class, new StringArrayConverter(this));
        IntegerConverter integerConverter = new IntegerConverter();
        this.register(Integer.class, integerConverter);
        this.register(Integer.TYPE, integerConverter);
        this.register(MutableInteger.class, new MutableIntegerConverter(this));
        ShortConverter shortConverter = new ShortConverter();
        this.register(Short.class, shortConverter);
        this.register(Short.TYPE, shortConverter);
        this.register(MutableShort.class, new MutableShortConverter(this));
        LongConverter longConverter = new LongConverter();
        this.register(Long.class, longConverter);
        this.register(Long.TYPE, longConverter);
        this.register(MutableLong.class, new MutableLongConverter(this));
        ByteConverter byteConverter = new ByteConverter();
        this.register(Byte.class, byteConverter);
        this.register(Byte.TYPE, byteConverter);
        this.register(MutableByte.class, new MutableByteConverter(this));
        FloatConverter floatConverter = new FloatConverter();
        this.register(Float.class, floatConverter);
        this.register(Float.TYPE, floatConverter);
        this.register(MutableFloat.class, new MutableFloatConverter(this));
        DoubleConverter doubleConverter = new DoubleConverter();
        this.register(Double.class, doubleConverter);
        this.register(Double.TYPE, doubleConverter);
        this.register(MutableDouble.class, new MutableDoubleConverter(this));
        BooleanConverter booleanConverter = new BooleanConverter();
        this.register(Boolean.class, booleanConverter);
        this.register(Boolean.TYPE, booleanConverter);
        CharacterConverter characterConverter = new CharacterConverter();
        this.register(Character.class, characterConverter);
        this.register(Character.TYPE, characterConverter);
        this.register(byte[].class, new ByteArrayConverter(this));
        this.register(short[].class, new ShortArrayConverter(this));
        this.register(int[].class, new IntegerArrayConverter(this));
        this.register(long[].class, new LongArrayConverter(this));
        this.register(float[].class, new FloatArrayConverter(this));
        this.register(double[].class, new DoubleArrayConverter(this));
        this.register(boolean[].class, new BooleanArrayConverter(this));
        this.register(char[].class, new CharacterArrayConverter(this));
        this.register(Integer[].class, new ArrayConverter<Integer>(this, Integer.class));
        this.register(Long[].class, new ArrayConverter<Long>(this, Long.class));
        this.register(Byte[].class, new ArrayConverter<Byte>(this, Byte.class));
        this.register(Short[].class, new ArrayConverter<Short>(this, Short.class));
        this.register(Float[].class, new ArrayConverter<Float>(this, Float.class));
        this.register(Double[].class, new ArrayConverter<Double>(this, Double.class));
        this.register(Boolean[].class, new ArrayConverter<Boolean>(this, Boolean.class));
        this.register(Character[].class, new ArrayConverter<Character>(this, Character.class));
        this.register(MutableInteger[].class, new ArrayConverter<MutableInteger>(this, MutableInteger.class));
        this.register(MutableLong[].class, new ArrayConverter<MutableLong>(this, MutableLong.class));
        this.register(MutableByte[].class, new ArrayConverter<MutableByte>(this, MutableByte.class));
        this.register(MutableShort[].class, new ArrayConverter<MutableShort>(this, MutableShort.class));
        this.register(MutableFloat[].class, new ArrayConverter<MutableFloat>(this, MutableFloat.class));
        this.register(MutableDouble[].class, new ArrayConverter<MutableDouble>(this, MutableDouble.class));
        this.register(BigDecimal.class, new BigDecimalConverter());
        this.register(BigInteger.class, new BigIntegerConverter());
        this.register(BigDecimal[].class, new ArrayConverter<BigDecimal>(this, BigDecimal.class));
        this.register(BigInteger[].class, new ArrayConverter<BigInteger>(this, BigInteger.class));
        this.register(java.util.Date.class, new DateConverter());
        this.register(Date.class, new SqlDateConverter());
        this.register(Time.class, new SqlTimeConverter());
        this.register(Timestamp.class, new SqlTimestampConverter());
        this.register(Calendar.class, new CalendarConverter());
        this.register(GregorianCalendar.class, new CalendarConverter());
        this.register(JDateTime.class, new JDateTimeConverter());
        this.register(File.class, new FileConverter());
        this.register(Class.class, new ClassConverter());
        this.register(Class[].class, new ClassArrayConverter(this));
        this.register(URI.class, new URIConverter());
        this.register(URL.class, new URLConverter());
        this.register(Locale.class, new LocaleConverter());
        this.register(TimeZone.class, new TimeZoneConverter());
        if (Jodd.isModuleLoaded(13)) {
            Jodd.bind(13, this);
        }
    }

    public void register(Class type, TypeConverter typeConverter) {
        this.convertBean.register(type, typeConverter);
        this.converters.put(type, typeConverter);
    }

    public void unregister(Class type) {
        this.convertBean.register(type, null);
        this.converters.remove(type);
    }

    public TypeConverter lookup(Class type) {
        return this.converters.get(type);
    }

    public <T> T convertType(Object value, Class<T> destinationType) {
        if (destinationType == Object.class) {
            return (T)value;
        }
        TypeConverter converter = this.lookup(destinationType);
        if (converter != null) {
            return converter.convert(value);
        }
        if (value == null) {
            return null;
        }
        if (destinationType.isArray()) {
            ArrayConverter arrayConverter = new ArrayConverter(this, destinationType.getComponentType());
            return (T)arrayConverter.convert(value);
        }
        if (destinationType.isEnum()) {
            T[] enums = destinationType.getEnumConstants();
            String valStr = value.toString();
            for (T e : enums) {
                if (!e.toString().equals(valStr)) continue;
                return e;
            }
        }
        if (ReflectUtil.isInstanceOf(value, destinationType)) {
            return (T)value;
        }
        if (ReflectUtil.isInterfaceImpl(destinationType, Collection.class)) {
            CollectionConverter<Object> collectionConverter = new CollectionConverter<Object>(this, destinationType, Object.class);
            return (T)collectionConverter.convert(value);
        }
        throw new TypeConversionException("Conversion failed: " + destinationType.getName());
    }

    public <T> Collection<T> convertToCollection(Object value, Class<? extends Collection<T>> destinationType, Class componentType) {
        if (value == null) {
            return null;
        }
        if (ReflectUtil.isInstanceOf(value, destinationType)) {
            return (Collection)value;
        }
        if (componentType == null) {
            componentType = Object.class;
        }
        CollectionConverter<Object> collectionConverter = new CollectionConverter<Object>(destinationType, componentType);
        return collectionConverter.convert(value);
    }
}

