/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.presto.hive.$internal.com.google.common.collect.HashMultimap;
import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableMap;
import com.facebook.presto.hive.$internal.com.google.common.collect.ImmutableSet;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.metastore.IHMSHandler;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.BasicTxnInfo;
import org.apache.hadoop.hive.metastore.api.Materialization;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;

public final class MaterializationsInvalidationCache {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializationsInvalidationCache.class);
    private static final MaterializationsInvalidationCache SINGLETON = new MaterializationsInvalidationCache();
    private boolean disable;
    private final ConcurrentMap<String, ConcurrentMap<String, Materialization>> materializations = new ConcurrentHashMap<String, ConcurrentMap<String, Materialization>>();
    private final ConcurrentMap<String, ConcurrentSkipListMap<Long, Long>> tableModifications = new ConcurrentHashMap<String, ConcurrentSkipListMap<Long, Long>>();
    private final ConcurrentMap<String, ConcurrentSkipListSet<Long>> updateDeleteTableModifications = new ConcurrentHashMap<String, ConcurrentSkipListSet<Long>>();
    private boolean initialized;
    private Configuration conf;
    private IHMSHandler handler;

    private MaterializationsInvalidationCache() {
    }

    public static MaterializationsInvalidationCache get() {
        return SINGLETON;
    }

    public synchronized void init(Configuration conf, IHMSHandler handler) {
        this.conf = conf;
        this.handler = handler;
        this.disable = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.MATERIALIZATIONS_INVALIDATION_CACHE_IMPL).equals("DISABLE");
        if (this.disable) {
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            ExecutorService pool = Executors.newCachedThreadPool();
            pool.submit(new Loader());
            pool.shutdown();
        }
    }

    public void createMaterializedView(String dbName, String tableName, Set<String> tablesUsed, String validTxnList) {
        this.addMaterializedView(dbName, tableName, tablesUsed, validTxnList, OpType.CREATE);
    }

    public void alterMaterializedView(String dbName, String tableName, Set<String> tablesUsed, String validTxnList) {
        this.addMaterializedView(dbName, tableName, tablesUsed, validTxnList, OpType.ALTER);
    }

    private void addMaterializedView(String dbName, String tableName, Set<String> tablesUsed, String validTxnList, OpType opType) {
        if (this.disable) {
            return;
        }
        ConcurrentMap<String, Materialization> cq = new ConcurrentHashMap();
        ConcurrentMap prevCq = this.materializations.putIfAbsent(dbName, cq);
        if (prevCq != null) {
            cq = prevCq;
        }
        if (validTxnList == null) {
            return;
        }
        if (opType == OpType.CREATE || opType == OpType.ALTER) {
            Materialization materialization = new Materialization(tablesUsed);
            materialization.setValidTxnList(validTxnList);
            cq.put(tableName, materialization);
        } else {
            ValidTxnWriteIdList txnList = new ValidTxnWriteIdList(validTxnList);
            for (String qNameTableUsed : tablesUsed) {
                ValidWriteIdList tableTxnList = txnList.getTableValidWriteIdList(qNameTableUsed);
                ConcurrentSkipListMap<Long, Long> modificationsTree = new ConcurrentSkipListMap<Long, Long>();
                ConcurrentSkipListMap prevModificationsTree = this.tableModifications.putIfAbsent(qNameTableUsed, modificationsTree);
                if (prevModificationsTree != null) {
                    modificationsTree = prevModificationsTree;
                }
                try {
                    String[] names = qNameTableUsed.split("\\.");
                    BasicTxnInfo e = this.handler.getTxnHandler().getFirstCompletedTransactionForTableAfterCommit(names[0], names[1], tableTxnList);
                    if (e.isIsnull()) continue;
                    modificationsTree.put(e.getTxnid(), e.getTime());
                }
                catch (MetaException ex) {
                    LOG.debug("Materialized view " + Warehouse.getQualifiedName(dbName, tableName) + " ignored; error loading view into invalidation cache", (Throwable)((Object)ex));
                    return;
                }
            }
            Materialization materialization = new Materialization(tablesUsed);
            materialization.setValidTxnList(validTxnList);
            cq.putIfAbsent(tableName, materialization);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cached materialized view for rewriting in invalidation cache: " + Warehouse.getQualifiedName(dbName, tableName));
        }
    }

    public void notifyTableModification(String dbName, String tableName, long txnId, long newModificationTime, boolean isUpdateDelete) {
        if (this.disable) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Notification for table {} in database {} received -> id: {}, time: {}", tableName, dbName, txnId, newModificationTime);
        }
        if (isUpdateDelete) {
            ConcurrentSkipListSet<Long> modificationsSet = new ConcurrentSkipListSet<Long>();
            ConcurrentSkipListSet prevModificationsSet = this.updateDeleteTableModifications.putIfAbsent(Warehouse.getQualifiedName(dbName, tableName), modificationsSet);
            if (prevModificationsSet != null) {
                modificationsSet = prevModificationsSet;
            }
            modificationsSet.add(txnId);
        }
        ConcurrentSkipListMap<Long, Long> modificationsTree = new ConcurrentSkipListMap<Long, Long>();
        ConcurrentSkipListMap prevModificationsTree = this.tableModifications.putIfAbsent(Warehouse.getQualifiedName(dbName, tableName), modificationsTree);
        if (prevModificationsTree != null) {
            modificationsTree = prevModificationsTree;
        }
        modificationsTree.put(txnId, newModificationTime);
    }

    public void dropMaterializedView(String dbName, String tableName) {
        if (this.disable) {
            return;
        }
        ((ConcurrentMap)this.materializations.get(dbName)).remove(tableName);
    }

    public Map<String, Materialization> getMaterializationInvalidationInfo(String dbName, List<String> materializationNames) {
        if (this.materializations.get(dbName) != null) {
            ImmutableMap.Builder<String, Materialization> m = ImmutableMap.builder();
            for (String materializationName : materializationNames) {
                Materialization materialization = (Materialization)((ConcurrentMap)this.materializations.get(dbName)).get(materializationName);
                if (materialization == null) {
                    LOG.debug("Materialization {} skipped as there is no information in the invalidation cache about it", (Object)materializationName);
                    continue;
                }
                Materialization materializationCopy = new Materialization(materialization.getTablesUsed());
                materializationCopy.setValidTxnList(materialization.getValidTxnList());
                this.enrichWithInvalidationInfo(materializationCopy);
                m.put(materializationName, materializationCopy);
            }
            ImmutableMap<String, Materialization> result = m.build();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Retrieved the following materializations from the invalidation cache: {}", (Object)result);
            }
            return result;
        }
        return ImmutableMap.of();
    }

    private void enrichWithInvalidationInfo(Materialization materialization) {
        String materializationTxnListString = materialization.getValidTxnList();
        if (materializationTxnListString == null) {
            materialization.setInvalidationTime(Long.MIN_VALUE);
            return;
        }
        ValidTxnWriteIdList materializationTxnList = new ValidTxnWriteIdList(materializationTxnListString);
        long firstModificationTimeAfterCreation = 0L;
        boolean containsUpdateDelete = false;
        block0: for (String qNameTableUsed : materialization.getTablesUsed()) {
            ValidWriteIdList tableMaterializationTxnList = materializationTxnList.getTableValidWriteIdList(qNameTableUsed);
            ConcurrentSkipListMap usedTableModifications = (ConcurrentSkipListMap)this.tableModifications.get(qNameTableUsed);
            ConcurrentSkipListSet usedUDTableModifications = (ConcurrentSkipListSet)this.updateDeleteTableModifications.get(qNameTableUsed);
            Map.Entry tn = usedTableModifications.higherEntry(tableMaterializationTxnList.getHighWatermark());
            if (tn != null) {
                if (firstModificationTimeAfterCreation == 0L || (Long)tn.getValue() < firstModificationTimeAfterCreation) {
                    firstModificationTimeAfterCreation = (Long)tn.getValue();
                }
                boolean bl = containsUpdateDelete = usedUDTableModifications != null && !usedUDTableModifications.tailSet(tableMaterializationTxnList.getHighWatermark(), false).isEmpty();
            }
            if (tableMaterializationTxnList.getMinOpenWriteId() == null) continue;
            int pos = 0;
            for (Map.Entry t : usedTableModifications.subMap(tableMaterializationTxnList.getMinOpenWriteId(), (Object)tableMaterializationTxnList.getHighWatermark()).entrySet()) {
                while (pos < tableMaterializationTxnList.getInvalidWriteIds().length && tableMaterializationTxnList.getInvalidWriteIds()[pos] != (Long)t.getKey()) {
                    ++pos;
                }
                if (pos >= tableMaterializationTxnList.getInvalidWriteIds().length) continue block0;
                if (firstModificationTimeAfterCreation == 0L || (Long)t.getValue() < firstModificationTimeAfterCreation) {
                    firstModificationTimeAfterCreation = (Long)t.getValue();
                }
                containsUpdateDelete = containsUpdateDelete || usedUDTableModifications != null && usedUDTableModifications.contains(t.getKey());
            }
        }
        materialization.setInvalidationTime(firstModificationTimeAfterCreation);
        materialization.setSourceTablesUpdateDeleteModified(containsUpdateDelete);
    }

    public long cleanup(long minTime) {
        if (this.disable || !this.initialized) {
            return 0L;
        }
        HashMultimap<String, Long> keepTxnInfos = HashMultimap.create();
        for (Map.Entry e : this.materializations.entrySet()) {
            for (Materialization m : ((ConcurrentMap)e.getValue()).values()) {
                ValidTxnWriteIdList txnList = new ValidTxnWriteIdList(m.getValidTxnList());
                boolean canBeDeleted = false;
                String currentTableForInvalidatingTxn = null;
                long currentInvalidatingTxnId = 0L;
                long currentInvalidatingTxnTime = 0L;
                block2: for (String qNameTableUsed : m.getTablesUsed()) {
                    ValidWriteIdList tableTxnList = txnList.getTableValidWriteIdList(qNameTableUsed);
                    Map.Entry tn = ((ConcurrentSkipListMap)this.tableModifications.get(qNameTableUsed)).higherEntry(tableTxnList.getHighWatermark());
                    if (tn != null && (currentInvalidatingTxnTime == 0L || (Long)tn.getValue() < currentInvalidatingTxnTime)) {
                        if (canBeDeleted && currentInvalidatingTxnTime < minTime) {
                            keepTxnInfos.remove(currentTableForInvalidatingTxn, currentInvalidatingTxnId);
                        }
                        canBeDeleted = !keepTxnInfos.get(qNameTableUsed).contains(tn.getKey());
                        keepTxnInfos.put(qNameTableUsed, tn.getKey());
                        currentTableForInvalidatingTxn = qNameTableUsed;
                        currentInvalidatingTxnId = tn.getKey();
                        currentInvalidatingTxnTime = (Long)tn.getValue();
                    }
                    if (tableTxnList.getMinOpenWriteId() == null) continue;
                    int pos = 0;
                    for (Map.Entry t : ((ConcurrentSkipListMap)this.tableModifications.get(qNameTableUsed)).subMap(tableTxnList.getMinOpenWriteId(), (Object)tableTxnList.getHighWatermark()).entrySet()) {
                        while (pos < tableTxnList.getInvalidWriteIds().length && tableTxnList.getInvalidWriteIds()[pos] != (Long)t.getKey()) {
                            ++pos;
                        }
                        if (pos >= tableTxnList.getInvalidWriteIds().length) continue block2;
                        if (currentInvalidatingTxnTime != 0L && (Long)t.getValue() >= currentInvalidatingTxnTime) continue;
                        if (canBeDeleted && currentInvalidatingTxnTime < minTime) {
                            keepTxnInfos.remove(currentTableForInvalidatingTxn, currentInvalidatingTxnId);
                        }
                        canBeDeleted = !keepTxnInfos.get(qNameTableUsed).contains(t.getKey());
                        keepTxnInfos.put(qNameTableUsed, (Long)t.getKey());
                        currentTableForInvalidatingTxn = qNameTableUsed;
                        currentInvalidatingTxnId = (Long)t.getKey();
                        currentInvalidatingTxnTime = (Long)t.getValue();
                    }
                }
            }
        }
        long removed = 0L;
        for (Map.Entry e : this.tableModifications.entrySet()) {
            Collection c = keepTxnInfos.get((String)e.getKey());
            ConcurrentSkipListSet updateDeleteForTable = (ConcurrentSkipListSet)this.updateDeleteTableModifications.get(e.getKey());
            Iterator it = ((ConcurrentSkipListMap)e.getValue()).entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry v = it.next();
                if ((Long)v.getValue() >= minTime || !c.isEmpty() && c.contains(v.getKey())) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Transaction removed from cache for table {} -> id: {}, time: {}", e.getKey(), v.getKey(), v.getValue());
                }
                if (updateDeleteForTable != null) {
                    updateDeleteForTable.remove(v.getKey());
                }
                it.remove();
                ++removed;
            }
        }
        return removed;
    }

    public boolean containsMaterialization(String dbName, String tblName) {
        if (this.disable || dbName == null || tblName == null) {
            return false;
        }
        ConcurrentMap dbMaterializations = (ConcurrentMap)this.materializations.get(dbName);
        return dbMaterializations != null && dbMaterializations.get(tblName) != null;
    }

    private static enum OpType {
        CREATE,
        LOAD,
        ALTER;

    }

    private class Loader
    implements Runnable {
        private Loader() {
        }

        @Override
        public void run() {
            try {
                RawStore store = MaterializationsInvalidationCache.this.handler.getMS();
                for (String catName : store.getCatalogs()) {
                    for (String dbName : store.getAllDatabases(catName)) {
                        for (Table mv : store.getTableObjectsByName(catName, dbName, store.getTables(catName, dbName, null, TableType.MATERIALIZED_VIEW))) {
                            MaterializationsInvalidationCache.this.addMaterializedView(mv.getDbName(), mv.getTableName(), ImmutableSet.copyOf(mv.getCreationMetadata().getTablesUsed()), mv.getCreationMetadata().getValidTxnList(), OpType.LOAD);
                        }
                    }
                }
                LOG.info("Initialized materializations invalidation cache");
            }
            catch (Exception e) {
                LOG.error("Problem connecting to the metastore when initializing the view registry");
            }
        }
    }
}

