/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import com.facebook.presto.hive.;
import com.facebook.presto.hive.$internal.com.google.common.base.Predicate;
import com.facebook.presto.hive.$internal.com.google.common.base.Predicates;
import com.facebook.presto.hive.$internal.com.google.common.collect.Iterables;
import com.facebook.presto.hive.$internal.org.apache.commons.lang.StringUtils;
import com.facebook.presto.hive.$internal.org.slf4j.Logger;
import com.facebook.presto.hive.$internal.org.slf4j.LoggerFactory;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenStore;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class DelegationTokenTool
extends Configured
implements Tool {
    private static Logger LOG = LoggerFactory.getLogger(DelegationTokenTool.class);
    private DelegationTokenStore delegationTokenStore;
    private static String confLocation;
    private OpType opType = OpType.LIST;
    private boolean isDryRun = false;
    private long timeLimitMillis;
    private Predicate<DelegationTokenIdentifier> selectForDeletion = Predicates.alwaysTrue();
    private static final int BATCH_SIZE_DEFAULT = 100;
    private int batchSize = 100;
    private static final long SLEEP_TIME_MILLIS_DEFAULT = 10000L;
    private long sleepTimeMillis = 10000L;
    private HadoopThriftAuthBridge.Server.ServerMode serverMode = HadoopThriftAuthBridge.Server.ServerMode.METASTORE;

    private DelegationTokenTool() {
    }

    public static void main(String[] args) throws Exception {
        System.exit(ToolRunner.run((Tool)new DelegationTokenTool(), (String[])args));
    }

    private void readArgs(String[] args) throws Exception {
        args = new GenericOptionsParser(this.getConf(), args).getRemainingArgs();
        .Options options = new .Options();
        options.addOption(new .Option("confLocation", true, "Location of HCat/Hive Server's hive-site."));
        options.addOption(new .Option("delete", false, "Delete delegation token."));
        options.addOption(new .Option("list", false, "List delegation tokens."));
        options.addOption(new .Option("olderThan", true, "Filter for token's issue-date. (e.g. 3d, 1h or 4m)."));
        options.addOption(new .Option("expired", false, "Select expired delegation tokens for listing/deletion."));
        options.addOption(new .Option("dryRun", false, "Don't actually delete delegation tokens."));
        options.addOption(new .Option("batchSize", true, "Number of tokens to drop between sleep intervals."));
        options.addOption(new .Option("sleepTime", true, "Sleep-time in seconds, between batches of dropped delegation tokens."));
        options.addOption(new .Option("serverMode", true, "The service from which to read delegation tokens. Should be either of [METASTORE, HIVESERVER2]."));
        .CommandLine commandLine = new .GnuParser().parse(options, args, false);
        if (commandLine.hasOption("confLocation")) {
            confLocation = commandLine.getOptionValue("confLocation");
        }
        if (commandLine.hasOption("list")) {
            this.opType = OpType.LIST;
        } else if (commandLine.hasOption("delete")) {
            this.opType = OpType.DELETE;
        } else {
            throw new IllegalArgumentException("Operation must be delete, list or get!");
        }
        this.isDryRun = commandLine.hasOption("dryRun");
        if (commandLine.hasOption("expired")) {
            LOG.info("Working on expired delegation tokens!");
            this.timeLimitMillis = System.currentTimeMillis();
            this.selectForDeletion = new Predicate<DelegationTokenIdentifier>(){

                @Override
                public boolean apply(DelegationTokenIdentifier input) {
                    return DelegationTokenTool.this.timeLimitMillis > input.getMaxDate();
                }
            };
        } else if (commandLine.hasOption("olderThan")) {
            String olderThanLimitString = commandLine.getOptionValue("olderThan");
            switch (olderThanLimitString.charAt(olderThanLimitString.length() - 1)) {
                case 'D': 
                case 'd': {
                    this.timeLimitMillis = System.currentTimeMillis() - (long)(86400000 * Integer.parseInt(olderThanLimitString.substring(0, olderThanLimitString.length() - 1)));
                    break;
                }
                case 'H': 
                case 'h': {
                    this.timeLimitMillis = System.currentTimeMillis() - (long)(3600000 * Integer.parseInt(olderThanLimitString.substring(0, olderThanLimitString.length() - 1)));
                    break;
                }
                case 'M': 
                case 'm': {
                    this.timeLimitMillis = System.currentTimeMillis() - (long)(60000 * Integer.parseInt(olderThanLimitString.substring(0, olderThanLimitString.length() - 1)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported time-limit: " + olderThanLimitString);
                }
            }
            LOG.info("Working on delegation tokens older than current-time (" + this.timeLimitMillis + ").");
            this.selectForDeletion = new Predicate<DelegationTokenIdentifier>(){

                @Override
                public boolean apply(DelegationTokenIdentifier input) {
                    return DelegationTokenTool.this.timeLimitMillis > input.getIssueDate();
                }
            };
        } else if (this.opType == OpType.DELETE) {
            throw new IllegalArgumentException("Attempting to delete tokens. Specify deletion criteria (either expired or time-range).");
        }
        if (commandLine.hasOption("batchSize")) {
            String batchSizeString = commandLine.getOptionValue("batchSize");
            this.batchSize = Integer.parseInt(batchSizeString);
            if (this.batchSize < 1) {
                LOG.warn("Invalid batch-size! (" + this.batchSize + ") Resetting to defaults.");
                this.batchSize = 100;
            }
            LOG.info("Batch-size for drop == " + this.batchSize);
        }
        if (commandLine.hasOption("sleepTime")) {
            String sleepTimeString = commandLine.getOptionValue("sleepTime");
            this.sleepTimeMillis = 1000 * Integer.parseInt(sleepTimeString);
            if (this.sleepTimeMillis <= 0L) {
                LOG.warn("Invalid sleep-time! (" + this.sleepTimeMillis + ") Resetting to defaults.");
                this.sleepTimeMillis = 10000L;
            }
            LOG.info("Sleep between drop-batches: " + this.sleepTimeMillis + " milliseconds.");
        }
        if (commandLine.hasOption("serverMode")) {
            String serverModeString;
            switch (serverModeString = commandLine.getOptionValue("serverMode").toLowerCase()) {
                case "metastore": {
                    this.serverMode = HadoopThriftAuthBridge.Server.ServerMode.METASTORE;
                    break;
                }
                case "hiveserver2": {
                    this.serverMode = HadoopThriftAuthBridge.Server.ServerMode.HIVESERVER2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid value for for serverMode (" + serverModeString + ")Should be either \"METASTORE\", or \"HIVESERVER2\"");
                }
            }
        }
        LOG.info("Running with serverMode == " + (Object)((Object)this.serverMode));
    }

    private void init() throws Exception {
        Configuration conf = new Configuration();
        conf.addResource(new Path(confLocation));
        String tokenStoreClassName = MetastoreConf.getVar(conf, MetastoreConf.ConfVars.DELEGATION_TOKEN_STORE_CLS, "");
        if (StringUtils.isBlank(tokenStoreClassName)) {
            throw new Exception("Could not find Delegation TokenStore implementation.");
        }
        Class<DelegationTokenStore> clazz = Class.forName(tokenStoreClassName).asSubclass(DelegationTokenStore.class);
        this.delegationTokenStore = (DelegationTokenStore)ReflectionUtils.newInstance(clazz, (Configuration)conf);
        this.delegationTokenStore.init(null, this.serverMode);
    }

    private List<DelegationTokenIdentifier> getAllDelegationTokenIDs() throws Exception {
        return this.delegationTokenStore.getAllDelegationTokenIdentifiers();
    }

    private void doList() throws Exception {
        for (DelegationTokenIdentifier tokenId : Iterables.filter(this.getAllDelegationTokenIDs(), this.selectForDeletion)) {
            System.out.println(tokenId.toString());
        }
    }

    private void doDelete() throws Exception {
        int nDeletedTokens = 0;
        List<DelegationTokenIdentifier> allDelegationTokenIDs = this.getAllDelegationTokenIDs();
        for (DelegationTokenIdentifier tokenId : Iterables.filter(allDelegationTokenIDs, this.selectForDeletion)) {
            if (++nDeletedTokens % this.batchSize == 0) {
                LOG.info("Deleted " + nDeletedTokens + "/" + allDelegationTokenIDs.size() + " (" + (long)(100 * nDeletedTokens) / (long)allDelegationTokenIDs.size() + "%). Sleeping for " + this.sleepTimeMillis + "ms...");
                try {
                    Thread.sleep(this.sleepTimeMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            LOG.info("Deleting token: " + tokenId.toString());
            if (this.isDryRun) continue;
            this.delegationTokenStore.removeToken(tokenId);
        }
    }

    public int run(String[] args) throws Exception {
        try {
            this.readArgs(args);
            this.init();
            switch (this.opType) {
                case LIST: {
                    this.doList();
                    break;
                }
                case DELETE: {
                    this.doDelete();
                }
            }
            return 0;
        }
        catch (Exception exception) {
            LOG.error("Unexpected exception: ", exception);
            return -1;
        }
    }

    private static enum OpType {
        DELETE,
        LIST;

    }
}

